/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.datagen;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import piotro15.symbiont.common.registry.ModRegistries;
import piotro15.symbiont.datagen.providers.BiotraitProvider;
import piotro15.symbiont.datagen.providers.CellTypeProvider;
import piotro15.symbiont.datagen.providers.ItemModelProvider;
import piotro15.symbiont.datagen.providers.LanguageProvider;
import piotro15.symbiont.datagen.providers.ModBlockTagsProvider;
import piotro15.symbiont.datagen.providers.ModItemTagsProvider;
import piotro15.symbiont.datagen.providers.RecipeProvider;

@EventBusSubscriber(modid="symbiont")
public class ModDataGenerators {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new RecipeProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(event.includeClient(), output -> new DatapackBuiltinEntriesProvider(output, lookupProvider, new RegistrySetBuilder().add(ModRegistries.CELL_TYPE, CellTypeProvider::registerCellTypes).add(ModRegistries.BIOTRAIT, BiotraitProvider::registerBiotraits), Collections.singleton("symbiont")));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(packOutput, "symbiont", "en_us"));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new ItemModelProvider(packOutput, "symbiont", event.getExistingFileHelper()));
        ModBlockTagsProvider blockTagsProvider = (ModBlockTagsProvider)dataGenerator.addProvider(true, (DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, event.getExistingFileHelper()));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, event.getExistingFileHelper(), blockTagsProvider.contentsGetter()));
    }
}

