/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.datagen.providers;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import piotro15.symbiont.common.genetics.Biotrait;
import piotro15.symbiont.common.genetics.IntegerTraitModifier;
import piotro15.symbiont.common.registry.ModRegistries;

public class BiotraitProvider {
    public static void registerBiotraits(BootstrapContext<Biotrait> bootstrapContext) {
        BiotraitProvider.register(bootstrapContext, "stable_division", new Biotrait(Biotrait.BiotraitType.STABILITY, new IntegerTraitModifier(IntegerTraitModifier.StatType.STABILITY, 1.1)));
        BiotraitProvider.register(bootstrapContext, "light_tissue", new Biotrait(Biotrait.BiotraitType.REPLICATION, new IntegerTraitModifier(IntegerTraitModifier.StatType.GROWTH, 1.1)));
        BiotraitProvider.register(bootstrapContext, "fat_layered", new Biotrait(Biotrait.BiotraitType.METABOLISM, new IntegerTraitModifier(IntegerTraitModifier.StatType.CONSUMPTION, 1.05), new IntegerTraitModifier(IntegerTraitModifier.StatType.PRODUCTION, 1.1)));
        BiotraitProvider.register(bootstrapContext, "photosynthetic", new Biotrait(Biotrait.BiotraitType.METABOLISM, new IntegerTraitModifier(IntegerTraitModifier.StatType.CONSUMPTION, 0.85)));
        BiotraitProvider.register(bootstrapContext, "resilient_membrane", new Biotrait(Biotrait.BiotraitType.REPLICATION, new IntegerTraitModifier(IntegerTraitModifier.StatType.STABILITY, 1.1), new IntegerTraitModifier(IntegerTraitModifier.StatType.GROWTH, 0.85)));
        BiotraitProvider.register(bootstrapContext, "resource_aggression", new Biotrait(Biotrait.BiotraitType.METABOLISM, new IntegerTraitModifier(IntegerTraitModifier.StatType.STABILITY, 0.8), new IntegerTraitModifier(IntegerTraitModifier.StatType.PRODUCTION, 1.4), new IntegerTraitModifier(IntegerTraitModifier.StatType.CONSUMPTION, 1.3)));
        BiotraitProvider.register(bootstrapContext, "selective_uptake", new Biotrait(Biotrait.BiotraitType.METABOLISM, new IntegerTraitModifier(IntegerTraitModifier.StatType.CONSUMPTION, 0.7), new IntegerTraitModifier(IntegerTraitModifier.StatType.STABILITY, 0.85)));
        BiotraitProvider.register(bootstrapContext, "old_world_metabolism", new Biotrait(Biotrait.BiotraitType.METABOLISM, new IntegerTraitModifier(IntegerTraitModifier.StatType.PRODUCTION, 1.8), new IntegerTraitModifier(IntegerTraitModifier.StatType.CONSUMPTION, 2.0), new IntegerTraitModifier(IntegerTraitModifier.StatType.STABILITY, 0.7)));
    }

    private static void register(BootstrapContext<Biotrait> bootstrapContext, String name, Biotrait biotrait) {
        bootstrapContext.register(ResourceKey.create(ModRegistries.BIOTRAIT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)name)), (Object)biotrait);
    }
}

