/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.datagen.providers;

import java.util.Map;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import piotro15.symbiont.common.Symbiont;
import piotro15.symbiont.common.genetics.Biotrait;
import piotro15.symbiont.common.genetics.CellType;
import piotro15.symbiont.common.registry.ModRegistries;

public class CellTypeProvider {
    public static void registerCellTypes(BootstrapContext<CellType> bootstrapContext) {
        CellTypeProvider.register(bootstrapContext, "proto", new CellType.CellTypeBuilder().build());
        CellTypeProvider.register(bootstrapContext, "glucose", new CellType.CellTypeBuilder().build());
        CellTypeProvider.register(bootstrapContext, "poly", new CellType.CellTypeBuilder().setColor(10727818).setTraits(Map.of(Biotrait.BiotraitType.METABOLISM, Symbiont.id("resource_aggression"))).build());
        CellTypeProvider.register(bootstrapContext, "myoblast", new CellType.CellTypeBuilder().build());
        CellTypeProvider.register(bootstrapContext, "marine", new CellType.CellTypeBuilder().setColor(2721888).setTraits(Map.of(Biotrait.BiotraitType.METABOLISM, Symbiont.id("selective_uptake"))).build());
        CellTypeProvider.register(bootstrapContext, "coral", new CellType.CellTypeBuilder().setTraits(Map.of(Biotrait.BiotraitType.METABOLISM, Symbiont.id("photosynthetic"))).build());
        CellTypeProvider.register(bootstrapContext, "bovine", new CellType.CellTypeBuilder().setColor(7294519).build());
        CellTypeProvider.register(bootstrapContext, "ovine", new CellType.CellTypeBuilder().setColor(0xFFFFFF).build());
        CellTypeProvider.register(bootstrapContext, "avian", new CellType.CellTypeBuilder().setColor(14995466).setTraits(Map.of(Biotrait.BiotraitType.REPLICATION, Symbiont.id("light_tissue"))).build());
        CellTypeProvider.register(bootstrapContext, "porcine", new CellType.CellTypeBuilder().setColor(16761035).setTraits(Map.of(Biotrait.BiotraitType.METABOLISM, Symbiont.id("fat_layered"))).build());
        CellTypeProvider.register(bootstrapContext, "leporine", new CellType.CellTypeBuilder().setColor(15718072).build());
        CellTypeProvider.register(bootstrapContext, "mossling", new CellType.CellTypeBuilder().setColor(2721888).setTraits(Map.of(Biotrait.BiotraitType.METABOLISM, Symbiont.id("old_world_metabolism"))).build());
        CellTypeProvider.register(bootstrapContext, "ferric", new CellType.CellTypeBuilder().setColor(12009742).setTraits(Map.of(Biotrait.BiotraitType.REPLICATION, Symbiont.id("stable_division"))).build());
        CellTypeProvider.register(bootstrapContext, "auric", new CellType.CellTypeBuilder().setColor(16766720).setTraits(Map.of(Biotrait.BiotraitType.REPLICATION, Symbiont.id("resilient_membrane"))).build());
    }

    private static void register(BootstrapContext<CellType> bootstrapContext, String name, CellType cellType) {
        bootstrapContext.register(ResourceKey.create(ModRegistries.CELL_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)name)), (Object)cellType);
    }
}

