/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.datagen.providers;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import piotro15.symbiont.client.SymbiontClient;
import piotro15.symbiont.common.Symbiont;
import piotro15.symbiont.common.registry.ModItems;

public class ItemModelProvider
extends net.neoforged.neoforge.client.model.generators.ItemModelProvider {
    public ItemModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerModels() {
        SymbiontClient.fluidTypeExtensions.forEach((fluid, extension) -> this.withExistingParent(((FlowingFluid)fluid.get()).getBucket().toString(), Symbiont.id("item/generic_bucket")));
        this.withExistingParent("metabolizer", Symbiont.id("block/metabolizer"));
        this.withExistingParent("bioreactor", Symbiont.id("block/bioreactor"));
        this.withExistingParent("bioformer", Symbiont.id("block/bioformer"));
        this.withExistingParent("centrifuge", Symbiont.id("block/centrifuge"));
        this.withExistingParent("recombinator", Symbiont.id("block/recombinator"));
        this.basicItem((Item)ModItems.CELL_CULTURE.get());
        this.basicItem((Item)ModItems.ORGANIC_BINDER.get());
        this.basicItem((Item)ModItems.BIOPLASTIC_SHEET.get());
        this.handheldItem((Item)ModItems.BONE_SAMPLER.get());
        this.basicItem((Item)ModItems.BIOTRAIT_EXTRACT.get());
        this.cellCultureItem(Symbiont.id("proto"));
        this.cellCultureItem(Symbiont.id("glucose"));
        this.cellCultureItem(Symbiont.id("myoblast"));
        this.cellCultureItem(Symbiont.id("poly"), Symbiont.id("generic"));
        this.cellCultureItem(Symbiont.id("bovine"), Symbiont.id("animal"));
        this.cellCultureItem(Symbiont.id("ovine"), Symbiont.id("animal"));
        this.cellCultureItem(Symbiont.id("avian"), Symbiont.id("animal"));
        this.cellCultureItem(Symbiont.id("porcine"), Symbiont.id("animal"));
        this.cellCultureItem(Symbiont.id("leporine"), Symbiont.id("animal"));
        this.cellCultureItem(Symbiont.id("mossling"), Symbiont.id("generic_2"));
        this.cellCultureItem(Symbiont.id("marine"), Symbiont.id("circular"));
        this.cellCultureItem(Symbiont.id("coral"), Symbiont.id("generic_2"));
        this.cellCultureItem(Symbiont.id("ferric"), Symbiont.id("metalocell"));
        this.cellCultureItem(Symbiont.id("auric"), Symbiont.id("metalocell"));
    }

    private void cellCultureItem(ResourceLocation itemId) {
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder("cell_type/" + itemId.getPath());
        builder.parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        builder.texture("layer0", ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/cell_type/" + itemId.getPath())));
    }

    private void cellCultureItem(ResourceLocation itemId, ResourceLocation variant) {
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder("cell_type/" + itemId.getPath());
        builder.parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        builder.texture("layer0", ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/cell_type/" + variant.getPath())));
    }
}

