/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.util;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import piotro15.symbiont.util.BarRenderer;

public record EnergyBarRenderer(IntSupplier energy, IntSupplier maxEnergy, int x, int y, int width, int height) implements BarRenderer
{
    private static final ResourceLocation ENERGY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)"textures/gui/energy_storage_16_52.png");

    @Override
    public void render(GuiGraphics gfx, int leftPos, int topPos) {
        int scaled = (int)((float)this.energy.getAsInt() / (float)this.maxEnergy.getAsInt() * (float)this.height);
        gfx.blit(ENERGY_TEXTURE, leftPos + this.x, topPos + this.y + (this.height - scaled), 0.0f, 0.0f, this.width, scaled, this.width, this.height);
    }

    @Override
    public void renderTooltip(GuiGraphics gfx, int leftPos, int topPos, int mouseX, int mouseY) {
        if (mouseX >= leftPos + this.x && mouseX < leftPos + this.x + this.width && mouseY >= topPos + this.y && mouseY < topPos + this.y + this.height) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.literal((String)(this.energy.getAsInt() + " / " + this.maxEnergy.getAsInt() + " RF")));
            gfx.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

