/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.joml.Matrix4f;
import piotro15.symbiont.util.BarRenderer;

public class FluidTankRenderer
implements BarRenderer {
    private static final ResourceLocation FLUID_TANK_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)"textures/gui/fluid_tank_overlay.png");
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final FluidTank tank;
    private final int capacity;

    public FluidTankRenderer(FluidTank inputFluidTank, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.tank = inputFluidTank;
        this.capacity = inputFluidTank.getCapacity();
    }

    public static void renderFluid(GuiGraphics gfx, int x, int y, int width, int height, FluidStack stack, int capacity) {
        if (stack.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
        ResourceLocation fluidTexture = attributes.getStillTexture(stack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidTexture);
        int color = attributes.getTintColor();
        int fluidAmount = stack.getAmount();
        int scaled = (int)((float)fluidAmount / (float)capacity * (float)height);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        FluidTankRenderer.setShaderColor(color);
        gfx.pose().pushPose();
        for (int dy = 0; dy < scaled; dy += 16) {
            int drawHeight = Math.min(16, scaled - dy);
            FluidTankRenderer.drawSprite(x, y + height - dy - drawHeight, 0, width, drawHeight, sprite, gfx.pose());
        }
        gfx.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static void setShaderColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void drawSprite(int x, int y, int z, int width, int height, TextureAtlasSprite sprite, PoseStack matrices) {
        FluidTankRenderer.drawTexturedQuad(sprite.atlasLocation(), matrices, x, x + width, y, y + height, z, sprite);
    }

    private static void drawTexturedQuad(ResourceLocation texture, PoseStack matrices, int x1, int x2, int y1, int y2, int z, TextureAtlasSprite textureSprite) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        vMin -= ((float)(y2 - y1) - 16.0f) / 16.0f * (vMax - vMin);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = matrices.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y1, (float)z).setUv(uMin, vMin).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y2, (float)z).setUv(uMin, vMax).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y2, (float)z).setUv(uMax, vMax).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y1, (float)z).setUv(uMax, vMin).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    @Override
    public void render(GuiGraphics gfx, int x, int y) {
        FluidTankRenderer.renderFluid(gfx, x + this.x, y + this.y, this.width, this.height, this.tank.getFluid(), this.capacity);
    }

    @Override
    public void renderTooltip(GuiGraphics gfx, int leftPos, int topPos, int mouseX, int mouseY) {
        if (mouseX >= leftPos + this.x && mouseX < leftPos + this.x + this.width && mouseY >= topPos + this.y && mouseY < topPos + this.y + this.height) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (this.tank.getFluid().getAmount() > 0) {
                tooltip.add(this.tank.getFluid().getHoverName());
            }
            tooltip.add(Component.literal((String)(this.tank.getFluid().getAmount() + " / " + this.tank.getCapacity() + " mB")));
            gfx.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public void renderOverlay(GuiGraphics gfx, int leftPos, int topPos) {
        gfx.blit(FLUID_TANK_OVERLAY, leftPos + this.x, topPos + this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }
}

