/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.util;

import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FluidUtils {

    public record CombinedFluidHandler(FluidTank input, FluidTank output) implements IFluidHandler
    {
        public int getTanks() {
            return 2;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? this.input.getFluid() : (tank == 1 ? this.output.getFluid() : FluidStack.EMPTY);
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? this.input.getCapacity() : (tank == 1 ? this.output.getCapacity() : 0);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return true;
        }

        public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return 0;
            }
            return this.input.fill(resource, action);
        }

        @NotNull
        public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack out = this.output.getFluid();
            if (FluidStack.isSameFluid((FluidStack)resource, (FluidStack)out)) {
                return this.output.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
            return this.output.drain(maxDrain, action);
        }
    }
}

