/*
 * Decompiled with CFR 0.152.
 */
package wtf.wooly.CrystalDamageModifier.commands;

import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wtf.wooly.CrystalDamageModifier.CrystalDamageModifier;

public class CrystalDamage
implements CommandExecutor,
TabCompleter {
    private static final String ADMIN_PERM = "crystaldamage.admin";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender.hasPermission(ADMIN_PERM)) {
            CrystalDamageModifier plugin = CrystalDamageModifier.getPlugin();
            if (args.length == 0) {
                sender.sendMessage("Current end crystal/respawn anchor damage factor: " + plugin.getConfig().getDouble("damage-factor"));
                return false;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                plugin.reloadConfig();
                return true;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
                try {
                    double damage = Double.parseDouble(args[1]);
                    plugin.getConfig().set("damage-factor", (Object)damage);
                    plugin.saveConfig();
                    sender.sendMessage("Crystal/respawn anchor damage factor set to " + damage);
                    return true;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("Invalid number!");
                    return false;
                }
            }
            sender.sendMessage("Invalid option.");
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender.hasPermission(ADMIN_PERM)) {
            if (args.length == 1) {
                return List.of("reload", "set");
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
                return List.of("1.0");
            }
        }
        return List.of();
    }
}

