/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.orbit.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.mayaqq.orbit.Orbit;
import dev.mayaqq.orbit.data.OrbitButton;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003R\u001c\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001c\u0010\r\u001a\n \t*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\n \t*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000eR\u001c\u0010\u0011\u001a\n \t*\u0004\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006#"}, d2={"Ldev/mayaqq/orbit/config/OrbitConfig;", "", "<init>", "()V", "", "load", "save", "saveAndLoad", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "config", "Ljava/nio/file/Path;", "Ljava/io/File;", "buttons", "Ljava/io/File;", "configFile", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "Ldev/mayaqq/orbit/config/OrbitConfig$Config;", "CONFIG", "Ldev/mayaqq/orbit/config/OrbitConfig$Config;", "getCONFIG", "()Ldev/mayaqq/orbit/config/OrbitConfig$Config;", "setCONFIG", "(Ldev/mayaqq/orbit/config/OrbitConfig$Config;)V", "", "Ldev/mayaqq/orbit/data/OrbitButton;", "BUTTONS", "Ljava/util/List;", "getBUTTONS", "()Ljava/util/List;", "setBUTTONS", "(Ljava/util/List;)V", "Config", "Orbit"})
@SourceDebugExtension(value={"SMAP\nOrbitConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrbitConfig.kt\ndev/mayaqq/orbit/config/OrbitConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1#2:74\n1878#3,3:75\n*S KotlinDebug\n*F\n+ 1 OrbitConfig.kt\ndev/mayaqq/orbit/config/OrbitConfig\n*L\n54#1:75,3\n*E\n"})
public final class OrbitConfig {
    @NotNull
    public static final OrbitConfig INSTANCE = new OrbitConfig();
    private static final Path config = FabricLoader.getInstance().getConfigDir().resolve("orbit");
    private static final File buttons = config.resolve("buttons.json").toFile();
    private static final File configFile = config.resolve("config.json").toFile();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    @NotNull
    private static Config CONFIG = new Config(0, 1, null);
    @NotNull
    private static List<OrbitButton> BUTTONS = CollectionsKt.emptyList();

    private OrbitConfig() {
    }

    @NotNull
    public final Config getCONFIG() {
        return CONFIG;
    }

    public final void setCONFIG(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        CONFIG = config;
    }

    @NotNull
    public final List<OrbitButton> getBUTTONS() {
        return BUTTONS;
    }

    public final void setBUTTONS(@NotNull List<OrbitButton> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        BUTTONS = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        Unit unit;
        FileReader it;
        Path path = config;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"config");
        Object object = path;
        Object object2 = new LinkOption[]{};
        if (!Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
            Path path2 = config;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"config");
            object = path2;
            object2 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectory((Path)object, (FileAttribute[])Arrays.copyOf(object2, ((Object[])object2).length)), (String)"createDirectory(...)");
        }
        if (!configFile.exists()) {
            configFile.createNewFile();
            this.save();
        } else {
            object = new FileReader(configFile);
            object2 = null;
            try {
                it = (FileReader)object;
                boolean bl = false;
                Config json = (Config)gson.fromJson((Reader)it, Config.class);
                Intrinsics.checkNotNull((Object)json);
                CONFIG = json;
                it = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                object2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        if (!buttons.exists()) {
            buttons.createNewFile();
            this.save();
        } else {
            object = new FileReader(buttons);
            object2 = null;
            try {
                it = (FileReader)object;
                boolean bl = false;
                Object object3 = gson.fromJson((Reader)it, OrbitButton[].class);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
                BUTTONS = ArraysKt.toList((Object[])((Object[])object3));
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        int n = CONFIG.getButtonCount();
        unit = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            Unit unit2 = unit;
            boolean bl = false;
            unit2.add(new OrbitButton(null, null, null, null, 15, null));
        }
        List defaultButtons = (List)unit;
        if (BUTTONS.isEmpty()) {
            BUTTONS = defaultButtons;
        } else if (BUTTONS.size() < CONFIG.getButtonCount()) {
            BUTTONS = CollectionsKt.plus((Collection)BUTTONS, (Iterable)defaultButtons.subList(BUTTONS.size(), CONFIG.getButtonCount()));
        }
        Orbit.INSTANCE.setButtons(BUTTONS.subList(0, CONFIG.getButtonCount()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void save() {
        List buttonList = CollectionsKt.toMutableList((Collection)BUTTONS);
        Iterable $this$forEachIndexed$iv = Orbit.INSTANCE.getButtons();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void button;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OrbitButton orbitButton = (OrbitButton)item$iv;
            int index = n;
            boolean bl = false;
            buttonList.set(index, button);
        }
        BUTTONS = buttonList;
        Closeable closeable = new FileWriter(configFile);
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)closeable;
            boolean bl = false;
            gson.toJson((Object)CONFIG, (Appendable)it);
            it = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = new FileWriter(buttons);
        throwable = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            gson.toJson(BUTTONS, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void saveAndLoad() {
        this.save();
        this.load();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\u0005\u00a8\u0006\u0015"}, d2={"Ldev/mayaqq/orbit/config/OrbitConfig$Config;", "", "", "buttonCount", "<init>", "(I)V", "component1", "()I", "copy", "(I)Ldev/mayaqq/orbit/config/OrbitConfig$Config;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getButtonCount", "setButtonCount", "Orbit"})
    public static final class Config {
        private int buttonCount;

        public Config(int buttonCount) {
            this.buttonCount = buttonCount;
        }

        public /* synthetic */ Config(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 8;
            }
            this(n);
        }

        public final int getButtonCount() {
            return this.buttonCount;
        }

        public final void setButtonCount(int n) {
            this.buttonCount = n;
        }

        public final int component1() {
            return this.buttonCount;
        }

        @NotNull
        public final Config copy(int buttonCount) {
            return new Config(buttonCount);
        }

        public static /* synthetic */ Config copy$default(Config config, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = config.buttonCount;
            }
            return config.copy(n);
        }

        @NotNull
        public String toString() {
            return "Config(buttonCount=" + this.buttonCount + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.buttonCount);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            return this.buttonCount == config.buttonCount;
        }

        public Config() {
            this(0, 1, null);
        }
    }
}

