/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.orbit.screen;

import dev.mayaqq.orbit.data.IconType;
import dev.mayaqq.orbit.data.OrbitButton;
import dev.mayaqq.orbit.data.OrbitButtonAction;
import dev.mayaqq.orbit.screen.KeybindSelectionScreen;
import dev.mayaqq.orbit.screen.OrbitBaseScreen;
import dev.mayaqq.orbit.utils.McClient;
import dev.mayaqq.orbit.utils.Text;
import earth.terrarium.olympus.client.components.Widgets;
import earth.terrarium.olympus.client.components.base.renderer.WidgetRenderer;
import earth.terrarium.olympus.client.components.buttons.Button;
import earth.terrarium.olympus.client.components.dropdown.DropdownBuilder;
import earth.terrarium.olympus.client.components.dropdown.DropdownState;
import earth.terrarium.olympus.client.components.renderers.WidgetRenderers;
import earth.terrarium.olympus.client.components.textbox.TextBox;
import earth.terrarium.olympus.client.layouts.Layouts;
import earth.terrarium.olympus.client.layouts.LinearViewLayout;
import earth.terrarium.olympus.client.ui.OverlayAlignment;
import earth.terrarium.olympus.client.ui.UIConstants;
import earth.terrarium.olympus.client.utils.State;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2561;
import net.minecraft.class_8021;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\bR\u0016\u0010\f\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R8\u0010\u0014\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000e0\u000e \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0017\u001a\n \u0013*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R8\u0010\u0019\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000e0\u000e \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0015R\u001c\u0010\u001a\u001a\n \u0013*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001b"}, d2={"Ldev/mayaqq/orbit/screen/ConfigurationScreen;", "Ldev/mayaqq/orbit/screen/OrbitBaseScreen;", "Ldev/mayaqq/orbit/data/OrbitButton;", "button", "<init>", "(Ldev/mayaqq/orbit/data/OrbitButton;)V", "", "populate", "()V", "onClose", "save", "Ldev/mayaqq/orbit/data/OrbitButtonAction;", "action", "Ldev/mayaqq/orbit/data/OrbitButtonAction;", "", "icon", "Ljava/lang/String;", "actionString", "Learth/terrarium/olympus/client/utils/State;", "kotlin.jvm.PlatformType", "iconState", "Learth/terrarium/olympus/client/utils/State;", "Learth/terrarium/olympus/client/components/textbox/TextBox;", "iconWidget", "Learth/terrarium/olympus/client/components/textbox/TextBox;", "actionStringState", "actionStringWidget", "Orbit"})
public final class ConfigurationScreen
extends OrbitBaseScreen {
    @NotNull
    private OrbitButtonAction action;
    @NotNull
    private String icon;
    @NotNull
    private String actionString;
    private final State<String> iconState;
    private final TextBox iconWidget;
    private final State<String> actionStringState;
    private final TextBox actionStringWidget;

    public ConfigurationScreen(@NotNull OrbitButton button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        super(button, (class_2561)Text.INSTANCE.trans("orbit.screen.configure"));
        this.action = button.getAction();
        this.icon = button.getIconItem();
        this.actionString = button.getActionString();
        this.iconState = State.of((Object)this.icon);
        this.iconWidget = Widgets.textInput(this.iconState);
        this.actionStringState = State.of((Object)this.actionString);
        this.actionStringWidget = Widgets.textInput(this.actionStringState);
    }

    @Override
    public void populate() {
        LinearViewLayout column = Layouts.column();
        DropdownState dropdownState = DropdownState.of((Object)((Object)this.action));
        Button mode = Widgets.dropdown((DropdownState)dropdownState, (List)((List)OrbitButtonAction.getEntries()), ConfigurationScreen::populate$lambda$0, ConfigurationScreen::populate$lambda$1, arg_0 -> ConfigurationScreen.populate$lambda$2(this, arg_0));
        column.withChild((class_8021)mode);
        LinearViewLayout iconRow = Layouts.row();
        this.iconWidget.withSize(180, 20);
        this.iconWidget.withPlaceholder(Text.INSTANCE.trans("orbit.option.item_id").getString());
        iconRow.withChild((class_8021)this.iconWidget);
        DropdownState iconTypeState = DropdownState.of((Object)((Object)this.getOrbitButton().getIconType()));
        Button iconType = Widgets.dropdown((DropdownState)iconTypeState, (List)((List)IconType.getEntries()), ConfigurationScreen::populate$lambda$3, ConfigurationScreen::populate$lambda$4, arg_0 -> ConfigurationScreen.populate$lambda$5(this, arg_0));
        iconRow.withChild((class_8021)iconType);
        iconRow.method_48222();
        column.withChild((class_8021)iconRow);
        this.actionStringWidget.withPlaceholder(Text.INSTANCE.trans("orbit.option.action").getString());
        this.actionStringWidget.withSize(200, 20);
        column.withChild((class_8021)this.actionStringWidget);
        Button keybindButton = Widgets.button();
        keybindButton.method_55445(200, 20);
        keybindButton.withTexture(UIConstants.BUTTON);
        keybindButton.withRenderer((WidgetRenderer)WidgetRenderers.text((class_2561)((class_2561)Text.INSTANCE.trans("orbit.button.select_key"))).withCenterAlignment());
        keybindButton.withCallback(() -> ConfigurationScreen.populate$lambda$6(this));
        if (this.action != OrbitButtonAction.PRESS_KEY) {
            keybindButton.asDisabled();
        }
        column.withChild((class_8021)keybindButton);
        column.method_48222();
        this.getLayout().method_48999((class_8021)column);
    }

    @Override
    public void method_25419() {
        this.save();
        super.method_25419();
    }

    private final void save() {
        String string = this.actionStringWidget.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        this.actionString = string;
        String string2 = this.iconWidget.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        this.icon = string2;
        this.getOrbitButton().setAction(this.action);
        this.getOrbitButton().setIconItem(this.icon);
        this.getOrbitButton().setActionString(this.actionString);
    }

    private static final class_2561 populate$lambda$0(OrbitButtonAction action) {
        return (class_2561)Text.INSTANCE.trans(action.getTranskey());
    }

    private static final void populate$lambda$1(Button button) {
        button.withSize(200, 20);
    }

    private static final void populate$lambda$2(ConfigurationScreen this$0, DropdownBuilder builder) {
        builder.withCallback(arg_0 -> ConfigurationScreen.populate$lambda$2$0(this$0, arg_0));
        builder.withAlignment(OverlayAlignment.TOP_LEFT);
    }

    private static final void populate$lambda$2$0(ConfigurationScreen this$0, OrbitButtonAction it) {
        Intrinsics.checkNotNull((Object)((Object)it));
        this$0.action = it;
        this$0.method_41843();
    }

    private static final class_2561 populate$lambda$3(IconType action) {
        return (class_2561)Text.INSTANCE.trans(action.getTranskey());
    }

    private static final void populate$lambda$4(Button button) {
        button.withSize(20, 20);
    }

    private static final void populate$lambda$5(ConfigurationScreen this$0, DropdownBuilder builder) {
        builder.withCallback(arg_0 -> ConfigurationScreen.populate$lambda$5$0(this$0, arg_0));
        builder.withAlignment(OverlayAlignment.TOP_LEFT);
        builder.withSize(150, 40);
    }

    private static final void populate$lambda$5$0(ConfigurationScreen this$0, IconType it) {
        OrbitButton orbitButton = this$0.getOrbitButton();
        Intrinsics.checkNotNull((Object)((Object)it));
        orbitButton.setIconType(it);
        this$0.method_41843();
    }

    private static final void populate$lambda$6(ConfigurationScreen this$0) {
        this$0.save();
        McClient.INSTANCE.setScreen(new KeybindSelectionScreen(this$0.getOrbitButton()));
    }
}

