/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.createcolored.content.block;

import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.fabricators_of_create.porting_lib.util.TagUtil;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import us.mikebartosh.minecraft.createcolored.content.block.ColoredBlocks;
import us.mikebartosh.minecraft.createcolored.content.block.ColoredFluidTankBlock;
import us.mikebartosh.minecraft.createcolored.content.block.ColoredGlassFluidPipeBlock;
import us.mikebartosh.minecraft.createcolored.content.block.IColoredBlock;
import us.mikebartosh.minecraft.createcolored.content.blockEntities.ColoredBlockEntities;

public class ColoredFluidPipeBlock
extends FluidPipeBlock
implements IColoredBlock {
    protected final class_1767 color;

    public ColoredFluidPipeBlock(class_4970.class_2251 properties, class_1767 color) {
        super(properties);
        this.color = color;
    }

    public static class_2680 updateConnections(class_1920 world, class_2338 pos, class_2680 state, @Nullable class_2350 ignored) {
        class_2680 newState = state;
        for (class_2350 d : Iterate.directions) {
            if (d == ignored) continue;
            boolean shouldConnect = ColoredFluidPipeBlock.canConnectToColored(world, pos, state, d);
            newState = (class_2680)newState.method_11657((class_2769)field_11329.get(d), (Comparable)Boolean.valueOf(shouldConnect));
        }
        return newState;
    }

    public static boolean canConnectToColored(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
        FluidTransportBehaviour transport;
        class_2338 neighbourPos = pos.method_10093(direction);
        class_2680 neighbourState = world.method_8320(neighbourPos);
        if (ColoredFluidTankBlock.isColoredTank(neighbourState)) {
            ColoredFluidPipeBlock block = (ColoredFluidPipeBlock)state.method_26204();
            ColoredFluidTankBlock other = (ColoredFluidTankBlock)neighbourState.method_26204();
            if (block.color != other.color) {
                return false;
            }
        }
        if (FluidPropagator.hasFluidCapability((class_1922)world, (class_2338)neighbourPos, (class_2350)direction.method_10153())) {
            return true;
        }
        if (VanillaFluidTargets.canProvideFluidWithoutCapability((class_2680)neighbourState)) {
            return true;
        }
        BracketedBlockEntityBehaviour bracket = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((class_1922)world, (class_2338)neighbourPos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE);
        if (ColoredFluidPipeBlock.isPipe((class_2680)neighbourState)) {
            if (ColoredFluidPipeBlock.isColoredPipe(neighbourState) && !ColoredFluidPipeBlock.sameColor(state, neighbourState)) {
                return false;
            }
            return bracket == null || !bracket.isBracketPresent() || FluidPropagator.getStraightPipeAxis((class_2680)neighbourState) == direction.method_10166();
        }
        class_2248 class_22482 = neighbourState.method_26204();
        if (class_22482 instanceof ColoredGlassFluidPipeBlock) {
            ColoredGlassFluidPipeBlock glassPipe = (ColoredGlassFluidPipeBlock)class_22482;
            if (!ColoredFluidPipeBlock.sameColor(state, ColoredBlocks.DYED_PIPES.get(glassPipe.color).getDefaultState())) {
                return false;
            }
        }
        if ((transport = (FluidTransportBehaviour)BlockEntityBehaviour.get((class_1922)world, (class_2338)neighbourPos, (BehaviourType)FluidTransportBehaviour.TYPE)) == null) {
            return false;
        }
        return transport.canHaveFlowToward(neighbourState, direction.method_10153());
    }

    public static class_2680 addOppositeSide(class_2680 state, class_2350 dir) {
        return (class_2680)((class_2680)state.method_11657((class_2769)field_11329.get(dir), (Comparable)Boolean.valueOf(true))).method_11657((class_2769)field_11329.get(dir.method_10153()), (Comparable)Boolean.valueOf(true));
    }

    public static boolean sameColor(class_2680 state, class_2680 neighbour) {
        return state.method_26204().equals(neighbour.method_26204());
    }

    public static boolean isColoredPipe(class_2680 state) {
        return state.method_26204() instanceof ColoredFluidPipeBlock;
    }

    public static boolean isColoredGlassPipe(class_2680 state) {
        return state.method_26204() instanceof ColoredGlassFluidPipeBlock;
    }

    public static boolean shouldDrawCasing(class_2680 state) {
        if (!ColoredFluidPipeBlock.isColoredPipe(state)) {
            return false;
        }
        for (class_2350.class_2351 axis : Iterate.axes) {
            int connections = 0;
            for (class_2350 direction : Iterate.directions) {
                if (direction.method_10166() == axis || !ColoredFluidPipeBlock.isOpenAt((class_2680)state, (class_2350)direction)) continue;
                ++connections;
            }
            if (connections <= 2) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldDrawRim(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
        class_2338 offsetPos = pos.method_10093(direction);
        class_2680 facingState = world.method_8320(offsetPos);
        if (facingState.method_26204() instanceof EncasedPipeBlock) {
            return true;
        }
        if (!ColoredFluidPipeBlock.canConnectToColored(world, pos, state, direction)) {
            return true;
        }
        return !ColoredFluidPipeBlock.isColoredPipe(facingState);
    }

    @Override
    public class_1767 getColor() {
        return this.color;
    }

    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (this.tryRemoveBracket(context)) {
            return class_1269.field_5812;
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 clickedFace = context.method_8038();
        class_2350.class_2351 axis = this.getAxis(state);
        if (axis == null) {
            class_243 clickLocation = context.method_17698().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            double closest = 3.4028234663852886E38;
            class_2350 argClosest = class_2350.field_11036;
            for (class_2350 direction : Iterate.directions) {
                class_243 centerOf;
                double distance;
                if (clickedFace.method_10166() == direction.method_10166() || !((distance = (centerOf = class_243.method_24953((class_2382)direction.method_10163())).method_1025(clickLocation)) < closest)) continue;
                closest = distance;
                argClosest = direction;
            }
            axis = argClosest.method_10166();
        }
        if (clickedFace.method_10166() == axis) {
            return class_1269.field_5811;
        }
        if (!world.field_9236) {
            this.withBlockEntityDo((class_1922)world, pos, fpte -> ((FluidTransportBehaviour)fpte.getBehaviour((BehaviourType)FluidTransportBehaviour.TYPE)).interfaces.values().stream().filter(pc -> pc != null && pc.hasFlow()).findAny().ifPresent($ -> AllAdvancements.GLASS_PIPE.awardTo(context.method_8036())));
            FluidTransportBehaviour.cacheFlows((class_1936)world, (class_2338)pos);
            world.method_8501(pos, (class_2680)((class_2680)ColoredBlocks.DYED_GLASS_PIPES.get(this.color).getDefaultState().method_11657((class_2769)GlassFluidPipeBlock.field_11459, (Comparable)axis)).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508))));
            FluidTransportBehaviour.loadFlows((class_1936)world, (class_2338)pos);
        }
        return class_1269.field_5812;
    }

    @Nullable
    private class_2350.class_2351 getAxis(class_2680 state) {
        return FluidPropagator.getStraightPipeAxis((class_2680)state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 ray) {
        class_1799 heldItem = player.method_5998(hand);
        class_1767 color = TagUtil.getColorFromStack((class_1799)heldItem);
        if (color != null) {
            if (!world.field_9236) {
                world.method_8396(null, pos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.1f - world.field_9229.method_43057() * 0.2f);
            }
            this.applyDye(state, world, pos, color);
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, ray);
    }

    public void applyDye(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_1767 color) {
        class_2680 newState = (color == null ? ColoredBlocks.DYED_PIPES.get(class_1767.field_7952) : ColoredBlocks.DYED_PIPES.get(color)).getDefaultState();
        if (state != (newState = this.updateBlockState(newState, class_2350.field_11036, null, (class_1920)world, pos))) {
            world.method_8501(pos, newState);
        }
    }

    public class_2680 updateBlockState(class_2680 state, class_2350 preferredDirection, @Nullable class_2350 ignore, class_1920 world, class_2338 pos) {
        BracketedBlockEntityBehaviour bracket = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((class_1922)world, (class_2338)pos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE);
        if (bracket != null && bracket.isBracketPresent()) {
            return state;
        }
        class_2680 prevState = state;
        int prevStateSides = (int)Arrays.stream(Iterate.directions).map(field_11329::get).filter(arg_0 -> ((class_2680)prevState).method_11654(arg_0)).count();
        state = ColoredFluidPipeBlock.updateConnections(world, pos, state, ignore);
        class_2350 connectedDirection = null;
        for (class_2350 d : Iterate.directions) {
            if (!ColoredFluidPipeBlock.isOpenAt((class_2680)state, (class_2350)d)) continue;
            if (connectedDirection != null) {
                return state;
            }
            connectedDirection = d;
        }
        if (connectedDirection != null) {
            return (class_2680)state.method_11657((class_2769)field_11329.get(connectedDirection.method_10153()), (Comparable)Boolean.valueOf(true));
        }
        if (prevStateSides == 2) {
            class_2350 foundDir = null;
            for (class_2350 d : Iterate.directions) {
                if (!((Boolean)prevState.method_11654((class_2769)field_11329.get(d))).booleanValue()) continue;
                foundDir = d;
                break;
            }
            if (foundDir != null) {
                return ColoredFluidPipeBlock.addOppositeSide(state, foundDir);
            }
        }
        return ColoredFluidPipeBlock.addOppositeSide(state, preferredDirection);
    }

    public class_2591<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return (class_2591)ColoredBlockEntities.COLORED_FLUID_PIPE_ENTITY.get();
    }
}

