/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.createcolored.content.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.StraightPipeBlockEntity;
import io.github.fabricators_of_create.porting_lib.util.TagUtil;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import us.mikebartosh.minecraft.createcolored.content.block.ColoredBlocks;
import us.mikebartosh.minecraft.createcolored.content.block.ColoredEncasedPipeBlock;
import us.mikebartosh.minecraft.createcolored.content.block.ColoredFluidPipeBlock;
import us.mikebartosh.minecraft.createcolored.content.block.IColoredBlock;
import us.mikebartosh.minecraft.createcolored.content.blockEntities.ColoredBlockEntities;

@class_6328
@ParametersAreNonnullByDefault
public class ColoredGlassFluidPipeBlock
extends GlassFluidPipeBlock
implements IColoredBlock {
    protected final class_1767 color;

    public ColoredGlassFluidPipeBlock(class_4970.class_2251 properties, class_1767 color) {
        super(properties);
        this.color = color;
    }

    @Override
    public class_1767 getColor() {
        return this.color;
    }

    public boolean tryRemoveBracket(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        Optional bracket = this.removeBracket((class_1922)world, pos, false);
        class_2680 blockState = world.method_8320(pos);
        if (bracket.isPresent()) {
            class_1657 player = context.method_8036();
            if (!world.field_9236 && player != null && !player.method_7337()) {
                player.method_31548().method_7398((class_1799)bracket.get());
            }
            if (!world.field_9236 && ColoredBlocks.DYED_PIPES.get(this.color).has(blockState)) {
                class_2350.class_2351 preferred = FluidPropagator.getStraightPipeAxis((class_2680)blockState);
                class_2350 preferredDirection = preferred == null ? class_2350.field_11036 : class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)preferred);
                class_2680 updated = ((ColoredFluidPipeBlock)ColoredBlocks.DYED_PIPES.get(this.color).get()).updateBlockState(blockState, preferredDirection, null, (class_1920)world, pos);
                if (updated != blockState) {
                    world.method_8501(pos, updated);
                }
            }
            return true;
        }
        return false;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldItem = player.method_5998(hand);
        class_1767 color = TagUtil.getColorFromStack((class_1799)heldItem);
        if (color != null) {
            if (!world.field_9236) {
                world.method_8396(null, pos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.1f - world.field_9229.method_43057() * 0.2f);
            }
            this.applyDye(state, world, pos, color);
            return class_1269.field_5812;
        }
        if (!AllBlocks.COPPER_CASING.isIn(player.method_5998(hand))) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2680 newState = ((ColoredEncasedPipeBlock)((Object)ColoredBlocks.DYED_ENCASED_PIPES.get(this.color).get())).method_9564();
        for (class_2350 d : Iterate.directionsInAxis((class_2350.class_2351)this.getAxis(state))) {
            newState = (class_2680)newState.method_11657((class_2769)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d), (Comparable)Boolean.valueOf(true));
        }
        FluidTransportBehaviour.cacheFlows((class_1936)world, (class_2338)pos);
        world.method_8501(pos, newState);
        FluidTransportBehaviour.loadFlows((class_1936)world, (class_2338)pos);
        return class_1269.field_5812;
    }

    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (this.tryRemoveBracket(context)) {
            return class_1269.field_5812;
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        FluidTransportBehaviour.cacheFlows((class_1936)world, (class_2338)pos);
        class_2680 newState = (class_2680)this.toColoredPipe((class_1936)world, pos, state).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)));
        world.method_8652(pos, newState, 3);
        FluidTransportBehaviour.loadFlows((class_1936)world, (class_2338)pos);
        return class_1269.field_5812;
    }

    public class_2680 toColoredPipe(class_1936 world, class_2338 pos, class_2680 state) {
        class_2350 side = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)((class_2350.class_2351)state.method_11654((class_2769)field_11459)));
        Map facingToPropertyMap = FluidPipeBlock.field_11329;
        return ((ColoredFluidPipeBlock)ColoredBlocks.DYED_PIPES.get(this.color).get()).updateBlockState((class_2680)((class_2680)ColoredBlocks.DYED_PIPES.get(this.color).getDefaultState().method_11657((class_2769)facingToPropertyMap.get(side), (Comparable)Boolean.valueOf(true))).method_11657((class_2769)facingToPropertyMap.get(side.method_10153()), (Comparable)Boolean.valueOf(true)), side, null, (class_1920)world, pos);
    }

    public void applyDye(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_1767 color) {
        class_2680 newState = (color == null ? ColoredBlocks.DYED_GLASS_PIPES.get(class_1767.field_7952) : ColoredBlocks.DYED_GLASS_PIPES.get(color)).getDefaultState();
        if (state != newState) {
            world.method_8501(pos, newState);
        }
    }

    public class_2591<? extends StraightPipeBlockEntity> getBlockEntityType() {
        return (class_2591)ColoredBlockEntities.COLORED_GLASS_FLUID_PIPE_ENTITY.get();
    }

    public class_1799 getPickedStack(class_2680 state, class_1922 view, class_2338 pos, @Nullable class_1657 player, @Nullable class_239 result) {
        return ColoredBlocks.DYED_PIPES.get(this.color).asStack();
    }
}

