/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.createcolored.content.models;

import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Arrays;
import java.util.function.Supplier;
import net.createmod.catnip.data.Iterate;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import us.mikebartosh.minecraft.createcolored.content.block.ColoredFluidPipeBlock;
import us.mikebartosh.minecraft.createcolored.content.models.ColoredPartials;

public class ColoredPipeAttachmentModel
extends ForwardingBakedModel {
    private final class_1767 color;

    public ColoredPipeAttachmentModel(class_1087 template, class_1767 color) {
        this.wrapped = template;
        this.color = color;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 world, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        BracketedBlockEntityBehaviour bracket;
        ColoredPipeModelData data = new ColoredPipeModelData();
        RenderAttachedBlockView attachmentView = (RenderAttachedBlockView)world;
        Object attachment = attachmentView.getBlockEntityRenderAttachment(pos);
        if (attachment instanceof FluidTransportBehaviour.AttachmentTypes[]) {
            FluidTransportBehaviour.AttachmentTypes[] attachments = (FluidTransportBehaviour.AttachmentTypes[])attachment;
            for (int i = 0; i < attachments.length; ++i) {
                data.putAttachment(Iterate.directions[i], attachments[i]);
            }
        }
        if ((bracket = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((class_1922)world, (class_2338)pos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE)) != null) {
            data.putBracket(bracket.getBracket());
        }
        data.setEncased(ColoredFluidPipeBlock.shouldDrawCasing(state));
        super.emitBlockQuads(world, state, pos, randomSupplier, context);
        this.addQuads(world, state, pos, randomSupplier, context, data);
    }

    private void addQuads(class_1920 world, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, ColoredPipeModelData pipeData) {
        class_1087 bracket;
        for (class_2350 d : Iterate.directions) {
            FluidTransportBehaviour.AttachmentTypes type = pipeData.getAttachment(d);
            for (FluidTransportBehaviour.AttachmentTypes.ComponentPartials partial : type.partials) {
                ColoredPartials.COLORED_PIPE_ATTACHMENTS.get(partial).get(this.color).get(d.method_15434()).get().emitBlockQuads(world, state, pos, randomSupplier, context);
            }
        }
        if (pipeData.isEncased()) {
            ColoredPartials.COLORED_FLUID_PIPE_CASINGS.get(this.color).get().emitBlockQuads(world, state, pos, randomSupplier, context);
        }
        if ((bracket = pipeData.getBracket()) != null) {
            bracket.emitBlockQuads(world, state, pos, randomSupplier, context);
        }
    }

    private static class ColoredPipeModelData {
        private final FluidTransportBehaviour.AttachmentTypes[] attachments = new FluidTransportBehaviour.AttachmentTypes[6];
        private class_1767 color;
        private boolean encased;
        private class_1087 bracket;

        public ColoredPipeModelData() {
            Arrays.fill(this.attachments, FluidTransportBehaviour.AttachmentTypes.NONE);
        }

        public void putBracket(class_2680 state) {
            if (state != null) {
                this.bracket = class_310.method_1551().method_1541().method_3349(state);
            }
        }

        public class_1087 getBracket() {
            return this.bracket;
        }

        public void putAttachment(class_2350 face, FluidTransportBehaviour.AttachmentTypes rim) {
            this.attachments[face.method_10146()] = rim;
        }

        public FluidTransportBehaviour.AttachmentTypes getAttachment(class_2350 face) {
            return this.attachments[face.method_10146()];
        }

        public boolean isEncased() {
            return this.encased;
        }

        public void setEncased(Boolean encased) {
            this.encased = encased;
        }
    }
}

