/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.createcolored.datagen;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import io.github.fabricators_of_create.porting_lib.models.generators.ConfiguredModel;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.block.MultiPartBlockStateBuilder;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.Pointing;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import org.apache.commons.lang3.tuple.Pair;
import us.mikebartosh.minecraft.createcolored.content.block.ColoredFluidPipeBlock;
import us.mikebartosh.minecraft.createcolored.content.block.ColoredFluidTankBlock;

public class ColoredBlockStateGen {
    public static <P extends ColoredFluidTankBlock> NonNullBiConsumer<DataGenContext<class_2248, P>, RegistrateBlockstateProvider> coloredTank(class_1767 color) {
        return (c, p) -> {
            String colorName = color.method_7792();
            String coloredPath = "block/colored_fluid_tank/" + c.getName() + "/";
            String path = "block/fluid_tank/";
            p.getVariantBuilder((class_2248)c.getEntry()).forAllStates(state -> {
                Boolean top = (Boolean)state.method_11654((class_2769)ColoredFluidTankBlock.TOP);
                Boolean bottom = (Boolean)state.method_11654((class_2769)ColoredFluidTankBlock.BOTTOM);
                FluidTankBlock.Shape shape = (FluidTankBlock.Shape)state.method_11654((class_2769)ColoredFluidTankBlock.SHAPE);
                String shapeName = "middle";
                if (top.booleanValue() && bottom.booleanValue()) {
                    shapeName = "single";
                } else if (top.booleanValue()) {
                    shapeName = "top";
                } else if (bottom.booleanValue()) {
                    shapeName = "bottom";
                }
                String modelName = "block_" + shapeName + (String)(shape == FluidTankBlock.Shape.PLAIN ? "" : "_" + shape.method_15434());
                ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(coloredPath + modelName, Create.asResource((String)(path + modelName)))).texture("0", p.modLoc("block/fluid_tank_top/" + colorName))).texture("1", p.modLoc("block/fluid_tank/" + colorName))).texture("3", p.modLoc("block/fluid_tank_window/" + colorName))).texture("4", p.modLoc("block/fluid_tank_inner/" + colorName))).texture("5", p.modLoc("block/fluid_tank_window_single/" + colorName))).texture("particle", p.modLoc("block/fluid_tank/" + colorName));
                return ConfiguredModel.builder().modelFile((ModelFile)model).build();
            });
        };
    }

    public static <P extends ColoredFluidPipeBlock> NonNullBiConsumer<DataGenContext<class_2248, P>, RegistrateBlockstateProvider> coloredPipe(class_1767 color) {
        return (c, p) -> {
            String outputModel;
            String sourceModel;
            String colorName = color.method_7792();
            String coloredPath = "block/colored_fluid_pipe/" + c.getName();
            String path = "block/fluid_pipe";
            String LU = "lu";
            String RU = "ru";
            String LD = "ld";
            String RD = "rd";
            String LR = "lr";
            String UD = "ud";
            String U = "u";
            String D = "d";
            String L = "l";
            String R = "r";
            ImmutableList orientations = ImmutableList.of((Object)LU, (Object)RU, (Object)LD, (Object)RD, (Object)LR, (Object)UD, (Object)U, (Object)D, (Object)L, (Object)R);
            HashMap<Pair<String, class_2350.class_2351>, ModelFile> coreModels = new HashMap<Pair<String, class_2350.class_2351>, ModelFile>();
            for (class_2350.class_2351 axis : Iterate.axes) {
                for (String orientation : orientations) {
                    Pair key = Pair.of((Object)orientation, (Object)axis);
                    sourceModel = path + "/" + orientation + "_" + axis.method_15434();
                    String coloredModel = coloredPath + "/" + orientation + "_" + axis.method_15434();
                    coreModels.put((Pair<String, class_2350.class_2351>)key, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(coloredModel, Create.asResource((String)sourceModel))).texture("0", p.modLoc("block/pipes_connected/" + colorName))).texture("particle", p.modLoc("block/pipes_connected/" + colorName)));
                }
            }
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((class_2248)c.get());
            for (class_2350.class_2351 axis : Iterate.axes) {
                ColoredBlockStateGen.putPart(coreModels, builder, axis, LU, true, false, true, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, RU, true, false, false, true);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, LD, false, true, true, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, RD, false, true, false, true);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, UD, true, true, false, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, U, true, false, false, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, D, false, true, false, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, LR, false, false, true, true);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, L, false, false, true, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, R, false, false, false, true);
            }
            String casingSource = path + "/casing";
            String casingOutput = coloredPath + "/casing";
            ((BlockModelBuilder)p.models().withExistingParent(casingOutput, Create.asResource((String)casingSource))).texture("0", "block/pipes/" + colorName);
            for (class_2350 d : Iterate.directions) {
                sourceModel = path + "/connection/" + d.method_10151();
                outputModel = coloredPath + "/connection/" + d.method_10151();
                ((BlockModelBuilder)p.models().withExistingParent(outputModel, Create.asResource((String)sourceModel))).texture("0", "block/pipes/" + colorName);
            }
            for (class_2350 d : Iterate.directions) {
                sourceModel = path + "/drain/" + d.method_10151();
                outputModel = coloredPath + "/drain/" + d.method_10151();
                ((BlockModelBuilder)p.models().withExistingParent(outputModel, Create.asResource((String)sourceModel))).texture("0", "block/pipes/" + colorName);
            }
            for (class_2350 d : Iterate.directions) {
                sourceModel = path + "/rim/" + d.method_10151();
                outputModel = coloredPath + "/rim/" + d.method_10151();
                ((BlockModelBuilder)p.models().withExistingParent(outputModel, Create.asResource((String)sourceModel))).texture("0", "block/pipes/" + colorName);
            }
            for (class_2350 d : Iterate.directions) {
                sourceModel = path + "/rim_connector/" + d.method_10151();
                outputModel = coloredPath + "/rim_connector/" + d.method_10151();
                ((BlockModelBuilder)p.models().withExistingParent(outputModel, Create.asResource((String)sourceModel))).texture("0", "block/pipes/" + colorName);
            }
        };
    }

    private static void putPart(Map<Pair<String, class_2350.class_2351>, ModelFile> coreModels, MultiPartBlockStateBuilder builder, class_2350.class_2351 axis, String s, boolean up, boolean down, boolean left, boolean right) {
        class_2350 positiveAxis = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        Map propertyMap = FluidPipeBlock.field_11329;
        class_2350 upD = Pointing.UP.getCombinedDirection(positiveAxis);
        class_2350 leftD = Pointing.LEFT.getCombinedDirection(positiveAxis);
        class_2350 rightD = Pointing.RIGHT.getCombinedDirection(positiveAxis);
        class_2350 downD = Pointing.DOWN.getCombinedDirection(positiveAxis);
        if (axis == class_2350.class_2351.field_11052 || axis == class_2350.class_2351.field_11048) {
            leftD = leftD.method_10153();
            rightD = rightD.method_10153();
        }
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(coreModels.get(Pair.of((Object)s, (Object)axis))).addModel()).condition((class_2769)propertyMap.get(upD), (Comparable[])new Boolean[]{up}).condition((class_2769)propertyMap.get(leftD), (Comparable[])new Boolean[]{left}).condition((class_2769)propertyMap.get(rightD), (Comparable[])new Boolean[]{right}).condition((class_2769)propertyMap.get(downD), (Comparable[])new Boolean[]{down}).end();
    }

    public static <P extends EncasedPipeBlock> NonNullBiConsumer<DataGenContext<class_2248, P>, RegistrateBlockstateProvider> encasedPipe(class_1767 color) {
        return (c, p) -> {
            String colorName = color.method_7792();
            ModelBuilder open = ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/encased_fluid_pipe/" + colorName + "_encased_fluid_pipe/block_open", Create.asResource((String)"block/encased_fluid_pipe/block_open"))).texture("0", "block/encased_pipe/" + colorName)).texture("particle", "block/encased_pipe/" + colorName);
            ModelFile.ExistingModelFile flat = p.models().getExistingFile(Create.asResource((String)"block/encased_fluid_pipe/block_flat"));
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((class_2248)c.get());
            for (boolean flatPass : Iterate.trueAndFalse) {
                for (class_2350 d : Iterate.directions) {
                    int verticalAngle = d == class_2350.field_11036 ? 90 : (d == class_2350.field_11033 ? -90 : 0);
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)(flatPass ? flat : open)).rotationX(verticalAngle).rotationY((int)(d.method_10144() + (float)(d.method_10166().method_10178() ? 90 : 0)) % 360).addModel()).condition((class_2769)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d), (Comparable[])new Boolean[]{!flatPass}).end();
                }
            }
        };
    }
}

