/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.subsystems;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.cloudsolutions.common.configuration.ModConfig;
import site.siredvin.cloudsolutions.subsystems.KVStorageMode;
import site.siredvin.cloudsolutions.subsystems.kv.DisabledKVManager;
import site.siredvin.cloudsolutions.subsystems.kv.KeyValueManager;
import site.siredvin.cloudsolutions.subsystems.kv.sqlite.KVSQLiteManager;
import site.siredvin.cloudsolutions.subsystems.statsq.StatsDClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lsite/siredvin/cloudsolutions/subsystems/SubsystemManager;", "", "<init>", "()V", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "getExecutorService", "()Ljava/util/concurrent/ScheduledExecutorService;", "kvManager", "Lsite/siredvin/cloudsolutions/subsystems/kv/KeyValueManager;", "getKvManager", "()Lsite/siredvin/cloudsolutions/subsystems/kv/KeyValueManager;", "setKvManager", "(Lsite/siredvin/cloudsolutions/subsystems/kv/KeyValueManager;)V", "onServerStart", "", "server", "Lnet/minecraft/server/MinecraftServer;", "onServerStop", "cloudsolutions-forge-1.20.1"})
public final class SubsystemManager {
    @NotNull
    public static final SubsystemManager INSTANCE = new SubsystemManager();
    @NotNull
    private static final ScheduledExecutorService executorService;
    @Nullable
    private static KeyValueManager kvManager;

    private SubsystemManager() {
    }

    @NotNull
    public final ScheduledExecutorService getExecutorService() {
        return executorService;
    }

    @Nullable
    public final KeyValueManager getKvManager() {
        return kvManager;
    }

    public final void setKvManager(@Nullable KeyValueManager keyValueManager) {
        kvManager = keyValueManager;
    }

    public final void onServerStart(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        KeyValueManager keyValueManager = kvManager = (switch (WhenMappings.$EnumSwitchMapping$0[ModConfig.INSTANCE.getKvStorageMode().ordinal()]) {
            case 1 -> DisabledKVManager.INSTANCE;
            case 2 -> KVSQLiteManager.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        });
        if (keyValueManager != null) {
            keyValueManager.init(server, executorService);
        }
        if (ModConfig.INSTANCE.getEnableStatsDConnection()) {
            StatsDClient.INSTANCE.init();
        }
    }

    public final void onServerStop(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        KeyValueManager keyValueManager = kvManager;
        if (keyValueManager != null) {
            keyValueManager.stop(server, executorService);
        }
        StatsDClient.INSTANCE.stop();
    }

    static {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        executorService = scheduledExecutorService;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KVStorageMode.values().length];
            try {
                nArray[KVStorageMode.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KVStorageMode.SQLITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

