/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.computercraft.peripheral;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Regex;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.cloudsolutions.common.configuration.ModConfig;
import site.siredvin.cloudsolutions.subsystems.SubscriptionManager;
import site.siredvin.cloudsolutions.subsystems.SubsystemManager;
import site.siredvin.cloudsolutions.subsystems.kv.KeyValueManager;
import site.siredvin.cloudsolutions.util.ExtKt;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IDataStorage;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001;B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\bH\u0007J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0007J\u0018\u0010\u001f\u001a\u00020\u00142\u000e\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0007J\u0017\u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\"J\u001e\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0007J\u001e\u0010'\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020(0\u0018H\u0007J\u001e\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020(0\u0018H\u0007J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\bH\u0007J \u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\b2\u0006\u00100\u001a\u00020\bH\u0007J \u00101\u001a\u00020/2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\b2\u0006\u00100\u001a\u00020\bH\u0007J0\u00102\u001a\b\u0012\u0004\u0012\u00020\b0%2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0006\u00104\u001a\u00020\nH\u0002J2\u00105\u001a\u00020/2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0006\u00100\u001a\u00020\b2\u0006\u00104\u001a\u00020\nH\u0002J2\u00106\u001a\u00020/2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0006\u00100\u001a\u00020\b2\u0006\u00104\u001a\u00020\nH\u0002J\u0016\u00107\u001a\u00020/2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u00108\u001a\u00020/2\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u00109\u001a\u00020/J\u0006\u0010:\u001a\u00020/R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006<"}, d2={"Lsite/siredvin/cloudsolutions/computercraft/peripheral/KVStoragePeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "owner", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "changedSubscriptions", "", "", "", "", "deletedSubscriptions", "isEnabled", "", "()Z", "peripheralConfiguration", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "put", "Ldan200/computercraft/api/lua/MethodResult;", "key", "value", "expire", "Ljava/util/Optional;", "", "delete", "get", "mget", "", "keys", "mput", "values", "getEx", "(Ljava/lang/String;)Ljava/lang/Long;", "putEx", "list", "", "glob", "incr", "", "decr", "getSubscriptions", "access", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "type", "subscribe", "", "pattern", "unsubscribe", "listSubscriptions", "subMap", "computerID", "addSubscription", "removeSubscription", "onKeyChanged", "onKeyDeleted", "loadSettings", "saveSettings", "Companion", "cloudsolutions-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nKVStoragePeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KVStoragePeripheral.kt\nsite/siredvin/cloudsolutions/computercraft/peripheral/KVStoragePeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,222:1\n1557#2:223\n1628#2,3:224\n1863#2:255\n1557#2:256\n1628#2,3:257\n1864#2:260\n1863#2:261\n1557#2:262\n1628#2,3:263\n1864#2:266\n136#3,9:227\n216#3:236\n217#3:238\n145#3:239\n126#3:247\n153#3,3:248\n216#3,2:251\n216#3,2:253\n216#3,2:267\n216#3,2:269\n1#4:237\n535#5:240\n520#5,6:241\n*S KotlinDebug\n*F\n+ 1 KVStoragePeripheral.kt\nsite/siredvin/cloudsolutions/computercraft/peripheral/KVStoragePeripheral\n*L\n82#1:223\n82#1:224,3\n195#1:255\n196#1:256\n196#1:257,3\n195#1:260\n202#1:261\n203#1:262\n203#1:263,3\n202#1:266\n88#1:227,9\n88#1:236\n88#1:238\n88#1:239\n147#1:247\n147#1:248,3\n167#1:251,2\n179#1:253,2\n212#1:267,2\n217#1:269,2\n88#1:237\n147#1:240\n147#1:241,6\n*E\n"})
public final class KVStoragePeripheral
extends OwnedPeripheral<IPeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Set<Integer>> changedSubscriptions;
    @NotNull
    private final Map<String, Set<Integer>> deletedSubscriptions;
    @NotNull
    public static final String TYPE = "kv_storage";
    @NotNull
    private static final ResourceLocation ID = new ResourceLocation("cloudsolutions", "kv_storage");
    private static final LoadingCache<String, Regex> REGEX_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(CacheLoader.from(KVStoragePeripheral::REGEX_CACHE$lambda$18));
    @NotNull
    public static final String KV_STORAGE_CHANGED_SUBS = "kv_storage_changed_subs";
    @NotNull
    public static final String KV_STORAGE_DELETED_SUBS = "kv_storage_changed_subs";
    @NotNull
    public static final String KV_STORAGE_KEY_CHANGED = "kv_storage_key_changed";
    @NotNull
    public static final String KV_STORAGE_KEY_DELETED = "kv_storage_key_deleted";

    public KVStoragePeripheral(@NotNull IPeripheralOwner owner) {
        String ownerUUID;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(TYPE, owner);
        this.changedSubscriptions = new LinkedHashMap();
        this.deletedSubscriptions = new LinkedHashMap();
        this.loadSettings();
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        String string = ownerUUID = uUID != null ? uUID.toString() : null;
        if (ownerUUID != null) {
            SubscriptionManager.INSTANCE.addKVStorage(ownerUUID, this);
        }
    }

    public boolean isEnabled() {
        return ModConfig.INSTANCE.getEnableKVStorage();
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map data = super.getPeripheralConfiguration();
        data.put("keyLimit", ModConfig.INSTANCE.getKvStorageKeyLimit());
        data.put("valueLimit", ModConfig.INSTANCE.getKvStorageValueLimit());
        return data;
    }

    @LuaFunction
    @NotNull
    public final MethodResult put(@NotNull String key, @NotNull String value, @NotNull Optional<Long> expire) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(expire, (String)"expire");
        if (value.length() > ModConfig.INSTANCE.getKvStorageValueLimit()) {
            throw new LuaException("Value is too long");
        }
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        Intrinsics.checkNotNull((Object)keyValueManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Optional<Instant> optional = expire.map(arg_0 -> KVStoragePeripheral.put$lambda$1(KVStoragePeripheral::put$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return keyValueManager.put(string, key, value, (Instant)OptionalsKt.getOrNull(optional));
    }

    @LuaFunction
    @NotNull
    public final MethodResult delete(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        Intrinsics.checkNotNull((Object)keyValueManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return keyValueManager.delete(string, key);
    }

    @LuaFunction
    @Nullable
    public final String get(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        if (keyValueManager != null) {
            String string2 = player.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = keyValueManager.get(string2, key);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final Map<String, String> mget(@NotNull Map<?, ?> keys) {
        Map<String, String> map;
        block6: {
            block5: {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(keys, (String)"keys");
                UUID uUID = this.getPeripheralOwner().getOwnerUUID();
                if (uUID == null) {
                    throw new LuaException("Cannot find attached player to this peripheral");
                }
                UUID player = uUID;
                map = SubsystemManager.INSTANCE.getKvManager();
                if (map == null) break block5;
                String string = player.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Iterable iterable = keys.values();
                String string2 = string;
                Map<String, String> map2 = map;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(String.valueOf(it));
                }
                collection = (List)destination$iv$iv;
                map = map2.mget(string2, CollectionsKt.toList((Iterable)collection));
                if (map != null) break block6;
            }
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final MethodResult mput(@NotNull Map<?, ?> values) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        Map<?, ?> $this$mapNotNull$iv = values;
        boolean $i$f$mapNotNull = false;
        Map<?, ?> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            Pair it$iv$iv = new Pair((Object)String.valueOf(entry.getKey()), (Object)String.valueOf(entry.getValue()));
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map transformedMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        Intrinsics.checkNotNull((Object)keyValueManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return keyValueManager.mput(string, transformedMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction(value={"get_ex"})
    @Nullable
    public final Long getEx(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        Object object = keyValueManager;
        if (keyValueManager == null) return null;
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Instant instant = object.getExpire(string, key);
        object = instant;
        if (instant == null) return null;
        Long l = ((Instant)object).getEpochSecond();
        return l;
    }

    @LuaFunction(value={"put_ex"})
    @NotNull
    public final MethodResult putEx(@NotNull String key, @NotNull Optional<Long> expire) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(expire, (String)"expire");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        Intrinsics.checkNotNull((Object)keyValueManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Optional<Instant> optional = expire.map(arg_0 -> KVStoragePeripheral.putEx$lambda$5(KVStoragePeripheral::putEx$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return keyValueManager.putExpire(string, key, (Instant)OptionalsKt.getOrNull(optional));
    }

    @LuaFunction
    @NotNull
    public final List<String> list(@NotNull Optional<String> glob) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(glob, (String)"glob");
                UUID uUID = this.getPeripheralOwner().getOwnerUUID();
                if (uUID == null) {
                    throw new LuaException("Cannot find attached player to this peripheral");
                }
                UUID player = uUID;
                object = SubsystemManager.INSTANCE.getKvManager();
                if (object == null) break block4;
                String string = player.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                if ((object = object.list(string, glob)) != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @LuaFunction
    public final double incr(@NotNull String key, @NotNull Optional<Double> value) {
        double d;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        if (keyValueManager != null) {
            String string = player.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Double d2 = value.orElse(1.0);
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"orElse(...)");
            d = keyValueManager.incr(string, key, ((Number)d2).doubleValue());
        } else {
            d = 0.0;
        }
        return d;
    }

    @LuaFunction
    public final double decr(@NotNull String key, @NotNull Optional<Double> value) {
        double d;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        if (keyValueManager != null) {
            String string = player.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            d = keyValueManager.incr(string, key, -((Number)value.orElse(1.0)).doubleValue());
        } else {
            d = 0.0;
        }
        return d;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<String> getSubscriptions(@NotNull IComputerAccess access, @NotNull String type) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)"changed")) {
            list = this.listSubscriptions(this.changedSubscriptions, access.getID());
        } else if (Intrinsics.areEqual((Object)string, (Object)"deleted")) {
            list = this.listSubscriptions(this.deletedSubscriptions, access.getID());
        } else {
            throw new LuaException("You can only list subscriptions to changed or deleted events");
        }
        return list;
    }

    @LuaFunction(mainThread=true)
    public final void subscribe(@NotNull IComputerAccess access, @NotNull String type, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)"changed")) {
            this.addSubscription(this.changedSubscriptions, pattern, access.getID());
        } else if (Intrinsics.areEqual((Object)string, (Object)"deleted")) {
            this.addSubscription(this.deletedSubscriptions, pattern, access.getID());
        } else {
            throw new LuaException("You can subscribe only to changed or deleted events");
        }
    }

    @LuaFunction(mainThread=true)
    public final void unsubscribe(@NotNull IComputerAccess access, @NotNull String type, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)"changed")) {
            this.removeSubscription(this.changedSubscriptions, pattern, access.getID());
        } else if (Intrinsics.areEqual((Object)string, (Object)"deleted")) {
            this.removeSubscription(this.deletedSubscriptions, pattern, access.getID());
        } else {
            throw new LuaException("You can unsubscribe only from changed or deleted events");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> listSubscriptions(Map<String, Set<Integer>> subMap, int computerID) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Map<String, Set<Integer>> $this$filter$iv = subMap;
        boolean $i$f$filter = false;
        Map<String, Set<Integer>> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Set)it.getValue()).contains(computerID)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((String)it.getKey());
        }
        return (List)destination$iv$iv;
    }

    private final void addSubscription(Map<String, Set<Integer>> subMap, String pattern, int computerID) {
        if (!subMap.containsKey(pattern)) {
            subMap.put(pattern, new LinkedHashSet());
        }
        Set<Integer> set = subMap.get(pattern);
        Intrinsics.checkNotNull(set);
        if (set.add(computerID)) {
            this.saveSettings();
        }
    }

    private final void removeSubscription(Map<String, Set<Integer>> subMap, String pattern, int computerID) {
        if (subMap.containsKey(pattern)) {
            Set<Integer> set = subMap.get(pattern);
            Intrinsics.checkNotNull(set);
            if (set.remove(computerID)) {
                this.saveSettings();
            }
        }
    }

    public final void onKeyChanged(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map<String, Set<Integer>> $this$forEach$iv = this.changedSubscriptions;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Set<Integer>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<Integer>> element$iv;
            Map.Entry<String, Set<Integer>> it = element$iv = iterator.next();
            boolean bl = false;
            if (!((Regex)REGEX_CACHE.get((Object)it.getKey())).matches((CharSequence)key)) continue;
            this.forEachComputer(arg_0 -> KVStoragePeripheral.onKeyChanged$lambda$9$lambda$8(it, key, value, arg_0));
        }
    }

    public final void onKeyDeleted(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, Set<Integer>> $this$forEach$iv = this.deletedSubscriptions;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Set<Integer>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<Integer>> element$iv;
            Map.Entry<String, Set<Integer>> it = element$iv = iterator.next();
            boolean bl = false;
            if (!((Regex)REGEX_CACHE.get((Object)it.getKey())).matches((CharSequence)key)) continue;
            this.forEachComputer(arg_0 -> KVStoragePeripheral.onKeyDeleted$lambda$11$lambda$10(it, key, arg_0));
        }
    }

    public final void loadSettings() {
        Tag it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Map<String, Set<Integer>> map;
        String tagKey;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        CompoundTag tag;
        IDataStorage dataStorage = this.getPeripheralOwner().getDataStorage();
        if (dataStorage.has("kv_storage_changed_subs")) {
            tag = dataStorage.getCompound("kv_storage_changed_subs");
            this.changedSubscriptions.clear();
            Set set = tag.m_128431_();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllKeys(...)");
            $this$forEach$iv = set;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                tagKey = (String)element$iv;
                boolean bl = false;
                map = this.changedSubscriptions;
                ListTag listTag = tag.m_128437_(tagKey, 3);
                Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"getList(...)");
                $this$map$iv = (Iterable)listTag;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Tag tag2 = (Tag)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.IntTag");
                    collection.add(((IntTag)it).m_7047_());
                }
                $this$map$iv = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
                map.put(tagKey, (Set<Integer>)$this$map$iv);
            }
        }
        if (dataStorage.has("kv_storage_changed_subs")) {
            tag = dataStorage.getCompound("kv_storage_changed_subs");
            this.deletedSubscriptions.clear();
            Set set = tag.m_128431_();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllKeys(...)");
            $this$forEach$iv = set;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                tagKey = (String)element$iv;
                boolean bl = false;
                map = this.deletedSubscriptions;
                ListTag listTag = tag.m_128437_(tagKey, 3);
                Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"getList(...)");
                $this$map$iv = (Iterable)listTag;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Tag)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.IntTag");
                    collection.add(((IntTag)it).m_7047_());
                }
                Set set2 = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
                map.put(tagKey, set2);
            }
        }
    }

    public final void saveSettings() {
        Map.Entry<String, Set<Integer>> it;
        Map.Entry<String, Set<Integer>> element$iv;
        Iterator<Map.Entry<String, Set<Integer>>> iterator;
        boolean $i$f$forEach;
        Map<String, Set<Integer>> $this$forEach$iv;
        CompoundTag tag;
        IDataStorage dataStorage = this.getPeripheralOwner().getDataStorage();
        if (!this.changedSubscriptions.isEmpty()) {
            tag = new CompoundTag();
            $this$forEach$iv = this.changedSubscriptions;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv = iterator.next();
                boolean bl = false;
                tag.m_128365_(it.getKey().toString(), (Tag)ExtKt.toListTag(it.getValue()));
            }
            dataStorage.putCompound("kv_storage_changed_subs", tag);
        }
        if (!this.deletedSubscriptions.isEmpty()) {
            tag = new CompoundTag();
            $this$forEach$iv = this.deletedSubscriptions;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv = iterator.next();
                boolean bl = false;
                tag.m_128365_(it.getKey().toString(), (Tag)ExtKt.toListTag(it.getValue()));
            }
            dataStorage.putCompound("kv_storage_changed_subs", tag);
        }
    }

    private static final Instant put$lambda$0(Long it) {
        Intrinsics.checkNotNull((Object)it);
        return Instant.ofEpochSecond(it);
    }

    private static final Instant put$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Instant)$tmp0.invoke(p0);
    }

    private static final Instant putEx$lambda$4(Long it) {
        Intrinsics.checkNotNull((Object)it);
        return Instant.ofEpochSecond(it);
    }

    private static final Instant putEx$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Instant)$tmp0.invoke(p0);
    }

    private static final void onKeyChanged$lambda$9$lambda$8(Map.Entry $it, String $key, String $value, IComputerAccess computerAccess) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)computerAccess, (String)"computerAccess");
        if (((Set)$it.getValue()).contains(computerAccess.getID())) {
            Object[] objectArray = new Object[]{$key, $value};
            computerAccess.queueEvent(KV_STORAGE_KEY_CHANGED, objectArray);
        }
    }

    private static final void onKeyDeleted$lambda$11$lambda$10(Map.Entry $it, String $key, IComputerAccess computerAccess) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)computerAccess, (String)"computerAccess");
        if (((Set)$it.getValue()).contains(computerAccess.getID())) {
            Object[] objectArray = new Object[]{$key};
            computerAccess.queueEvent(KV_STORAGE_KEY_DELETED, objectArray);
        }
    }

    private static final Regex REGEX_CACHE$lambda$18(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Regex(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tRS\u0010\n\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0018\u00010\u000b0\u000b\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lsite/siredvin/cloudsolutions/computercraft/peripheral/KVStoragePeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "REGEX_CACHE", "Lcom/google/common/cache/LoadingCache;", "kotlin.jvm.PlatformType", "Lkotlin/text/Regex;", "getREGEX_CACHE", "()Lcom/google/common/cache/LoadingCache;", "Lcom/google/common/cache/LoadingCache;", "KV_STORAGE_CHANGED_SUBS", "KV_STORAGE_DELETED_SUBS", "KV_STORAGE_KEY_CHANGED", "KV_STORAGE_KEY_DELETED", "cloudsolutions-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public final LoadingCache<String, Regex> getREGEX_CACHE() {
            return REGEX_CACHE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

