/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.subsystems;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.cloudsolutions.common.configuration.ModConfig;
import site.siredvin.cloudsolutions.subsystems.CrafkaStorageMode;
import site.siredvin.cloudsolutions.subsystems.KVStorageMode;
import site.siredvin.cloudsolutions.subsystems.SubscriptionManager;
import site.siredvin.cloudsolutions.subsystems.crafka.CrafkaSQLiteManager;
import site.siredvin.cloudsolutions.subsystems.kv.DisabledKVManager;
import site.siredvin.cloudsolutions.subsystems.kv.KVKeyChangedHook;
import site.siredvin.cloudsolutions.subsystems.kv.KVKeyDeletedHook;
import site.siredvin.cloudsolutions.subsystems.kv.KeyValueManager;
import site.siredvin.cloudsolutions.subsystems.kv.sqlite.KVSQLiteManager;
import site.siredvin.cloudsolutions.subsystems.statsq.StatsDClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/cloudsolutions/subsystems/SubsystemManager;", "", "<init>", "()V", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "getExecutorService", "()Ljava/util/concurrent/ScheduledExecutorService;", "kvManager", "Lsite/siredvin/cloudsolutions/subsystems/kv/KeyValueManager;", "getKvManager", "()Lsite/siredvin/cloudsolutions/subsystems/kv/KeyValueManager;", "setKvManager", "(Lsite/siredvin/cloudsolutions/subsystems/kv/KeyValueManager;)V", "crafkaBrokerManager", "Lsite/siredvin/cloudsolutions/subsystems/crafka/CrafkaSQLiteManager;", "getCrafkaBrokerManager", "()Lsite/siredvin/cloudsolutions/subsystems/crafka/CrafkaSQLiteManager;", "setCrafkaBrokerManager", "(Lsite/siredvin/cloudsolutions/subsystems/crafka/CrafkaSQLiteManager;)V", "onServerStart", "", "server", "Lnet/minecraft/server/MinecraftServer;", "onServerStop", "cloudsolutions-forge-1.20.1"})
public final class SubsystemManager {
    @NotNull
    public static final SubsystemManager INSTANCE = new SubsystemManager();
    @NotNull
    private static final ScheduledExecutorService executorService;
    @Nullable
    private static KeyValueManager kvManager;
    @Nullable
    private static CrafkaSQLiteManager crafkaBrokerManager;

    private SubsystemManager() {
    }

    @NotNull
    public final ScheduledExecutorService getExecutorService() {
        return executorService;
    }

    @Nullable
    public final KeyValueManager getKvManager() {
        return kvManager;
    }

    public final void setKvManager(@Nullable KeyValueManager keyValueManager) {
        kvManager = keyValueManager;
    }

    @Nullable
    public final CrafkaSQLiteManager getCrafkaBrokerManager() {
        return crafkaBrokerManager;
    }

    public final void setCrafkaBrokerManager(@Nullable CrafkaSQLiteManager crafkaSQLiteManager) {
        crafkaBrokerManager = crafkaSQLiteManager;
    }

    public final void onServerStart(@NotNull MinecraftServer server) {
        SubscriptionManager subscriptionManager;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        KeyValueManager keyValueManager = kvManager = (switch (WhenMappings.$EnumSwitchMapping$0[ModConfig.INSTANCE.getKvStorageMode().ordinal()]) {
            case 1 -> DisabledKVManager.INSTANCE;
            case 2 -> KVSQLiteManager.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        });
        if (keyValueManager != null) {
            keyValueManager.init(server, executorService);
        }
        KeyValueManager keyValueManager2 = kvManager;
        if (keyValueManager2 != null) {
            subscriptionManager = SubscriptionManager.INSTANCE;
            keyValueManager2.setOnKeyDeletedHook(new KVKeyDeletedHook(subscriptionManager){
                final /* synthetic */ SubscriptionManager $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void handle(String p0, String p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    this.$tmp0.onKeyDeleted(p0, p1);
                }

                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, SubscriptionManager.class, "onKeyDeleted", "onKeyDeleted(Ljava/lang/String;Ljava/lang/String;)V", 0);
                }

                public final boolean equals(Object other) {
                    return other instanceof KVKeyDeletedHook ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                }
            });
        }
        KeyValueManager keyValueManager3 = kvManager;
        if (keyValueManager3 != null) {
            subscriptionManager = SubscriptionManager.INSTANCE;
            keyValueManager3.setOnKeyChangedHook(new KVKeyChangedHook(subscriptionManager){
                final /* synthetic */ SubscriptionManager $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void handle(String p0, String p1, String p2) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    this.$tmp0.onKeyChanged(p0, p1, p2);
                }

                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(3, (Object)this.$tmp0, SubscriptionManager.class, "onKeyChanged", "onKeyChanged(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", 0);
                }

                public final boolean equals(Object other) {
                    return other instanceof KVKeyChangedHook ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                }
            });
        }
        CrafkaSQLiteManager crafkaSQLiteManager = crafkaBrokerManager = (switch (WhenMappings.$EnumSwitchMapping$1[ModConfig.INSTANCE.getCrafkaStorageMode().ordinal()]) {
            case 1 -> null;
            case 2 -> CrafkaSQLiteManager.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        });
        if (crafkaSQLiteManager != null) {
            crafkaSQLiteManager.init(server, executorService);
        }
        if (ModConfig.INSTANCE.getEnableStatsDConnection()) {
            StatsDClient.INSTANCE.init();
        }
    }

    public final void onServerStop(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        KeyValueManager keyValueManager = kvManager;
        if (keyValueManager != null) {
            keyValueManager.stop(server, executorService);
        }
        CrafkaSQLiteManager crafkaSQLiteManager = crafkaBrokerManager;
        if (crafkaSQLiteManager != null) {
            crafkaSQLiteManager.stop(server, executorService);
        }
        StatsDClient.INSTANCE.stop();
    }

    static {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        executorService = scheduledExecutorService;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KVStorageMode.values().length];
            try {
                nArray[KVStorageMode.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KVStorageMode.SQLITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CrafkaStorageMode.values().length];
            try {
                nArray[CrafkaStorageMode.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrafkaStorageMode.SQLITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

