/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import site.siredvin.cloudsolutions.CloudSolutionsCore;
import site.siredvin.cloudsolutions.common.configuration.ModConfig;
import site.siredvin.cloudsolutions.subsystems.tsdb.TSDBManager;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007JH\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\r0\r2\u0006\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0015\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0007J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0\r0\u0019H\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0013H\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rH\u0007R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006!"}, d2={"Lsite/siredvin/cloudsolutions/computercraft/peripheral/TSDBStoragePeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "owner", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "isEnabled", "", "()Z", "registerTimeseries", "", "name", "tags", "", "retention", "Ljava/util/Optional;", "", "queryTimeseries", "", "", "namePattern", "tagsQuery", "fromTimestamp", "toTimestamp", "getTimeseries", "", "", "postMeasurement", "", "id", "value", "values", "Companion", "cloudsolutions-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nTSDBStoragePeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TSDBStoragePeripheral.kt\nsite/siredvin/cloudsolutions/computercraft/peripheral/TSDBStoragePeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1187#2,2:78\n1261#2,4:80\n1187#2,2:84\n1261#2,4:86\n*S KotlinDebug\n*F\n+ 1 TSDBStoragePeripheral.kt\nsite/siredvin/cloudsolutions/computercraft/peripheral/TSDBStoragePeripheral\n*L\n28#1:78,2\n28#1:80,4\n71#1:84,2\n71#1:86,4\n*E\n"})
public final class TSDBStoragePeripheral
extends OwnedPeripheral<IPeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TYPE = "tsdb_storage";
    @NotNull
    private static final ResourceLocation ID = new ResourceLocation("cloudsolutions", "tsdb_storage");

    public TSDBStoragePeripheral(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(TYPE, owner);
    }

    public boolean isEnabled() {
        return ModConfig.INSTANCE.getEnableTSDBStorage();
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final String registerTimeseries(@NotNull String name, @NotNull Map<?, ?> tags, @NotNull Optional<Integer> retention) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(retention, (String)"retention");
        Player player = this.getPeripheralOwner().getOwner();
        if (player == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        Player player2 = player;
        TSDBManager tSDBManager = CloudSolutionsCore.INSTANCE.getTsdbManager();
        String string = player2.m_20149_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
        Iterable iterable = tags.entrySet();
        String string2 = name;
        String string3 = string;
        TSDBManager tSDBManager2 = tSDBManager;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var9_11 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)String.valueOf(it.getKey()), (Object)String.valueOf(it.getValue()));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        Integer n = retention.orElse(10080);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"orElse(...)");
        String string4 = tSDBManager2.getOrCreate(string3, string2, map, ((Number)n).intValue()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @LuaFunction
    @NotNull
    public final Map<String, Map<Long, Double>> queryTimeseries(@NotNull String namePattern, @NotNull Map<?, ?> tagsQuery, long fromTimestamp, long toTimestamp) {
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter(tagsQuery, (String)"tagsQuery");
        Player player = this.getPeripheralOwner().getOwner();
        if (player == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        Player player2 = player;
        return MapsKt.emptyMap();
    }

    @LuaFunction
    @NotNull
    public final List<Map<String, Object>> getTimeseries() {
        Player player = this.getPeripheralOwner().getOwner();
        if (player == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        Player player2 = player;
        return CollectionsKt.emptyList();
    }

    @LuaFunction
    public final void postMeasurement(@NotNull String id, double value) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Player player = this.getPeripheralOwner().getOwner();
        if (player == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        Player player2 = player;
        TSDBManager tSDBManager = CloudSolutionsCore.INSTANCE.getTsdbManager();
        String string = player2.m_20149_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
        UUID uUID = UUID.fromString(id);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        tSDBManager.put(string, uUID, value);
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    public final void postMeasurement(@NotNull Map<?, ?> values) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Player player = this.getPeripheralOwner().getOwner();
        if (player == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        Player player2 = player;
        TSDBManager tSDBManager = CloudSolutionsCore.INSTANCE.getTsdbManager();
        String string = player2.m_20149_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
        Iterable iterable = values.entrySet();
        String string2 = string;
        TSDBManager tSDBManager2 = tSDBManager;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            UUID uUID = UUID.fromString(String.valueOf(it.getKey()));
            Object v = it.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            Pair pair = TuplesKt.to((Object)uUID, (Object)((Number)v).doubleValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        tSDBManager2.putMany(string2, map);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lsite/siredvin/cloudsolutions/computercraft/peripheral/TSDBStoragePeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "cloudsolutions-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

