/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.computercraft.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.cloudsolutions.common.configuration.ModConfig;
import site.siredvin.cloudsolutions.subsystems.SubsystemManager;
import site.siredvin.cloudsolutions.subsystems.crafka.CrafkaSQLiteManager;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0007J$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020 H\u0007J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J*\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000b2\u0010\u0010%\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001fH\u0007J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J \u0010(\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020 H\u0007R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"Lsite/siredvin/cloudsolutions/computercraft/peripheral/CrafkaBrokerPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "owner", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "isEnabled", "", "()Z", "peripheralConfiguration", "", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "detach", "", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "attach", "createTopic", "Ldan200/computercraft/api/lua/MethodResult;", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "listTopics", "", "deleteTopic", "topic", "publish", "message", "fetchMessages", "", "", "index", "describeTopic", "subscribe", "access", "optOptions", "unsubscribe", "getSubscription", "setCursor", "value", "Companion", "cloudsolutions-forge-1.20.1"})
public final class CrafkaBrokerPeripheral
extends OwnedPeripheral<IPeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TYPE = "crafka_broker";
    @NotNull
    private static final ResourceLocation ID = new ResourceLocation("cloudsolutions", "crafka_broker");

    public CrafkaBrokerPeripheral(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(TYPE, owner);
    }

    public boolean isEnabled() {
        return ModConfig.INSTANCE.getEnableCrafkaBroker();
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map data = super.getPeripheralConfiguration();
        data.put("topicLimit", ModConfig.INSTANCE.getCrafkaTopicLimit());
        data.put("maxMessageLimit", ModConfig.INSTANCE.getCrafkaMessageSizeLimit());
        data.put("maxMessageSize", ModConfig.INSTANCE.getCrafkaMessageSizeLimit());
        data.put("maxResendSteps", ModConfig.INSTANCE.getCrafkaMaxResendSteps());
        data.put("resendDelay", ModConfig.INSTANCE.getCrafkaCursorRevalidationDelay());
        return data;
    }

    public void detach(@NotNull IComputerAccess computer) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
            super.detach(computer);
            UUID player = this.getPeripheralOwner().getOwnerUUID();
            if (player == null) break block1;
            CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
            if (crafkaSQLiteManager != null) {
                String string = player.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                crafkaSQLiteManager.onComputerDetach(string, computer.getID());
            }
        }
    }

    public void attach(@NotNull IComputerAccess computer) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
            super.attach(computer);
            UUID player = this.getPeripheralOwner().getOwnerUUID();
            if (player == null) break block1;
            CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
            if (crafkaSQLiteManager != null) {
                String string = player.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                crafkaSQLiteManager.onComputerAttach(string, computer.getID());
            }
        }
    }

    @LuaFunction
    @NotNull
    public final MethodResult createTopic(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        String topic = arguments.getString(0);
        int messageLimit = arguments.optInt(1, ModConfig.INSTANCE.getCrafkaTopicSizeLimit());
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        int currentTopicCount = crafkaSQLiteManager.topicCount(string);
        if (currentTopicCount >= ModConfig.INSTANCE.getCrafkaTopicLimit()) {
            Object[] objectArray = new Object[]{false, "Too many topics"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        CrafkaSQLiteManager crafkaSQLiteManager2 = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager2);
        String string2 = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Intrinsics.checkNotNull((Object)topic);
        return crafkaSQLiteManager2.createTopic(string2, topic, RangesKt.coerceAtMost((int)messageLimit, (int)ModConfig.INSTANCE.getCrafkaTopicSizeLimit()));
    }

    @LuaFunction
    @NotNull
    public final List<String> listTopics() {
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return crafkaSQLiteManager.listTopics(string);
    }

    @LuaFunction
    @NotNull
    public final MethodResult deleteTopic(@NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return crafkaSQLiteManager.deleteTopic(string, topic);
    }

    @LuaFunction
    @NotNull
    public final MethodResult publish(@NotNull String topic, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        if (message.length() > ModConfig.INSTANCE.getCrafkaMessageSizeLimit()) {
            Object[] objectArray = new Object[]{false, "Message is too big"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return crafkaSQLiteManager.publish(string, topic, message);
    }

    @LuaFunction
    @NotNull
    public final Map<Integer, String> fetchMessages(@NotNull String topic, int index) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return crafkaSQLiteManager.fetchMessages(string, topic, index);
    }

    @LuaFunction
    @NotNull
    public final Map<String, Object> describeTopic(@NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return crafkaSQLiteManager.describeTopic(string, topic);
    }

    @LuaFunction
    @NotNull
    public final MethodResult subscribe(@NotNull IComputerAccess access, @NotNull String topic, @Nullable Map<?, ?> optOptions) {
        Map options;
        Object v;
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        Map map = optOptions;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Boolean bl = (v = (options = map).get("fragile")) instanceof Boolean ? (Boolean)v : null;
        boolean fragile = bl != null ? bl : false;
        Object v2 = options.get("autoCursor");
        Boolean bl2 = v2 instanceof Boolean ? (Boolean)v2 : null;
        boolean autoCursor = bl2 != null ? bl2 : true;
        Object v3 = options.get("cursor");
        Number number = v3 instanceof Number ? (Number)((Number)v3) : (Number)null;
        int cursor = number != null ? number.intValue() : 0;
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return crafkaSQLiteManager.subscribe(string, topic, access.getID(), cursor, fragile, autoCursor);
    }

    @LuaFunction
    @NotNull
    public final MethodResult unsubscribe(@NotNull IComputerAccess access, @NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return crafkaSQLiteManager.unsubscribe(string, topic, access.getID());
    }

    @LuaFunction
    @NotNull
    public final MethodResult getSubscription(@NotNull IComputerAccess access, @NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return crafkaSQLiteManager.getSubscription(string, topic, access.getID());
    }

    @LuaFunction
    @NotNull
    public final MethodResult setCursor(@NotNull IComputerAccess access, @NotNull String topic, int value) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        UUID player = uUID;
        CrafkaSQLiteManager crafkaSQLiteManager = SubsystemManager.INSTANCE.getCrafkaBrokerManager();
        Intrinsics.checkNotNull((Object)crafkaSQLiteManager);
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return crafkaSQLiteManager.setCursor(string, topic, access.getID(), value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lsite/siredvin/cloudsolutions/computercraft/peripheral/CrafkaBrokerPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "cloudsolutions-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

