/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.subsystems.kv.sqlite;

import dan200.computercraft.api.lua.MethodResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.DoubleColumnType;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.ISqlExpressionBuilder;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SQLExpressionBuilderKt;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.VarCharColumnType;
import org.jetbrains.exposed.sql.statements.BatchUpsertStatement;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.statements.ReturningStatement;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.UpdateStatement;
import org.jetbrains.exposed.sql.statements.UpsertBuilder;
import org.jetbrains.exposed.sql.statements.UpsertStatement;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import site.siredvin.cloudsolutions.CloudSolutionsCore;
import site.siredvin.cloudsolutions.common.configuration.ModConfig;
import site.siredvin.cloudsolutions.subsystems.kv.KVKeyChangedHook;
import site.siredvin.cloudsolutions.subsystems.kv.KVKeyDeletedHook;
import site.siredvin.cloudsolutions.subsystems.kv.KeyValueManager;
import site.siredvin.cloudsolutions.subsystems.kv.sqlite.KVRecord;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0016\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ*\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J$\u0010$\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0&H\u0016J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0016J*\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0+H\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0016J\"\u0010-\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J$\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0+2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b00H\u0016J \u00101\u001a\u0002022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\tH\u0016J\u0010\u00105\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00066"}, d2={"Lsite/siredvin/cloudsolutions/subsystems/kv/sqlite/KVSQLiteManager;", "Lsite/siredvin/cloudsolutions/subsystems/kv/KeyValueManager;", "<init>", "()V", "connection", "Lorg/jetbrains/exposed/sql/Database;", "cleanupFuture", "Ljava/util/concurrent/ScheduledFuture;", "keyDeletedHook", "Lsite/siredvin/cloudsolutions/subsystems/kv/KVKeyDeletedHook;", "keyChangedHook", "Lsite/siredvin/cloudsolutions/subsystems/kv/KVKeyChangedHook;", "notExpireCondition", "Lorg/jetbrains/exposed/sql/Op;", "", "getNotExpireCondition", "()Lorg/jetbrains/exposed/sql/Op;", "init", "", "server", "Lnet/minecraft/server/MinecraftServer;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "stop", "cleanup", "tooManyKeys", "ownerUUID", "", "keyToInsert", "", "put", "Ldan200/computercraft/api/lua/MethodResult;", "key", "value", "expire", "Ljava/time/Instant;", "mput", "values", "", "delete", "get", "mget", "keys", "", "getExpire", "putExpire", "list", "glob", "Ljava/util/Optional;", "incr", "", "setOnKeyDeletedHook", "hook", "setOnKeyChangedHook", "cloudsolutions-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nKVSQLiteManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KVSQLiteManager.kt\nsite/siredvin/cloudsolutions/subsystems/kv/sqlite/KVSQLiteManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n*L\n1#1,234:1\n1863#2,2:235\n1863#2,2:239\n1863#2,2:249\n1863#2,2:262\n200#3,2:237\n122#3,8:241\n595#3,11:251\n*S KotlinDebug\n*F\n+ 1 KVSQLiteManager.kt\nsite/siredvin/cloudsolutions/subsystems/kv/sqlite/KVSQLiteManager\n*L\n138#1:235,2\n87#1:239,2\n172#1:249,2\n205#1:262,2\n85#1:237,2\n146#1:241,8\n191#1:251,11\n*E\n"})
public final class KVSQLiteManager
implements KeyValueManager {
    @NotNull
    public static final KVSQLiteManager INSTANCE = new KVSQLiteManager();
    @Nullable
    private static Database connection;
    @Nullable
    private static ScheduledFuture<?> cleanupFuture;
    @NotNull
    private static KVKeyDeletedHook keyDeletedHook;
    @NotNull
    private static KVKeyChangedHook keyChangedHook;

    private KVSQLiteManager() {
    }

    private final Op<Boolean> getNotExpireCondition() {
        return OpKt.or((Expression)((Expression)SqlExpressionBuilder.INSTANCE.greater((ExpressionWithColumnType)KVRecord.INSTANCE.getExpire(), (Comparable)Integer.valueOf((int)Instant.now().getEpochSecond()))), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.isNull((Expression)KVRecord.INSTANCE.getExpire())));
    }

    @Override
    public void init(@NotNull MinecraftServer server, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        String[] stringArray = new String[]{"cloudsolutions"};
        Path dirPath = Paths.get(((Object)server.m_129843_(LevelResource.f_78182_)).toString(), stringArray);
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            Files.createDirectory(dirPath, new FileAttribute[0]);
        }
        String[] stringArray2 = new String[]{"cloudsolutions", "kv.db"};
        String dbPath = ((Object)Paths.get(((Object)server.m_129843_(LevelResource.f_78182_)).toString(), stringArray2)).toString();
        connection = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)("jdbc:sqlite:" + dbPath + "?foreign_keys=on"), null, null, null, null, null, null, null, (int)254, null);
        ThreadLocalTransactionManagerKt.transaction((Database)connection, KVSQLiteManager::init$lambda$2);
        cleanupFuture = executor.scheduleWithFixedDelay(KVSQLiteManager::init$lambda$3, 0L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void stop(@NotNull MinecraftServer server, @NotNull ScheduledExecutorService executor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            ScheduledFuture<?> scheduledFuture = cleanupFuture;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(true);
        }
    }

    private final void cleanup() {
        try {
            CloudSolutionsCore.INSTANCE.getLogger().info("Run KV cleanup");
            int now = (int)Instant.now().getEpochSecond();
            ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.cleanup$lambda$6(now, arg_0));
        }
        catch (Exception ex) {
            CloudSolutionsCore.INSTANCE.getLogger().catching((Throwable)ex);
        }
    }

    public final boolean tooManyKeys(@NotNull String ownerUUID, int keyToInsert) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        return (Boolean)ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.tooManyKeys$lambda$7(ownerUUID, keyToInsert, arg_0));
    }

    @Override
    @NotNull
    public MethodResult put(@NotNull String ownerUUID, @NotNull String key, @NotNull String value, @Nullable Instant expire) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.tooManyKeys(ownerUUID, 1)) {
            Object[] objectArray = new Object[]{false, "Too many keys in KV storage"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        KVSQLiteManager self = this;
        Object object = ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.put$lambda$9(ownerUUID, key, value, expire, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"transaction(...)");
        return (MethodResult)object;
    }

    @Override
    @NotNull
    public MethodResult mput(@NotNull String ownerUUID, @NotNull Map<String, String> values) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        if (values.isEmpty()) {
            Object[] objectArray = new Object[]{false, "Where is values?"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        if (this.tooManyKeys(ownerUUID, values.size())) {
            Object[] objectArray = new Object[]{false, "Too many keys already exists"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        int insertedCount = ((Number)ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.mput$lambda$11(values, ownerUUID, arg_0))).intValue();
        Iterable $this$forEach$iv = values.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            keyChangedHook.handle(ownerUUID, (String)it.getKey(), (String)it.getValue());
        }
        MethodResult methodResult = MethodResult.of((Object)insertedCount);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @Override
    @NotNull
    public MethodResult delete(@NotNull String ownerUUID, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MethodResult result = (MethodResult)ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.delete$lambda$14(ownerUUID, key, arg_0));
        keyDeletedHook.handle(ownerUUID, key);
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    @Override
    @Nullable
    public String get(@NotNull String ownerUUID, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (String)ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.get$lambda$15(ownerUUID, key, arg_0));
    }

    @Override
    @NotNull
    public Map<String, String> mget(@NotNull String ownerUUID, @NotNull List<String> keys) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        if (keys.isEmpty()) {
            return MapsKt.emptyMap();
        }
        return (Map)ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.mget$lambda$17(ownerUUID, keys, arg_0));
    }

    @Override
    @Nullable
    public Instant getExpire(@NotNull String ownerUUID, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Instant)ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.getExpire$lambda$19(ownerUUID, key, arg_0));
    }

    @Override
    @NotNull
    public MethodResult putExpire(@NotNull String ownerUUID, @NotNull String key, @Nullable Instant expire) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.putExpire$lambda$22(ownerUUID, key, expire, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"transaction(...)");
        return (MethodResult)object;
    }

    @Override
    @NotNull
    public List<String> list(@NotNull String ownerUUID, @NotNull Optional<String> glob) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter(glob, (String)"glob");
        return (List)ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.list$lambda$24(ownerUUID, glob, arg_0));
    }

    @Override
    public double incr(@NotNull String ownerUUID, @NotNull String key, double value) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ((Number)ThreadLocalTransactionManagerKt.transaction((Database)connection, arg_0 -> KVSQLiteManager.incr$lambda$27(value, key, ownerUUID, arg_0))).doubleValue();
    }

    @Override
    public void setOnKeyDeletedHook(@NotNull KVKeyDeletedHook hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        keyDeletedHook = hook;
    }

    @Override
    public void setOnKeyChangedHook(@NotNull KVKeyChangedHook hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        keyChangedHook = hook;
    }

    private static final void keyDeletedHook$lambda$0(String it1, String it2) {
        Intrinsics.checkNotNullParameter((Object)it1, (String)"it1");
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it2");
    }

    private static final void keyChangedHook$lambda$1(String it1, String it2, String it3) {
        Intrinsics.checkNotNullParameter((Object)it1, (String)"it1");
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it2");
        Intrinsics.checkNotNullParameter((Object)it3, (String)"it3");
    }

    private static final Unit init$lambda$2(Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        KVRecord[] kVRecordArray = new KVRecord[]{KVRecord.INSTANCE};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])kVRecordArray, (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void init$lambda$3() {
        INSTANCE.cleanup();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit cleanup$lambda$6(int $now, Transaction $this$transaction) {
        void $this$cleanup_u24lambda_u246_u24lambda_u244;
        void $this$deleteReturning$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table table = KVRecord.INSTANCE;
        Object[] objectArray = new Column[]{KVRecord.INSTANCE.getOwnerUUID(), KVRecord.INSTANCE.getKey()};
        List returning$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$deleteReturning = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        ColumnSet columnSet = (ColumnSet)$this$deleteReturning$iv;
        boolean bl = false;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 16;
        List list = null;
        Integer n2 = null;
        boolean bl2 = false;
        Op op = OpKt.and((Expression)((Expression)$this$cleanup_u24lambda_u246_u24lambda_u244.isNotNull((Expression)KVRecord.INSTANCE.getExpire())), (Expression)((Expression)$this$cleanup_u24lambda_u246_u24lambda_u244.less((ExpressionWithColumnType)KVRecord.INSTANCE.getExpire(), (Comparable)Integer.valueOf($now))));
        ColumnSet columnSet2 = columnSet;
        DeleteStatement delete$iv = new DeleteStatement(columnSet2, op, bl2, n2, list, n, defaultConstructorMarker);
        Iterable $this$forEach$iv = (Iterable)new ReturningStatement((Table)$this$deleteReturning$iv, returning$iv, (Statement)delete$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResultRow it = (ResultRow)element$iv;
            boolean bl3 = false;
            keyDeletedHook.handle((String)it.get((Expression)KVRecord.INSTANCE.getOwnerUUID()), (String)it.get((Expression)KVRecord.INSTANCE.getKey()));
        }
        return Unit.INSTANCE;
    }

    private static final boolean tooManyKeys$lambda$7(String $ownerUUID, int $keyToInsert, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        long count = QueriesKt.selectAll((FieldSet)((FieldSet)KVRecord.INSTANCE)).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID)).count();
        return count + (long)$keyToInsert >= (long)ModConfig.INSTANCE.getKvStorageKeyLimit();
    }

    private static final Unit put$lambda$9$lambda$8(String $ownerUUID, String $key, String $value, Instant $expire, KVRecord $this$upsert, UpsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$upsert), (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID);
        it.set(KVRecord.INSTANCE.getKey(), (Object)$key);
        it.set(KVRecord.INSTANCE.getValue(), (Object)$value);
        Instant instant = $expire;
        it.set(KVRecord.INSTANCE.getExpire(), (Object)(instant != null ? Integer.valueOf((int)instant.getEpochSecond()) : null));
        return Unit.INSTANCE;
    }

    private static final MethodResult put$lambda$9(String $ownerUUID, String $key, String $value, Instant $expire, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        QueriesKt.upsert$default((Table)KVRecord.INSTANCE, (Column[])new Column[0], null, null, null, (arg_0, arg_1) -> KVSQLiteManager.put$lambda$9$lambda$8($ownerUUID, $key, $value, $expire, arg_0, arg_1), (int)14, null);
        keyChangedHook.handle($ownerUUID, $key, $value);
        return MethodResult.of((Object)true);
    }

    private static final Unit mput$lambda$11$lambda$10(String $ownerUUID, BatchUpsertStatement $this$batchUpsert, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$this$batchUpsert, (String)"$this$batchUpsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$batchUpsert.set(KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID);
        $this$batchUpsert.set(KVRecord.INSTANCE.getKey(), it.getKey());
        $this$batchUpsert.set(KVRecord.INSTANCE.getValue(), it.getValue());
        $this$batchUpsert.set(KVRecord.INSTANCE.getExpire(), null);
        return Unit.INSTANCE;
    }

    private static final int mput$lambda$11(Map $values, String $ownerUUID, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$values, (String)"$values");
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return ((Collection)QueriesKt.batchUpsert$default((Table)KVRecord.INSTANCE, (Iterable)$values.entrySet(), (Column[])new Column[0], null, null, null, (boolean)false, (arg_0, arg_1) -> KVSQLiteManager.mput$lambda$11$lambda$10($ownerUUID, arg_0, arg_1), (int)60, null)).size();
    }

    private static final MethodResult delete$lambda$14(String $ownerUUID, String $key, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table $this$deleteWhere_u24default$iv = KVRecord.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        KVRecord kVRecord = (KVRecord)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        DeleteStatement.Companion companion = DeleteStatement.Companion;
        boolean bl = false;
        Op op = OpKt.and((Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID)), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getKey(), (Object)$key)));
        companion.where(transaction, table, op, false, limit$iv);
        return MethodResult.of((Object)true);
    }

    private static final String get$lambda$15(String $ownerUUID, String $key, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        ResultRow resultRow = (ResultRow)CollectionsKt.singleOrNull((Iterable)((Iterable)KVRecord.INSTANCE.select((Expression)KVRecord.INSTANCE.getValue(), new Expression[0]).where(OpKt.and((Expression)((Expression)OpKt.and((Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID)), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getKey(), (Object)$key)))), (Expression)((Expression)INSTANCE.getNotExpireCondition())))));
        return resultRow != null ? (String)resultRow.get((Expression)KVRecord.INSTANCE.getValue()) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map mget$lambda$17(String $ownerUUID, List $keys, Transaction $this$transaction) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$keys, (String)"$keys");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Map map = new LinkedHashMap();
        Object object = new Expression[]{KVRecord.INSTANCE.getValue()};
        object = (Iterable)KVRecord.INSTANCE.select((Expression)KVRecord.INSTANCE.getKey(), (Expression[])object).where(OpKt.and((Expression)((Expression)OpKt.and((Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID)), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.inList((ExpressionWithColumnType)KVRecord.INSTANCE.getKey(), (Iterable)$keys)))), (Expression)((Expression)INSTANCE.getNotExpireCondition())));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResultRow it = (ResultRow)element$iv;
            boolean bl = false;
            map.put(it.get((Expression)KVRecord.INSTANCE.getKey()), it.get((Expression)KVRecord.INSTANCE.getValue()));
        }
        return map;
    }

    private static final Instant getExpire$lambda$19(String $ownerUUID, String $key, Transaction $this$transaction) {
        Instant instant;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        ResultRow resultRow = (ResultRow)CollectionsKt.singleOrNull((Iterable)((Iterable)KVRecord.INSTANCE.select((Expression)KVRecord.INSTANCE.getExpire(), new Expression[0]).where(OpKt.and((Expression)((Expression)OpKt.and((Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID)), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getKey(), (Object)$key)))), (Expression)((Expression)INSTANCE.getNotExpireCondition())))));
        if (resultRow != null && (n = (Integer)resultRow.get((Expression)KVRecord.INSTANCE.getExpire())) != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            instant = Instant.ofEpochSecond(it);
        } else {
            instant = null;
        }
        return instant;
    }

    /*
     * WARNING - void declaration
     */
    private static final MethodResult putExpire$lambda$22(String $ownerUUID, String $key, Instant $expire, Transaction $this$transaction) {
        block0: {
            void it;
            UpdateStatement query$iv;
            void $this$putExpire_u24lambda_u2422_u24lambda_u2420;
            Op op;
            Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
            Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
            Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
            Table $this$update_u24default$iv = KVRecord.INSTANCE;
            Integer limit$iv = null;
            boolean $i$f$update = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Integer n = limit$iv;
            ColumnSet columnSet = (ColumnSet)$this$update_u24default$iv;
            boolean $i$a$-update$default-KVSQLiteManager$putExpire$1$32 = false;
            Op op2 = op = OpKt.and((Expression)((Expression)$this$putExpire_u24lambda_u2422_u24lambda_u2420.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID)), (Expression)((Expression)$this$putExpire_u24lambda_u2422_u24lambda_u2420.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getKey(), (Object)$key)));
            Integer n2 = n;
            ColumnSet columnSet2 = columnSet;
            UpdateStatement $i$a$-update$default-KVSQLiteManager$putExpire$1$32 = query$iv = new UpdateStatement(columnSet2, n2, op2);
            KVRecord $this$putExpire_u24lambda_u2422_u24lambda_u2421 = (KVRecord)$this$update_u24default$iv;
            boolean bl = false;
            Instant instant = $expire;
            it.set(KVRecord.INSTANCE.getExpire(), (Object)(instant != null ? Integer.valueOf((int)instant.getEpochSecond()) : null));
            Integer n3 = (Integer)query$iv.execute(TransactionManager.Companion.current());
            if (n3 == null) break block0;
            n3.intValue();
        }
        return MethodResult.of((Object)true);
    }

    private static final List list$lambda$24(String $ownerUUID, Optional $glob, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$glob, (String)"$glob");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Query baseQuery = KVRecord.INSTANCE.select((Expression)KVRecord.INSTANCE.getKey(), new Expression[0]).where(OpKt.and((Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID)), (Expression)((Expression)INSTANCE.getNotExpireCondition())));
        if ($glob.isPresent()) {
            Expression expression = (Expression)KVRecord.INSTANCE.getKey();
            Object t = $glob.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            baseQuery = baseQuery.where((Op)SqlExpressionBuilder.INSTANCE.like(expression, (String)t));
        }
        List list = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)baseQuery;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResultRow it = (ResultRow)element$iv;
            boolean bl = false;
            list.add(it.get((Expression)KVRecord.INSTANCE.getKey()));
        }
        return list;
    }

    private static final Unit incr$lambda$27$lambda$25(double $value, UpsertBuilder $this$upsertReturning, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)$this$upsertReturning, (String)"$this$upsertReturning");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(KVRecord.INSTANCE.getValue(), (Expression)SQLExpressionBuilderKt.castTo((Expression)((Expression)SqlExpressionBuilder.INSTANCE.plus(SQLExpressionBuilderKt.castTo((Expression)((Expression)KVRecord.INSTANCE.getValue()), (IColumnType)((IColumnType)new DoubleColumnType())), (Object)$value)), (IColumnType)((IColumnType)new VarCharColumnType(0, null, 3, null))));
        return Unit.INSTANCE;
    }

    private static final Unit incr$lambda$27$lambda$26(String $key, String $ownerUUID, double $value, KVRecord $this$upsertReturning, UpsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$upsertReturning), (String)"$this$upsertReturning");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(KVRecord.INSTANCE.getKey(), (Object)$key);
        it.set(KVRecord.INSTANCE.getOwnerUUID(), (Object)$ownerUUID);
        it.set(KVRecord.INSTANCE.getValue(), (Object)String.valueOf($value));
        return Unit.INSTANCE;
    }

    private static final double incr$lambda$27(double $value, String $key, String $ownerUUID, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$ownerUUID, (String)"$ownerUUID");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Object[] objectArray = new Column[]{KVRecord.INSTANCE.getOwnerUUID(), KVRecord.INSTANCE.getKey()};
        Object[] objectArray2 = objectArray;
        objectArray = new Column[]{KVRecord.INSTANCE.getKey(), KVRecord.INSTANCE.getOwnerUUID()};
        return Double.parseDouble((String)((ResultRow)CollectionsKt.single((Iterable)((Iterable)QueriesKt.upsertReturning$default((Table)KVRecord.INSTANCE, (Column[])objectArray2, (List)CollectionsKt.listOf(KVRecord.INSTANCE.getValue()), (arg_0, arg_1) -> KVSQLiteManager.incr$lambda$27$lambda$25($value, arg_0, arg_1), (List)CollectionsKt.listOf((Object[])objectArray), null, (arg_0, arg_1) -> KVSQLiteManager.incr$lambda$27$lambda$26($key, $ownerUUID, $value, arg_0, arg_1), (int)16, null)))).get((Expression)KVRecord.INSTANCE.getValue()));
    }

    static {
        keyDeletedHook = KVSQLiteManager::keyDeletedHook$lambda$0;
        keyChangedHook = KVSQLiteManager::keyChangedHook$lambda$1;
    }
}

