/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.subsystems.statsq;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClientException;
import dan200.computercraft.api.lua.LuaException;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.cloudsolutions.CloudSolutionsCore;
import site.siredvin.cloudsolutions.common.configuration.ModConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019J\u001e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019J\u001e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fJ\u001e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0019R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nRP\u0010\r\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006 "}, d2={"Lsite/siredvin/cloudsolutions/subsystems/statsq/StatsDClient;", "", "<init>", "()V", "client", "Lcom/timgroup/statsd/NonBlockingStatsDClient;", "globalRateLimiter", "Lcom/google/common/util/concurrent/RateLimiter;", "kotlin.jvm.PlatformType", "getGlobalRateLimiter", "()Lcom/google/common/util/concurrent/RateLimiter;", "globalRateLimiter$delegate", "Lkotlin/Lazy;", "playerRateLimiters", "Lcom/google/common/cache/LoadingCache;", "", "Lcom/google/common/cache/LoadingCache;", "init", "", "stop", "validate", "playerUUID", "count", "aspect", "delta", "", "value", "gauge", "set", "eventName", "time", "timeInMs", "cloudsolutions-forge-1.20.1"})
public final class StatsDClient {
    @NotNull
    public static final StatsDClient INSTANCE = new StatsDClient();
    @Nullable
    private static NonBlockingStatsDClient client;
    @NotNull
    private static final Lazy globalRateLimiter$delegate;
    private static final LoadingCache<String, RateLimiter> playerRateLimiters;

    private StatsDClient() {
    }

    private final RateLimiter getGlobalRateLimiter() {
        Lazy lazy = globalRateLimiter$delegate;
        return (RateLimiter)lazy.getValue();
    }

    public final void init() {
        if (ModConfig.INSTANCE.getEnableStatsDConnection()) {
            try {
                client = new NonBlockingStatsDClient(ModConfig.INSTANCE.getStatsdPrefix(), ModConfig.INSTANCE.getStatsdHostname(), ModConfig.INSTANCE.getStatsdPort(), StatsDClient::init$lambda$2);
                CloudSolutionsCore.INSTANCE.getLogger().info("Statsd server started");
            }
            catch (StatsDClientException exc) {
                CloudSolutionsCore.INSTANCE.getLogger().warn("Cannot start statsd server, because of " + exc);
            }
        } else {
            CloudSolutionsCore.INSTANCE.getLogger().info("Ignoring statsd, because bridge are not enabled");
        }
    }

    public final void stop() {
        block0: {
            NonBlockingStatsDClient nonBlockingStatsDClient = client;
            if (nonBlockingStatsDClient == null) break block0;
            nonBlockingStatsDClient.stop();
        }
    }

    private final void validate(String playerUUID) {
        if (!this.getGlobalRateLimiter().tryAcquire()) {
            throw new LuaException("Too many requests to server, please wait a little");
        }
        if (!((RateLimiter)playerRateLimiters.get((Object)playerUUID)).tryAcquire()) {
            throw new LuaException("Too many request from you, please wait a little");
        }
        if (!ModConfig.INSTANCE.getEnableStatsDConnection()) {
            throw new LuaException("Statsd Bridge is disabled in server configuration");
        }
    }

    public final void count(@NotNull String playerUUID, @NotNull String aspect, long delta) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
            Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
            this.validate(playerUUID);
            NonBlockingStatsDClient nonBlockingStatsDClient = client;
            if (nonBlockingStatsDClient == null) break block0;
            nonBlockingStatsDClient.count(aspect, delta);
        }
    }

    public final void delta(@NotNull String playerUUID, @NotNull String aspect, long value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
            Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
            this.validate(playerUUID);
            NonBlockingStatsDClient nonBlockingStatsDClient = client;
            if (nonBlockingStatsDClient == null) break block0;
            nonBlockingStatsDClient.recordGaugeDelta(aspect, value);
        }
    }

    public final void gauge(@NotNull String playerUUID, @NotNull String aspect, long value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
            Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
            this.validate(playerUUID);
            NonBlockingStatsDClient nonBlockingStatsDClient = client;
            if (nonBlockingStatsDClient == null) break block0;
            nonBlockingStatsDClient.gauge(aspect, value);
        }
    }

    public final void set(@NotNull String playerUUID, @NotNull String aspect, @NotNull String eventName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
            Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            this.validate(playerUUID);
            NonBlockingStatsDClient nonBlockingStatsDClient = client;
            if (nonBlockingStatsDClient == null) break block0;
            nonBlockingStatsDClient.set(aspect, eventName);
        }
    }

    public final void time(@NotNull String playerUUID, @NotNull String aspect, long timeInMs) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
            Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
            this.validate(playerUUID);
            NonBlockingStatsDClient nonBlockingStatsDClient = client;
            if (nonBlockingStatsDClient == null) break block0;
            nonBlockingStatsDClient.time(aspect, timeInMs);
        }
    }

    private static final RateLimiter globalRateLimiter_delegate$lambda$0() {
        return RateLimiter.create((double)((double)ModConfig.INSTANCE.getStatsdGlobalRateLimit() / (double)60));
    }

    private static final RateLimiter playerRateLimiters$lambda$1(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return RateLimiter.create((double)((double)ModConfig.INSTANCE.getStatsdPlayerRateLimit() / (double)60));
    }

    private static final void init$lambda$2(Exception exception) {
        CloudSolutionsCore.INSTANCE.getLogger().warn("Exception inside statsd client: " + exception);
    }

    static {
        globalRateLimiter$delegate = LazyKt.lazy(StatsDClient::globalRateLimiter_delegate$lambda$0);
        playerRateLimiters = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(CacheLoader.from(StatsDClient::playerRateLimiters$lambda$1));
    }
}

