/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.subsystems.tsdb.sqlite;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import site.siredvin.cloudsolutions.subsystems.tsdb.TSDBManager;
import site.siredvin.cloudsolutions.subsystems.tsdb.TSDBManagerException;
import site.siredvin.cloudsolutions.subsystems.tsdb.TimeseriesFrame;
import site.siredvin.cloudsolutions.subsystems.tsdb.TimeseriesInformation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003JI\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J;\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000e2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J+\u0010%\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0\tH\u0016\u00a2\u0006\u0004\b%\u0010&J-\u0010)\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u000b\u00a2\u0006\u0004\b)\u0010*J5\u0010,\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000b0+0\t\u00a2\u0006\u0004\b,\u0010&R\u001f\u0010/\u001a\n .*\u0004\u0018\u00010-0-8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102\u00a8\u00063"}, d2={"Lsite/siredvin/cloudsolutions/subsystems/tsdb/sqlite/TSDBSQLiteManager;", "Lsite/siredvin/cloudsolutions/subsystems/tsdb/TSDBManager;", "<init>", "()V", "", "init", "", "ownerUUID", "namePattern", "", "tags", "Ljava/time/Instant;", "from", "to", "", "Lsite/siredvin/cloudsolutions/subsystems/tsdb/TimeseriesFrame;", "query", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/time/Instant;Ljava/time/Instant;)Ljava/util/List;", "name", "", "retention", "Ljava/util/UUID;", "getOrCreate", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;I)Ljava/util/UUID;", "timeseriesId", "update", "(Ljava/lang/String;Ljava/util/UUID;I)V", "delete", "(Ljava/lang/String;Ljava/util/UUID;)V", "Lsite/siredvin/cloudsolutions/subsystems/tsdb/TimeseriesInformation;", "list", "(Ljava/lang/String;)Ljava/util/List;", "", "measurementValue", "put", "(Ljava/lang/String;Ljava/util/UUID;D)V", "values", "putMany", "(Ljava/lang/String;Ljava/util/Map;)V", "value", "timestamp", "backfill", "(Ljava/lang/String;Ljava/util/UUID;DLjava/time/Instant;)V", "Lkotlin/Pair;", "backfillMany", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "getDateFormatter", "()Ljava/time/format/DateTimeFormatter;", "cloudsolutions-fabric-1.20.1"})
public final class TSDBSQLiteManager
implements TSDBManager {
    @NotNull
    public static final TSDBSQLiteManager INSTANCE = new TSDBSQLiteManager();
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT).withZone(ZoneId.systemDefault());

    private TSDBSQLiteManager() {
    }

    public final DateTimeFormatter getDateFormatter() {
        return dateFormatter;
    }

    @Override
    public void init() {
    }

    @Override
    @NotNull
    public List<TimeseriesFrame> query(@NotNull String ownerUUID, @NotNull String namePattern, @NotNull Map<String, String> tags, @NotNull Instant from, @NotNull Instant to) throws TSDBManagerException {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (from.compareTo(to) >= 0) {
            throw new TSDBManagerException("From timestamp should be lower then to timestamp");
        }
        String sqlNamePattern = StringsKt.endsWith$default((String)namePattern, (String)"*", (boolean)false, (int)2, null) ? StringsKt.removeSuffix((String)namePattern, (CharSequence)"*") + "%" : namePattern;
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public UUID getOrCreate(@NotNull String ownerUUID, @NotNull String name, @NotNull Map<String, String> tags, int retention) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new UUID(0L, 0L);
    }

    @Override
    public void update(@NotNull String ownerUUID, @NotNull UUID timeseriesId, int retention) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)timeseriesId, (String)"timeseriesId");
    }

    @Override
    public void delete(@NotNull String ownerUUID, @NotNull UUID timeseriesId) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)timeseriesId, (String)"timeseriesId");
    }

    @Override
    @NotNull
    public List<TimeseriesInformation> list(@NotNull String ownerUUID) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        return CollectionsKt.emptyList();
    }

    @Override
    public void put(@NotNull String ownerUUID, @NotNull UUID timeseriesId, double measurementValue) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)timeseriesId, (String)"timeseriesId");
    }

    @Override
    public void putMany(@NotNull String ownerUUID, @NotNull Map<UUID, Double> values) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter(values, (String)"values");
    }

    public final void backfill(@NotNull String ownerUUID, @NotNull UUID timeseriesId, double value, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)timeseriesId, (String)"timeseriesId");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
    }

    public final void backfillMany(@NotNull String ownerUUID, @NotNull Map<UUID, Pair<Double, Instant>> values) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter(values, (String)"values");
    }
}

