/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.subsystems.kv.sqlite;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dan200.computercraft.api.lua.LuaException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.JDBC;
import site.siredvin.cloudsolutions.CloudSolutionsCore;
import site.siredvin.cloudsolutions.common.configuration.ModConfig;
import site.siredvin.cloudsolutions.subsystems.kv.KeyValueManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\u001dH\u0002J*\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J$\u0010*\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001b2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0,H\u0016J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0016J\u001a\u0010.\u001a\u0004\u0018\u00010\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0016J*\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0,2\u0006\u0010%\u001a\u00020\u001b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001b01H\u0016J\u001a\u00102\u001a\u0004\u0018\u00010)2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0016J\"\u00103\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J$\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b012\u0006\u0010%\u001a\u00020\u001b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001b06H\u0016J \u00107\u001a\u0002082\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u000208H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0012\u0012\u0002\b\u0003 \u0018*\b\u0012\u0002\b\u0003\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lsite/siredvin/cloudsolutions/subsystems/kv/sqlite/KVSQLiteManager;", "Lsite/siredvin/cloudsolutions/subsystems/kv/KeyValueManager;", "<init>", "()V", "queryPrepareLock", "Ljava/util/concurrent/locks/ReentrantLock;", "db", "Ljava/sql/Connection;", "cleanupFuture", "Ljava/util/concurrent/ScheduledFuture;", "cleanupQuery", "Ljava/sql/PreparedStatement;", "countQuery", "insertQuery", "deleteQuery", "getQuery", "getExQuery", "putExQuery", "listQuery", "globListQuery", "gson", "Lcom/google/gson/Gson;", "mapType", "Lcom/google/gson/reflect/TypeToken;", "kotlin.jvm.PlatformType", "Lcom/google/gson/reflect/TypeToken;", "rawInsertQuery", "", "init", "", "server", "Lnet/minecraft/server/MinecraftServer;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "stop", "cleanup", "put", "ownerUUID", "key", "value", "expire", "Ljava/time/Instant;", "mput", "values", "", "delete", "get", "mget", "keys", "", "getExpire", "putExpire", "list", "glob", "Ljava/util/Optional;", "incr", "", "cloudsolutions-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nKVSQLiteManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KVSQLiteManager.kt\nsite/siredvin/cloudsolutions/subsystems/kv/sqlite/KVSQLiteManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n1863#2,2:255\n*S KotlinDebug\n*F\n+ 1 KVSQLiteManager.kt\nsite/siredvin/cloudsolutions/subsystems/kv/sqlite/KVSQLiteManager\n*L\n122#1:255,2\n*E\n"})
public final class KVSQLiteManager
implements KeyValueManager {
    @NotNull
    public static final KVSQLiteManager INSTANCE = new KVSQLiteManager();
    @NotNull
    private static final ReentrantLock queryPrepareLock = new ReentrantLock();
    @Nullable
    private static Connection db;
    @Nullable
    private static ScheduledFuture<?> cleanupFuture;
    @Nullable
    private static PreparedStatement cleanupQuery;
    @Nullable
    private static PreparedStatement countQuery;
    @Nullable
    private static PreparedStatement insertQuery;
    @Nullable
    private static PreparedStatement deleteQuery;
    @Nullable
    private static PreparedStatement getQuery;
    @Nullable
    private static PreparedStatement getExQuery;
    @Nullable
    private static PreparedStatement putExQuery;
    @Nullable
    private static PreparedStatement listQuery;
    @Nullable
    private static PreparedStatement globListQuery;
    @NotNull
    private static final Gson gson;
    private static final TypeToken<?> mapType;
    @NotNull
    private static final String rawInsertQuery;

    private KVSQLiteManager() {
    }

    @Override
    public void init(@NotNull MinecraftServer server, @NotNull ScheduledExecutorService executor) {
        Statement statement;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        String[] stringArray = new String[]{"cloudsolutions"};
        Path dirPath = Paths.get(((Object)server.m_129843_(LevelResource.f_78182_)).toString(), stringArray);
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            Files.createDirectory(dirPath, new FileAttribute[0]);
        }
        String[] stringArray2 = new String[]{"cloudsolutions", "kv.db"};
        String dbPath = ((Object)Paths.get(((Object)server.m_129843_(LevelResource.f_78182_)).toString(), stringArray2)).toString();
        Connection connection = db = (Connection)JDBC.createConnection((String)("jdbc:sqlite:" + dbPath), (Properties)new Properties());
        if (connection != null) {
            connection.setAutoCommit(true);
        }
        Connection connection2 = db;
        Statement statement2 = statement = connection2 != null ? connection2.createStatement() : null;
        if (statement2 != null) {
            statement2.execute("create table if not exists kv_records_1(ownerUUID varchar(255) not null , key varchar(255) not null , value text not null , expire integer)");
        }
        Statement statement3 = statement;
        if (statement3 != null) {
            statement3.execute("create index if not exists kv_owner on kv_records_1 (ownerUUID)");
        }
        Statement statement4 = statement;
        if (statement4 != null) {
            statement4.execute("create unique index if not exists kv_owner_key on kv_records_1 (ownerUUID, key)");
        }
        Connection connection3 = db;
        cleanupQuery = connection3 != null ? connection3.prepareStatement("delete from kv_records_1 where expire < ?") : null;
        Connection connection4 = db;
        countQuery = connection4 != null ? connection4.prepareStatement("select count(*) from kv_records_1 where ownerUUID = ? and (expire is null or expire <= ?)") : null;
        Connection connection5 = db;
        insertQuery = connection5 != null ? connection5.prepareStatement(rawInsertQuery) : null;
        Connection connection6 = db;
        deleteQuery = connection6 != null ? connection6.prepareStatement("delete from kv_records_1 where ownerUUID = ? and key = ?") : null;
        Connection connection7 = db;
        getQuery = connection7 != null ? connection7.prepareStatement("select value from kv_records_1 where ownerUUID = ? and key = ? and (expire is null or expire <= ?)") : null;
        Connection connection8 = db;
        getExQuery = connection8 != null ? connection8.prepareStatement("select expire from kv_records_1 where ownerUUID = ? and key = ? and (expire is null or expire <= ?)") : null;
        Connection connection9 = db;
        putExQuery = connection9 != null ? connection9.prepareStatement("update kv_records_1 set expire = ? where ownerUUID = ? and key = ? and (expire is null or expire <= ?)") : null;
        Connection connection10 = db;
        listQuery = connection10 != null ? connection10.prepareStatement("select key from kv_records_1 where ownerUUID = ? and(expire is null or expire <= ?)") : null;
        Connection connection11 = db;
        globListQuery = connection11 != null ? connection11.prepareStatement("select key from kv_records_1 where ownerUUID = ? and(expire is null or expire <= ?) and key GLOB ?") : null;
        cleanupFuture = executor.scheduleWithFixedDelay(KVSQLiteManager::init$lambda$0, 0L, 1L, TimeUnit.MINUTES);
        ScheduledFuture<?> scheduledFuture = cleanupFuture;
        ScheduledFuture<?> scheduledFuture2 = cleanupFuture;
        CloudSolutionsCore.INSTANCE.getLogger().info("Result of cleanup future: {}, {}", (Object)(scheduledFuture != null ? Boolean.valueOf(scheduledFuture.isDone()) : null), (Object)(scheduledFuture2 != null ? Boolean.valueOf(scheduledFuture2.isCancelled()) : null));
    }

    @Override
    public void stop(@NotNull MinecraftServer server, @NotNull ScheduledExecutorService executor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            ScheduledFuture<?> scheduledFuture = cleanupFuture;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup() {
        try {
            ReentrantLock reentrantLock = queryPrepareLock;
            reentrantLock.lock();
            try {
                boolean $i$a$-withLock-KVSQLiteManager$cleanup$22 = false;
                CloudSolutionsCore.INSTANCE.getLogger().info("Run KV cleanup");
                long now = Instant.now().getEpochSecond();
                PreparedStatement preparedStatement = cleanupQuery;
                if (preparedStatement != null) {
                    preparedStatement.setInt(1, (int)now);
                }
                PreparedStatement preparedStatement2 = cleanupQuery;
                Boolean $i$a$-withLock-KVSQLiteManager$cleanup$22 = preparedStatement2 != null ? Boolean.valueOf(preparedStatement2.execute()) : null;
            }
            finally {
                reentrantLock.unlock();
            }
        }
        catch (Exception ex) {
            CloudSolutionsCore.INSTANCE.getLogger().catching((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NotNull String ownerUUID, @NotNull String key, @NotNull String value, @Nullable Instant expire) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ReentrantLock reentrantLock = queryPrepareLock;
        reentrantLock.lock();
        try {
            int count;
            ResultSet result;
            boolean bl = false;
            PreparedStatement preparedStatement = countQuery;
            if (preparedStatement != null) {
                preparedStatement.setString(1, ownerUUID);
            }
            PreparedStatement preparedStatement2 = countQuery;
            if (preparedStatement2 != null) {
                preparedStatement2.setLong(2, Instant.now().getEpochSecond());
            }
            PreparedStatement preparedStatement3 = countQuery;
            ResultSet resultSet = result = preparedStatement3 != null ? preparedStatement3.executeQuery() : null;
            int n = count = resultSet != null ? resultSet.getInt(1) : 0;
            if (count >= ModConfig.INSTANCE.getKvStorageKeyLimit()) {
                throw new LuaException("You have exceeded key limit per player");
            }
            PreparedStatement preparedStatement4 = insertQuery;
            if (preparedStatement4 != null) {
                preparedStatement4.setString(1, ownerUUID);
            }
            PreparedStatement preparedStatement5 = insertQuery;
            if (preparedStatement5 != null) {
                preparedStatement5.setString(2, key);
            }
            PreparedStatement preparedStatement6 = insertQuery;
            if (preparedStatement6 != null) {
                preparedStatement6.setString(3, value);
            }
            PreparedStatement preparedStatement7 = insertQuery;
            if (preparedStatement7 != null) {
                preparedStatement7.setString(5, value);
            }
            if (expire != null) {
                PreparedStatement preparedStatement8 = insertQuery;
                if (preparedStatement8 != null) {
                    preparedStatement8.setInt(4, (int)expire.getEpochSecond());
                }
                PreparedStatement preparedStatement9 = insertQuery;
                if (preparedStatement9 != null) {
                    preparedStatement9.setInt(6, (int)expire.getEpochSecond());
                }
            } else {
                PreparedStatement preparedStatement10 = insertQuery;
                if (preparedStatement10 != null) {
                    preparedStatement10.setNull(4, 0);
                }
                PreparedStatement preparedStatement11 = insertQuery;
                if (preparedStatement11 != null) {
                    preparedStatement11.setNull(6, 0);
                }
            }
            PreparedStatement preparedStatement12 = insertQuery;
            Boolean bl2 = preparedStatement12 != null ? Boolean.valueOf(preparedStatement12.execute()) : null;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mput(@NotNull String ownerUUID, @NotNull Map<String, String> values) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        if (values.isEmpty()) {
            return;
        }
        ReentrantLock reentrantLock = queryPrepareLock;
        reentrantLock.lock();
        try {
            Unit unit;
            boolean bl = false;
            AutoCloseable autoCloseable = db;
            if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(rawInsertQuery)) == null) {
                return;
            }
            AutoCloseable query = autoCloseable;
            Connection connection = db;
            if (connection != null) {
                connection.setAutoCommit(false);
            }
            try {
                Unit unit2;
                Iterable $this$forEach$iv = values.entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    query.setString(1, ownerUUID);
                    query.setString(2, (String)it.getKey());
                    query.setString(3, (String)it.getValue());
                    query.setNull(4, 0);
                    query.addBatch();
                }
                query.executeBatch();
                Connection connection2 = db;
                if (connection2 != null) {
                    connection2.commit();
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                unit = unit2;
            }
            catch (SQLException e) {
                Connection connection3 = db;
                if (connection3 != null) {
                    connection3.rollback();
                }
                throw e;
            }
            finally {
                Connection connection4 = db;
                if (connection4 != null) {
                    connection4.setAutoCommit(true);
                }
            }
            Unit unit3 = unit;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull String ownerUUID, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ReentrantLock reentrantLock = queryPrepareLock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            PreparedStatement preparedStatement = deleteQuery;
            if (preparedStatement != null) {
                preparedStatement.setString(1, ownerUUID);
            }
            PreparedStatement preparedStatement2 = deleteQuery;
            if (preparedStatement2 != null) {
                preparedStatement2.setString(2, key);
            }
            PreparedStatement preparedStatement3 = deleteQuery;
            Boolean bl2 = preparedStatement3 != null ? Boolean.valueOf(preparedStatement3.execute()) : null;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String get(@NotNull String ownerUUID, @NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ReentrantLock reentrantLock = queryPrepareLock;
        reentrantLock.lock();
        try {
            ResultSet result;
            boolean bl = false;
            PreparedStatement preparedStatement = getQuery;
            if (preparedStatement != null) {
                preparedStatement.setString(1, ownerUUID);
            }
            PreparedStatement preparedStatement2 = getQuery;
            if (preparedStatement2 != null) {
                preparedStatement2.setString(2, key);
            }
            PreparedStatement preparedStatement3 = getQuery;
            if (preparedStatement3 != null) {
                preparedStatement3.setLong(3, Instant.now().getEpochSecond());
            }
            PreparedStatement preparedStatement4 = getQuery;
            ResultSet resultSet = result = preparedStatement4 != null ? preparedStatement4.executeQuery() : null;
            string = resultSet != null ? resultSet.getString(1) : null;
        }
        finally {
            reentrantLock.unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, String> mget(@NotNull String ownerUUID, @NotNull List<String> keys) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        if (keys.isEmpty()) {
            return MapsKt.emptyMap();
        }
        ReentrantLock reentrantLock = queryPrepareLock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            String placeholders = String.join((CharSequence)",", (Iterable<? extends CharSequence>)Collections.nCopies(keys.size(), "?"));
            String rawQuery = StringsKt.trimIndent((String)("SELECT json_group_object(key, value) as result from kv_records_1\n        where ownerUUID = ? and(expire is null or expire <= ?) and key in (" + placeholders + ")\n            "));
            AutoCloseable autoCloseable = db;
            if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(rawQuery)) == null) {
                Map map2 = MapsKt.emptyMap();
                return map2;
            }
            AutoCloseable query = autoCloseable;
            query.setString(1, ownerUUID);
            query.setLong(2, Instant.now().getEpochSecond());
            int n = keys.size();
            for (int i = 0; i < n; ++i) {
                query.setString(i + 3, keys.get(i));
            }
            ResultSet result = query.executeQuery();
            Object object = gson.fromJson(result.getString("result"), mapType);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            map = (Map)object;
        }
        finally {
            reentrantLock.unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Instant getExpire(@NotNull String ownerUUID, @NotNull String key) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ReentrantLock reentrantLock = queryPrepareLock;
        reentrantLock.lock();
        try {
            ResultSet result;
            boolean bl = false;
            PreparedStatement preparedStatement = getExQuery;
            if (preparedStatement != null) {
                preparedStatement.setString(1, ownerUUID);
            }
            PreparedStatement preparedStatement2 = getExQuery;
            if (preparedStatement2 != null) {
                preparedStatement2.setString(2, key);
            }
            PreparedStatement preparedStatement3 = getExQuery;
            if (preparedStatement3 != null) {
                preparedStatement3.setLong(3, Instant.now().getEpochSecond());
            }
            PreparedStatement preparedStatement4 = getExQuery;
            ResultSet resultSet = result = preparedStatement4 != null ? preparedStatement4.executeQuery() : null;
            if (resultSet == null) {
                Instant instant2 = null;
                return instant2;
            }
            long epoch = resultSet.getInt(1);
            instant = Instant.ofEpochSecond(epoch);
        }
        finally {
            reentrantLock.unlock();
        }
        return instant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putExpire(@NotNull String ownerUUID, @NotNull String key, @Nullable Instant expire) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ReentrantLock reentrantLock = queryPrepareLock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            if (expire != null) {
                PreparedStatement preparedStatement = putExQuery;
                if (preparedStatement != null) {
                    preparedStatement.setInt(1, (int)expire.getEpochSecond());
                }
            } else {
                PreparedStatement preparedStatement = putExQuery;
                if (preparedStatement != null) {
                    preparedStatement.setNull(1, 0);
                }
            }
            PreparedStatement preparedStatement = putExQuery;
            if (preparedStatement != null) {
                preparedStatement.setString(2, ownerUUID);
            }
            PreparedStatement preparedStatement2 = putExQuery;
            if (preparedStatement2 != null) {
                preparedStatement2.setString(3, key);
            }
            PreparedStatement preparedStatement3 = putExQuery;
            if (preparedStatement3 != null) {
                preparedStatement3.setLong(4, Instant.now().getEpochSecond());
            }
            PreparedStatement preparedStatement4 = putExQuery;
            Boolean bl2 = preparedStatement4 != null ? Boolean.valueOf(preparedStatement4.execute()) : null;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> list(@NotNull String ownerUUID, @NotNull Optional<String> glob) {
        List list;
        PreparedStatement preparedStatement;
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter(glob, (String)"glob");
        if (glob.isPresent()) {
            PreparedStatement preparedStatement2 = globListQuery;
            preparedStatement = preparedStatement2;
            Intrinsics.checkNotNull((Object)preparedStatement2);
        } else {
            PreparedStatement preparedStatement3 = listQuery;
            preparedStatement = preparedStatement3;
            Intrinsics.checkNotNull((Object)preparedStatement3);
        }
        PreparedStatement query = preparedStatement;
        ReentrantLock reentrantLock = queryPrepareLock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            query.setString(1, ownerUUID);
            query.setLong(2, Instant.now().getEpochSecond());
            if (glob.isPresent()) {
                query.setString(3, glob.get());
            }
            ResultSet result = query.executeQuery();
            List values = new ArrayList();
            if (result != null) {
                while (result.next()) {
                    String string = result.getString(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    values.add(string);
                }
            }
            list = values;
        }
        finally {
            reentrantLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double incr(@NotNull String ownerUUID, @NotNull String key, double value) {
        double d;
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        AutoCloseable autoCloseable = db;
        if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement("INSERT INTO kv_records_1 (key, value, ownerUUID, expire)\nVALUES (?, ?, ?, ?)\nON CONFLICT(ownerUUID, key) DO UPDATE SET value = CAST(value AS REAL) + ?\nRETURNING value as REAL;")) == null) {
            return 0.0;
        }
        AutoCloseable preparedQuery = autoCloseable;
        preparedQuery.setString(1, key);
        preparedQuery.setString(2, String.valueOf(value));
        preparedQuery.setString(3, ownerUUID);
        preparedQuery.setNull(4, 0);
        preparedQuery.setDouble(5, value);
        ReentrantLock reentrantLock = queryPrepareLock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            ResultSet result = preparedQuery.executeQuery();
            if (result == null) {
                double d2 = 0.0;
                return d2;
            }
            result.next();
            d = result.getDouble(1);
        }
        finally {
            reentrantLock.unlock();
        }
        return d;
    }

    private static final void init$lambda$0() {
        INSTANCE.cleanup();
    }

    static {
        gson = new Gson();
        Type[] typeArray = new Type[]{String.class, String.class};
        mapType = TypeToken.getParameterized((Type)((Type)((Object)Map.class)), (Type[])typeArray);
        rawInsertQuery = "insert into kv_records_1 (ownerUUID, key, value, expire)\nvalues (?, ?, ?, ?) on conflict(ownerUUID, key) DO UPDATE SET value = ?, expire = ?";
    }
}

