/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.cloudsolutions.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.cloudsolutions.common.configuration.ModConfig;
import site.siredvin.cloudsolutions.subsystems.SubsystemManager;
import site.siredvin.cloudsolutions.subsystems.kv.KeyValueManager;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0007J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00192\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019H\u0007J\u0018\u0010\u001b\u001a\u00020\u00102\u000e\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019H\u0007J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0007J\u001e\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020$0\u0014H\u0007J\u001e\u0010%\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020$0\u0014H\u0007R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lsite/siredvin/cloudsolutions/computercraft/peripheral/KVStoragePeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "owner", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "isEnabled", "", "()Z", "peripheralConfiguration", "", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "put", "", "key", "value", "expire", "Ljava/util/Optional;", "", "delete", "get", "mget", "", "keys", "mput", "values", "getEx", "(Ljava/lang/String;)Ljava/lang/Long;", "putEx", "list", "", "glob", "incr", "", "decr", "Companion", "cloudsolutions-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nKVStoragePeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KVStoragePeripheral.kt\nsite/siredvin/cloudsolutions/computercraft/peripheral/KVStoragePeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,94:1\n1557#2:95\n1628#2,3:96\n1246#2,4:101\n462#3:99\n412#3:100\n477#3:105\n423#3:106\n*S KotlinDebug\n*F\n+ 1 KVStoragePeripheral.kt\nsite/siredvin/cloudsolutions/computercraft/peripheral/KVStoragePeripheral\n*L\n54#1:95\n54#1:96,3\n60#1:101,4\n60#1:99\n60#1:100\n60#1:105\n60#1:106\n*E\n"})
public final class KVStoragePeripheral
extends OwnedPeripheral<IPeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TYPE = "kv_storage";
    @NotNull
    private static final ResourceLocation ID = new ResourceLocation("cloudsolutions", "kv_storage");

    public KVStoragePeripheral(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(TYPE, owner);
    }

    public boolean isEnabled() {
        return ModConfig.INSTANCE.getEnableKVStorage();
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map data = super.getPeripheralConfiguration();
        data.put("keyLimit", ModConfig.INSTANCE.getKvStorageKeyLimit());
        data.put("valueLimit", ModConfig.INSTANCE.getKvStorageValueLimit());
        return data;
    }

    @LuaFunction
    public final void put(@NotNull String key, @NotNull String value, @NotNull Optional<Long> expire) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(expire, (String)"expire");
            if (value.length() > ModConfig.INSTANCE.getKvStorageValueLimit()) {
                throw new LuaException("Value is too long");
            }
            Player player = this.getPeripheralOwner().getOwner();
            if (player == null) {
                throw new LuaException("Cannot find attached player to this peripheral");
            }
            Player player2 = player;
            KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
            if (keyValueManager == null) break block2;
            String string = player2.m_20149_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
            Optional<Instant> optional = expire.map(arg_0 -> KVStoragePeripheral.put$lambda$1(KVStoragePeripheral::put$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
            keyValueManager.put(string, key, value, (Instant)OptionalsKt.getOrNull(optional));
        }
    }

    @LuaFunction
    public final void delete(@NotNull String key) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Player player = this.getPeripheralOwner().getOwner();
            if (player == null) {
                throw new LuaException("Cannot find attached player to this peripheral");
            }
            Player player2 = player;
            KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
            if (keyValueManager == null) break block1;
            String string = player2.m_20149_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
            keyValueManager.delete(string, key);
        }
    }

    @LuaFunction
    @Nullable
    public final String get(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Player player = this.getPeripheralOwner().getOwner();
        if (player == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        Player player2 = player;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        if (keyValueManager != null) {
            String string2 = player2.m_20149_();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStringUUID(...)");
            string = keyValueManager.get(string2, key);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final Map<String, String> mget(@NotNull Map<?, ?> keys) {
        Map<String, String> map;
        block6: {
            block5: {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(keys, (String)"keys");
                Player player = this.getPeripheralOwner().getOwner();
                if (player == null) {
                    throw new LuaException("Cannot find attached player to this peripheral");
                }
                Player player2 = player;
                map = SubsystemManager.INSTANCE.getKvManager();
                if (map == null) break block5;
                String string = player2.m_20149_();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
                Iterable iterable = keys.values();
                String string2 = string;
                Map<String, String> map2 = map;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(String.valueOf(it));
                }
                collection = (List)destination$iv$iv;
                map = map2.mget(string2, CollectionsKt.toList((Iterable)collection));
                if (map != null) break block6;
            }
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    public final void mput(@NotNull Map<?, ?> values) {
        block3: {
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Map map;
            Map.Entry it$iv$iv;
            Object object;
            Map.Entry entry;
            void $this$mapValuesTo$iv$iv;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Player player = this.getPeripheralOwner().getOwner();
            if (player == null) {
                throw new LuaException("Cannot find attached player to this peripheral");
            }
            Player player2 = player;
            Map $this$mapValues$iv = values;
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl3 = false;
                object = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                map = map3;
                boolean bl2 = false;
                String string = String.valueOf(it.getValue());
                map.put(k, string);
            }
            $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapKeys = false;
            $this$mapValuesTo$iv$iv = $this$mapKeys$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv2;
                void it;
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map = destination$iv$iv;
                boolean bl = false;
                Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
                object = String.valueOf(it.getKey());
                Map map4 = map;
                boolean bl4 = false;
                entry = it$iv$iv2.getValue();
                map4.put(object, entry);
            }
            Map transformedMap = destination$iv$iv;
            KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
            if (keyValueManager == null) break block3;
            String string = player2.m_20149_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
            keyValueManager.mput(string, transformedMap);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction(value={"get_ex"})
    @Nullable
    public final Long getEx(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Player player = this.getPeripheralOwner().getOwner();
        if (player == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        Player player2 = player;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        Object object = keyValueManager;
        if (keyValueManager == null) return null;
        String string = player2.m_20149_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
        Instant instant = object.getExpire(string, key);
        object = instant;
        if (instant == null) return null;
        Long l = ((Instant)object).getEpochSecond();
        return l;
    }

    @LuaFunction(value={"put_ex"})
    public final void putEx(@NotNull String key, @NotNull Optional<Long> expire) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(expire, (String)"expire");
            Player player = this.getPeripheralOwner().getOwner();
            if (player == null) {
                throw new LuaException("Cannot find attached player to this peripheral");
            }
            Player player2 = player;
            KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
            if (keyValueManager == null) break block1;
            String string = player2.m_20149_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
            Optional<Instant> optional = expire.map(arg_0 -> KVStoragePeripheral.putEx$lambda$6(KVStoragePeripheral::putEx$lambda$5, arg_0));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
            keyValueManager.putExpire(string, key, (Instant)OptionalsKt.getOrNull(optional));
        }
    }

    @LuaFunction
    @NotNull
    public final List<String> list(@NotNull Optional<String> glob) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(glob, (String)"glob");
                Player player = this.getPeripheralOwner().getOwner();
                if (player == null) {
                    throw new LuaException("Cannot find attached player to this peripheral");
                }
                Player player2 = player;
                object = SubsystemManager.INSTANCE.getKvManager();
                if (object == null) break block4;
                String string = player2.m_20149_();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
                if ((object = object.list(string, glob)) != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @LuaFunction
    public final double incr(@NotNull String key, @NotNull Optional<Double> value) {
        double d;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Player player = this.getPeripheralOwner().getOwner();
        if (player == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        Player player2 = player;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        if (keyValueManager != null) {
            String string = player2.m_20149_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
            Double d2 = value.orElse(1.0);
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"orElse(...)");
            d = keyValueManager.incr(string, key, ((Number)d2).doubleValue());
        } else {
            d = 0.0;
        }
        return d;
    }

    @LuaFunction
    public final double decr(@NotNull String key, @NotNull Optional<Double> value) {
        double d;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Player player = this.getPeripheralOwner().getOwner();
        if (player == null) {
            throw new LuaException("Cannot find attached player to this peripheral");
        }
        Player player2 = player;
        KeyValueManager keyValueManager = SubsystemManager.INSTANCE.getKvManager();
        if (keyValueManager != null) {
            String string = player2.m_20149_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
            d = keyValueManager.incr(string, key, -((Number)value.orElse(1.0)).doubleValue());
        } else {
            d = 0.0;
        }
        return d;
    }

    private static final Instant put$lambda$0(Long it) {
        Intrinsics.checkNotNull((Object)it);
        return Instant.ofEpochSecond(it);
    }

    private static final Instant put$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Instant)$tmp0.invoke(p0);
    }

    private static final Instant putEx$lambda$5(Long it) {
        Intrinsics.checkNotNull((Object)it);
        return Instant.ofEpochSecond(it);
    }

    private static final Instant putEx$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Instant)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lsite/siredvin/cloudsolutions/computercraft/peripheral/KVStoragePeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "cloudsolutions-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

