/*
 * Decompiled with CFR 0.152.
 */
package lol.demovio.createtouchpadscrollingfix;

import com.mojang.serialization.Codec;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import lol.demovio.createtouchpadscrollingfix.CreateTouchpadScrollingFix;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_7172;

@Environment(value=EnvType.CLIENT)
public class CreateTouchpadScrollingFixSettings {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("create-touchpad-scrolling-fix.properties");
    public static final class_7172<Double> scrollStepSize = new class_7172("createTouchpadScrollingFix.options.scrollStepSize", class_7172.method_42399(), (optionText, value) -> {
        if (value.equals(0.0)) {
            return class_2561.method_43471((String)"createTouchpadScrollingFix.options.scrollStepSizeOff");
        }
        String valueStr = value.toString();
        if (value < 1.0) {
            return class_2561.method_43469((String)"createTouchpadScrollingFix.options.scrollStepSizeLabelHigh", (Object[])new Object[]{valueStr});
        }
        if (value < 2.0) {
            return class_2561.method_43469((String)"createTouchpadScrollingFix.options.scrollStepSizeLabelMedium", (Object[])new Object[]{valueStr});
        }
        return class_2561.method_43469((String)"createTouchpadScrollingFix.options.scrollStepSizeLabelLow", (Object[])new Object[]{valueStr});
    }, (class_7172.class_7178)new class_7172.class_7174(0, 30).method_42414(sliderProgressValue -> (double)sliderProgressValue / 10.0, value -> (int)(value * 10.0)), Codec.doubleRange((double)0.0, (double)3.0), (Object)1.5, value -> {});

    public static void load() {
        Properties props = new Properties();
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
                props.load(in);
                if (props.containsKey("scrollStepSize")) {
                    scrollStepSize.method_41748((Object)Double.parseDouble(props.getProperty("scrollStepSize")));
                }
            }
            catch (Exception e) {
                CreateTouchpadScrollingFix.LOGGER.error("Error while reading scrollStepSize value from config/create-touchpad-scrolling-fix.properties");
            }
        }
    }

    public static void save() {
        Properties props = new Properties();
        props.setProperty("scrollStepSize", ((Double)scrollStepSize.method_41753()).toString());
        try (OutputStream out = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);){
            props.store(out, "Create Touchpad Scrolling Fix Config");
        }
        catch (Exception e) {
            CreateTouchpadScrollingFix.LOGGER.error("Error while saving scrollStepSize value to config/create-touchpad-scrolling-fix.properties");
        }
    }
}

