/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.manhuntX;

import de.scholle.manhuntX.commands.CompassCommand;
import de.scholle.manhuntX.commands.ManhuntCommand;
import de.scholle.manhuntX.commands.ManhuntTabCompleter;
import de.scholle.manhuntX.listeners.GameListener;
import de.scholle.manhuntX.listeners.InventoryListener;
import de.scholle.manhuntX.listeners.PlayerListener;
import de.scholle.manhuntX.managers.ConfigManager;
import de.scholle.manhuntX.managers.GameManager;
import de.scholle.manhuntX.managers.TeamManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ManhuntX
extends JavaPlugin {
    private static ManhuntX instance;
    private GameManager gameManager;
    private TeamManager teamManager;
    private ConfigManager configManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager();
        this.teamManager = new TeamManager();
        this.gameManager = new GameManager();
        this.registerCommands();
        this.registerListeners();
        this.configManager.loadConfig();
        this.getLogger().info("ManhuntX has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("ManhuntX has been disabled!");
    }

    private void registerCommands() {
        this.getCommand("manhuntx").setExecutor((CommandExecutor)new ManhuntCommand());
        this.getCommand("compass").setExecutor((CommandExecutor)new CompassCommand());
        this.getCommand("manhuntx").setTabCompleter((TabCompleter)new ManhuntTabCompleter());
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GameListener(), (Plugin)this);
    }

    public static ManhuntX getInstance() {
        return instance;
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

