/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.manhuntX.managers;

import de.scholle.manhuntX.ManhuntX;
import de.scholle.manhuntX.managers.TeamManager;
import de.scholle.manhuntX.util.ChallengeType;
import de.scholle.manhuntX.util.GameState;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GameManager {
    private GameState gameState = GameState.WAITING;
    private ChallengeType challengeType = ChallengeType.KILL_ENDER_DRAGON;
    private int survivalTime = 3600;
    private int preparationTime = 0;
    private int gameTime;
    private HashMap<UUID, Long> runnerStartTimes = new HashMap();
    private BukkitRunnable gameTimer;

    public void startGame() {
        if (this.gameState != GameState.WAITING) {
            return;
        }
        this.gameState = GameState.PREPARATION;
        TeamManager teamManager = ManhuntX.getInstance().getTeamManager();
        for (UUID runnerId : teamManager.getRunners()) {
            Player runner = Bukkit.getPlayer((UUID)runnerId);
            if (runner == null) continue;
            String challengeMessage = this.getChallengeStartMessage();
            runner.sendTitle(String.valueOf(ChatColor.YELLOW) + "Start", String.valueOf(ChatColor.YELLOW) + challengeMessage);
            this.runnerStartTimes.put(runnerId, System.currentTimeMillis());
        }
        for (UUID hunterId : teamManager.getHunters()) {
            Player hunter = Bukkit.getPlayer((UUID)hunterId);
            if (hunter == null) continue;
            hunter.sendTitle(String.valueOf(ChatColor.YELLOW) + "Start", String.valueOf(ChatColor.YELLOW) + "Kill the Runner");
        }
        if (this.preparationTime > 0) {
            this.startPreparationPhase();
        } else {
            this.startMainGame();
        }
    }

    private void startPreparationPhase() {
        new BukkitRunnable(){
            int timeLeft;
            {
                this.timeLeft = GameManager.this.preparationTime;
            }

            public void run() {
                if (this.timeLeft <= 0) {
                    this.cancel();
                    GameManager.this.startMainGame();
                    return;
                }
                for (UUID runnerId : ManhuntX.getInstance().getTeamManager().getRunners()) {
                    Player runner = Bukkit.getPlayer((UUID)runnerId);
                    if (runner == null) continue;
                    runner.sendMessage(String.valueOf(ChatColor.AQUA) + "Preparation time: " + this.timeLeft + "s");
                }
                --this.timeLeft;
            }
        }.runTaskTimer((Plugin)ManhuntX.getInstance(), 0L, 20L);
    }

    private void startMainGame() {
        this.gameState = GameState.RUNNING;
        this.gameTimer = new BukkitRunnable(){

            public void run() {
                ++GameManager.this.gameTime;
                if (GameManager.this.challengeType == ChallengeType.SURVIVE_TIME && GameManager.this.gameTime >= GameManager.this.survivalTime) {
                    GameManager.this.endGameWithSurvivalWin();
                }
            }
        };
        this.gameTimer.runTaskTimer((Plugin)ManhuntX.getInstance(), 0L, 20L);
    }

    public void endGameWithRunnerWin(String reason) {
        if (this.gameState != GameState.RUNNING) {
            return;
        }
        this.gameState = GameState.ENDED;
        TeamManager teamManager = ManhuntX.getInstance().getTeamManager();
        for (UUID runnerId : teamManager.getRunners()) {
            Player runner = Bukkit.getPlayer((UUID)runnerId);
            if (runner == null) continue;
            runner.sendTitle(String.valueOf(ChatColor.GREEN) + "Won", String.valueOf(ChatColor.GREEN) + reason);
        }
        for (UUID hunterId : teamManager.getHunters()) {
            Player hunter = Bukkit.getPlayer((UUID)hunterId);
            if (hunter == null) continue;
            hunter.sendTitle(String.valueOf(ChatColor.RED) + "Lose", String.valueOf(ChatColor.RED) + reason);
        }
        if (this.gameTimer != null) {
            this.gameTimer.cancel();
        }
    }

    public void endGameWithHunterWin(String reason) {
        if (this.gameState != GameState.RUNNING) {
            return;
        }
        this.gameState = GameState.ENDED;
        TeamManager teamManager = ManhuntX.getInstance().getTeamManager();
        for (UUID hunterId : teamManager.getHunters()) {
            Player hunter = Bukkit.getPlayer((UUID)hunterId);
            if (hunter == null) continue;
            hunter.sendTitle(String.valueOf(ChatColor.GREEN) + "Won", String.valueOf(ChatColor.GREEN) + reason);
        }
        for (UUID runnerId : teamManager.getRunners()) {
            Player runner = Bukkit.getPlayer((UUID)runnerId);
            if (runner == null) continue;
            runner.sendTitle(String.valueOf(ChatColor.RED) + "Lose", String.valueOf(ChatColor.RED) + reason);
        }
        if (this.gameTimer != null) {
            this.gameTimer.cancel();
        }
    }

    private void endGameWithSurvivalWin() {
        String reason = "Survived " + this.survivalTime / 60 + " minutes";
        this.endGameWithRunnerWin(reason);
    }

    private String getChallengeStartMessage() {
        switch (this.challengeType) {
            case KILL_ENDER_DRAGON: {
                return "Win by killing the Ender Dragon";
            }
            case SURVIVE_TIME: {
                return "Win by surviving " + this.survivalTime / 60 + " minutes";
            }
        }
        return "Win the game";
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState gameState) {
        this.gameState = gameState;
    }

    public ChallengeType getChallengeType() {
        return this.challengeType;
    }

    public void setChallengeType(ChallengeType challengeType) {
        this.challengeType = challengeType;
    }

    public int getSurvivalTime() {
        return this.survivalTime;
    }

    public void setSurvivalTime(int survivalTime) {
        this.survivalTime = survivalTime;
    }

    public int getPreparationTime() {
        return this.preparationTime;
    }

    public void setPreparationTime(int preparationTime) {
        this.preparationTime = preparationTime;
    }

    public int getGameTime() {
        return this.gameTime;
    }
}

