/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.manhuntX.listeners;

import de.scholle.manhuntX.ManhuntX;
import de.scholle.manhuntX.managers.ConfigManager;
import de.scholle.manhuntX.managers.GUIManager;
import de.scholle.manhuntX.managers.GameManager;
import de.scholle.manhuntX.util.ChallengeType;
import de.scholle.manhuntX.util.MessageFormatter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class InventoryListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        String title = event.getView().getTitle();
        if (title.equals("ManhuntX Config")) {
            event.setCancelled(true);
            this.handleConfigGUI(event, player);
        } else if (title.equals("Select Preparation Time")) {
            event.setCancelled(true);
            this.handleTimeSelectionGUI(event, player);
        } else if (title.equals("Glowing Settings")) {
            event.setCancelled(true);
            this.handleGlowSettingsGUI(event, player);
        } else if (title.equals("Select Glowing Time")) {
            event.setCancelled(true);
            this.handleGlowTimeSelectionGUI(event, player);
        } else if (title.equals("Select Glowing Pause")) {
            event.setCancelled(true);
            this.handleGlowPauseSelectionGUI(event, player);
        }
    }

    private void handleConfigGUI(InventoryClickEvent event, Player player) {
        int slot = event.getSlot();
        GameManager gameManager = ManhuntX.getInstance().getGameManager();
        ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
        GUIManager guiManager = new GUIManager();
        switch (slot) {
            case 10: 
            case 19: {
                ChallengeType currentType = gameManager.getChallengeType();
                ChallengeType newType = currentType == ChallengeType.KILL_ENDER_DRAGON ? ChallengeType.SURVIVE_TIME : ChallengeType.KILL_ENDER_DRAGON;
                gameManager.setChallengeType(newType);
                configManager.setChallengeType(newType);
                player.openInventory(guiManager.createConfigGUI());
                break;
            }
            case 12: 
            case 21: {
                player.openInventory(guiManager.createTimeSelectionGUI());
                break;
            }
            case 13: {
                boolean currentRandomRoles = configManager.isRandomRolesEnabled();
                configManager.setRandomRoles(!currentRandomRoles);
                player.openInventory(guiManager.createConfigGUI());
                break;
            }
            case 14: {
                player.openInventory(guiManager.createGlowSettingsGUI());
                break;
            }
            case 23: {
                boolean currentGlow = configManager.isGlowEnabled();
                configManager.setGlowEnabled(!currentGlow);
                player.openInventory(guiManager.createConfigGUI());
                break;
            }
            case 22: {
                int currentRunners = configManager.getRandomRunners();
                int newRunners = currentRunners >= 4 ? 1 : currentRunners + 1;
                configManager.setRandomRunners(newRunners);
                player.openInventory(guiManager.createConfigGUI());
                break;
            }
            case 26: {
                player.closeInventory();
                player.sendMessage(MessageFormatter.formatMessage("Configuration saved!", "green"));
            }
        }
    }

    private void handleTimeSelectionGUI(InventoryClickEvent event, Player player) {
        int slot = event.getSlot();
        int[] timeSlots = new int[]{11, 12, 13, 14, 15, 16};
        int[] times = new int[]{0, 5, 10, 15, 30, 60};
        for (int i = 0; i < timeSlots.length; ++i) {
            if (slot != timeSlots[i]) continue;
            ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
            GameManager gameManager = ManhuntX.getInstance().getGameManager();
            configManager.setPreparationTime(times[i]);
            gameManager.setPreparationTime(times[i]);
            player.closeInventory();
            player.sendMessage(MessageFormatter.formatMessage("Preparation time set to " + times[i] + " seconds", "green"));
            break;
        }
    }

    private void handleGlowSettingsGUI(InventoryClickEvent event, Player player) {
        int slot = event.getSlot();
        ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
        GUIManager guiManager = new GUIManager();
        switch (slot) {
            case 10: 
            case 19: {
                boolean currentRunnerGlow = configManager.isRunnerGlowEnabled();
                configManager.setRunnerGlow(!currentRunnerGlow);
                player.openInventory(guiManager.createGlowSettingsGUI());
                break;
            }
            case 12: 
            case 21: {
                boolean currentHunterGlow = configManager.isHunterGlowEnabled();
                configManager.setHunterGlow(!currentHunterGlow);
                player.openInventory(guiManager.createGlowSettingsGUI());
                break;
            }
            case 14: {
                player.openInventory(guiManager.createGlowTimeSelectionGUI());
                break;
            }
            case 16: {
                player.openInventory(guiManager.createGlowPauseSelectionGUI());
                break;
            }
            case 22: {
                player.openInventory(guiManager.createConfigGUI());
            }
        }
    }

    private void handleGlowTimeSelectionGUI(InventoryClickEvent event, Player player) {
        int slot = event.getSlot();
        int[] timeSlots = new int[]{11, 12, 13, 14, 15, 16};
        int[] times = new int[]{0, 5, 10, 15, 30, 60};
        for (int i = 0; i < timeSlots.length; ++i) {
            if (slot != timeSlots[i]) continue;
            ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
            configManager.setGlowTime(times[i]);
            player.closeInventory();
            player.sendMessage(MessageFormatter.formatMessage("Glowing time set to " + this.formatSeconds(times[i]), "green"));
            break;
        }
        if (slot == 22) {
            GUIManager guiManager = new GUIManager();
            player.openInventory(guiManager.createGlowSettingsGUI());
        }
    }

    private void handleGlowPauseSelectionGUI(InventoryClickEvent event, Player player) {
        int slot = event.getSlot();
        int[] pauseSlots = new int[]{11, 12, 13, 14, 15};
        int[] pauses = new int[]{30, 60, 180, 300, 600};
        for (int i = 0; i < pauseSlots.length; ++i) {
            if (slot != pauseSlots[i]) continue;
            ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
            configManager.setGlowPause(pauses[i]);
            player.closeInventory();
            player.sendMessage(MessageFormatter.formatMessage("Glowing pause set to " + this.formatSeconds(pauses[i]), "green"));
            break;
        }
        if (slot == 22) {
            GUIManager guiManager = new GUIManager();
            player.openInventory(guiManager.createGlowSettingsGUI());
        }
    }

    private String formatSeconds(int seconds) {
        if (seconds < 60) {
            return seconds + "s";
        }
        int minutes = seconds / 60;
        return minutes + "min";
    }
}

