/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.manhuntX.managers;

import de.scholle.manhuntX.ManhuntX;
import de.scholle.manhuntX.managers.ConfigManager;
import de.scholle.manhuntX.managers.GameManager;
import de.scholle.manhuntX.util.ChallengeType;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIManager {
    public Inventory createConfigGUI() {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"ManhuntX Config");
        ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
        GameManager gameManager = ManhuntX.getInstance().getGameManager();
        ItemStack challengeItem = new ItemStack(Material.ENDER_EYE);
        ItemMeta challengeMeta = challengeItem.getItemMeta();
        challengeMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Challenge Type");
        challengeMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Current: " + gameManager.getChallengeType().getDisplayName(), String.valueOf(ChatColor.GRAY) + "Click to toggle between modes"));
        challengeItem.setItemMeta(challengeMeta);
        inv.setItem(10, challengeItem);
        ItemStack challengeStatus = new ItemStack(gameManager.getChallengeType() == ChallengeType.KILL_ENDER_DRAGON ? Material.LIME_DYE : Material.GRAY_DYE);
        ItemMeta statusMeta = challengeStatus.getItemMeta();
        statusMeta.setDisplayName(gameManager.getChallengeType() == ChallengeType.KILL_ENDER_DRAGON ? String.valueOf(ChatColor.GREEN) + "Kill Ender Dragon" : String.valueOf(ChatColor.RED) + "Survive Time");
        challengeStatus.setItemMeta(statusMeta);
        inv.setItem(19, challengeStatus);
        ItemStack prepTimeItem = new ItemStack(Material.CLOCK);
        ItemMeta prepMeta = prepTimeItem.getItemMeta();
        prepMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Preparation Time");
        prepMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Current: " + configManager.getPreparationTime() + "s", String.valueOf(ChatColor.GRAY) + "Click to change preparation time"));
        prepTimeItem.setItemMeta(prepMeta);
        inv.setItem(12, prepTimeItem);
        ItemStack prepTimeStatus = new ItemStack(Material.YELLOW_DYE);
        ItemMeta prepStatusMeta = prepTimeStatus.getItemMeta();
        prepStatusMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Configure Time");
        prepTimeStatus.setItemMeta(prepStatusMeta);
        inv.setItem(21, prepTimeStatus);
        ItemStack randomRolesItem = new ItemStack(Material.SPLASH_POTION);
        ItemMeta randomRolesMeta = randomRolesItem.getItemMeta();
        boolean randomRoles = configManager.isRandomRolesEnabled();
        randomRolesMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Random Roles");
        randomRolesMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Current: " + (randomRoles ? "Enabled" : "Disabled"), String.valueOf(ChatColor.GRAY) + "Click to toggle random roles"));
        randomRolesItem.setItemMeta(randomRolesMeta);
        inv.setItem(13, randomRolesItem);
        ItemStack randomRunnersItem = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta runnersMeta = randomRunnersItem.getItemMeta();
        int runners = configManager.getRandomRunners();
        runnersMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Random Runners");
        runnersMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Current: " + runners, String.valueOf(ChatColor.GRAY) + "Click to change number of runners"));
        randomRunnersItem.setItemMeta(runnersMeta);
        inv.setItem(22, randomRunnersItem);
        ItemStack glowItem = new ItemStack(Material.SPECTRAL_ARROW);
        ItemMeta glowMeta = glowItem.getItemMeta();
        boolean glowEnabled = configManager.isGlowEnabled();
        glowMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Glowing Settings");
        glowMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Current: " + (glowEnabled ? "Enabled" : "Disabled"), String.valueOf(ChatColor.GRAY) + "Click to configure glowing settings"));
        glowItem.setItemMeta(glowMeta);
        inv.setItem(14, glowItem);
        ItemStack glowStatus = new ItemStack(glowEnabled ? Material.LIME_DYE : Material.GRAY_DYE);
        ItemMeta glowStatusMeta = glowStatus.getItemMeta();
        glowStatusMeta.setDisplayName(glowEnabled ? String.valueOf(ChatColor.GREEN) + "Glowing Enabled" : String.valueOf(ChatColor.RED) + "Glowing Disabled");
        glowStatus.setItemMeta(glowStatusMeta);
        inv.setItem(23, glowStatus);
        ItemStack saveItem = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta saveMeta = saveItem.getItemMeta();
        saveMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Save Configuration");
        saveItem.setItemMeta(saveMeta);
        inv.setItem(26, saveItem);
        return inv;
    }

    public Inventory createTimeSelectionGUI() {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"Select Preparation Time");
        ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
        int currentTime = configManager.getPreparationTime();
        int[] times = new int[]{0, 5, 10, 15, 30, 60};
        int[] slots = new int[]{11, 12, 13, 14, 15, 16};
        for (int i = 0; i < times.length; ++i) {
            ItemStack timeItem = new ItemStack(Material.GRAY_DYE);
            ItemMeta meta = timeItem.getItemMeta();
            if (times[i] == currentTime) {
                timeItem.setType(Material.LIME_DYE);
                meta.setDisplayName(String.valueOf(ChatColor.GREEN) + String.valueOf(times[i]) + " seconds");
            } else {
                meta.setDisplayName(String.valueOf(ChatColor.WHITE) + String.valueOf(times[i]) + " seconds");
            }
            timeItem.setItemMeta(meta);
            inv.setItem(slots[i], timeItem);
        }
        return inv;
    }

    public Inventory createGlowSettingsGUI() {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"Glowing Settings");
        ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
        ItemStack runnerGlowItem = new ItemStack(Material.LEATHER_BOOTS);
        ItemMeta runnerMeta = runnerGlowItem.getItemMeta();
        boolean runnerGlow = configManager.isRunnerGlowEnabled();
        runnerMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Runner Glowing");
        runnerMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Current: " + (runnerGlow ? "Enabled" : "Disabled"), String.valueOf(ChatColor.GRAY) + "Click to toggle runner glowing"));
        runnerGlowItem.setItemMeta(runnerMeta);
        inv.setItem(10, runnerGlowItem);
        ItemStack runnerStatus = new ItemStack(runnerGlow ? Material.LIME_DYE : Material.GRAY_DYE);
        ItemMeta runnerStatusMeta = runnerStatus.getItemMeta();
        runnerStatusMeta.setDisplayName(runnerGlow ? String.valueOf(ChatColor.GREEN) + "Runner Glow Enabled" : String.valueOf(ChatColor.RED) + "Runner Glow Disabled");
        runnerStatus.setItemMeta(runnerStatusMeta);
        inv.setItem(19, runnerStatus);
        ItemStack hunterGlowItem = new ItemStack(Material.BOW);
        ItemMeta hunterMeta = hunterGlowItem.getItemMeta();
        boolean hunterGlow = configManager.isHunterGlowEnabled();
        hunterMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Hunter Glowing");
        hunterMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Current: " + (hunterGlow ? "Enabled" : "Disabled"), String.valueOf(ChatColor.GRAY) + "Click to toggle hunter glowing"));
        hunterGlowItem.setItemMeta(hunterMeta);
        inv.setItem(12, hunterGlowItem);
        ItemStack hunterStatus = new ItemStack(hunterGlow ? Material.LIME_DYE : Material.GRAY_DYE);
        ItemMeta hunterStatusMeta = hunterStatus.getItemMeta();
        hunterStatusMeta.setDisplayName(hunterGlow ? String.valueOf(ChatColor.GREEN) + "Hunter Glow Enabled" : String.valueOf(ChatColor.RED) + "Hunter Glow Disabled");
        hunterStatus.setItemMeta(hunterStatusMeta);
        inv.setItem(21, hunterStatus);
        ItemStack glowTimeItem = new ItemStack(Material.CLOCK);
        ItemMeta glowTimeMeta = glowTimeItem.getItemMeta();
        int currentGlowTime = configManager.getGlowTime();
        glowTimeMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Glowing Time");
        glowTimeMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Current: " + this.formatSeconds(currentGlowTime), String.valueOf(ChatColor.GRAY) + "Click to change glowing duration"));
        glowTimeItem.setItemMeta(glowTimeMeta);
        inv.setItem(14, glowTimeItem);
        ItemStack glowPauseItem = new ItemStack(Material.REPEATER);
        ItemMeta glowPauseMeta = glowPauseItem.getItemMeta();
        int currentGlowPause = configManager.getGlowPause();
        glowPauseMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Glowing Pause");
        glowPauseMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Current: " + this.formatSeconds(currentGlowPause), String.valueOf(ChatColor.GRAY) + "Click to change pause duration"));
        glowPauseItem.setItemMeta(glowPauseMeta);
        inv.setItem(16, glowPauseItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Back to Main Menu");
        backItem.setItemMeta(backMeta);
        inv.setItem(22, backItem);
        return inv;
    }

    public Inventory createGlowTimeSelectionGUI() {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"Select Glowing Time");
        ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
        int currentTime = configManager.getGlowTime();
        List<Integer> glowTimes = configManager.getGlowTimes();
        int[] slots = new int[]{11, 12, 13, 14, 15, 16};
        for (int i = 0; i < glowTimes.size() && i < slots.length; ++i) {
            ItemStack timeItem = new ItemStack(Material.GRAY_DYE);
            ItemMeta meta = timeItem.getItemMeta();
            if (glowTimes.get(i) == currentTime) {
                timeItem.setType(Material.LIME_DYE);
                meta.setDisplayName(String.valueOf(ChatColor.GREEN) + this.formatSeconds(glowTimes.get(i)));
            } else {
                meta.setDisplayName(String.valueOf(ChatColor.WHITE) + this.formatSeconds(glowTimes.get(i)));
            }
            timeItem.setItemMeta(meta);
            inv.setItem(slots[i], timeItem);
        }
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Back to Glowing Settings");
        backItem.setItemMeta(backMeta);
        inv.setItem(22, backItem);
        return inv;
    }

    public Inventory createGlowPauseSelectionGUI() {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"Select Glowing Pause");
        ConfigManager configManager = ManhuntX.getInstance().getConfigManager();
        int currentPause = configManager.getGlowPause();
        List<Integer> glowPauses = configManager.getGlowPauses();
        int[] slots = new int[]{11, 12, 13, 14, 15};
        for (int i = 0; i < glowPauses.size() && i < slots.length; ++i) {
            ItemStack pauseItem = new ItemStack(Material.GRAY_DYE);
            ItemMeta meta = pauseItem.getItemMeta();
            if (glowPauses.get(i) == currentPause) {
                pauseItem.setType(Material.LIME_DYE);
                meta.setDisplayName(String.valueOf(ChatColor.GREEN) + this.formatSeconds(glowPauses.get(i)));
            } else {
                meta.setDisplayName(String.valueOf(ChatColor.WHITE) + this.formatSeconds(glowPauses.get(i)));
            }
            pauseItem.setItemMeta(meta);
            inv.setItem(slots[i], pauseItem);
        }
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Back to Glowing Settings");
        backItem.setItemMeta(backMeta);
        inv.setItem(22, backItem);
        return inv;
    }

    private String formatSeconds(int seconds) {
        if (seconds < 60) {
            return seconds + "s";
        }
        int minutes = seconds / 60;
        return minutes + "min";
    }
}

