/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.manhuntX.managers;

import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TeamManager {
    private HashSet<UUID> hunters = new HashSet();
    private HashSet<UUID> runners = new HashSet();

    public boolean setHunter(Player player) {
        if (this.runners.contains(player.getUniqueId())) {
            this.runners.remove(player.getUniqueId());
        }
        return this.hunters.add(player.getUniqueId());
    }

    public boolean setRunner(Player player) {
        if (this.hunters.contains(player.getUniqueId())) {
            this.hunters.remove(player.getUniqueId());
        }
        return this.runners.add(player.getUniqueId());
    }

    public boolean removePlayer(Player player) {
        boolean removed = false;
        if (this.hunters.contains(player.getUniqueId())) {
            this.hunters.remove(player.getUniqueId());
            removed = true;
        }
        if (this.runners.contains(player.getUniqueId())) {
            this.runners.remove(player.getUniqueId());
            removed = true;
        }
        return removed;
    }

    public boolean isHunter(Player player) {
        return this.hunters.contains(player.getUniqueId());
    }

    public boolean isRunner(Player player) {
        return this.runners.contains(player.getUniqueId());
    }

    public HashSet<UUID> getHunters() {
        return new HashSet<UUID>(this.hunters);
    }

    public HashSet<UUID> getRunners() {
        return new HashSet<UUID>(this.runners);
    }

    public void clearTeams() {
        this.hunters.clear();
        this.runners.clear();
    }

    public Player getFirstRunner() {
        if (this.runners.isEmpty()) {
            return null;
        }
        UUID firstRunnerId = this.runners.iterator().next();
        return Bukkit.getPlayer((UUID)firstRunnerId);
    }

    public Player getRunnerByName(String name) {
        for (UUID runnerId : this.runners) {
            Player runner = Bukkit.getPlayer((UUID)runnerId);
            if (runner == null || !runner.getName().equalsIgnoreCase(name)) continue;
            return runner;
        }
        return null;
    }
}

