/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.manhuntX.managers;

import de.scholle.manhuntX.ManhuntX;
import de.scholle.manhuntX.util.ChallengeType;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private FileConfiguration config;
    private String prefix;
    private List<Integer> preparationTimes = Arrays.asList(0, 5, 10, 15, 30, 60);
    private List<Integer> glowTimes = Arrays.asList(0, 5, 10, 15, 30, 60);
    private List<Integer> glowPauses = Arrays.asList(30, 60, 180, 300, 600);

    public void loadConfig() {
        ManhuntX.getInstance().saveDefaultConfig();
        this.config = ManhuntX.getInstance().getConfig();
        this.prefix = this.config.getString("prefix", "ManhuntX");
        this.preparationTimes = this.config.getIntegerList("preparation-times");
        if (this.preparationTimes.isEmpty()) {
            this.preparationTimes = Arrays.asList(0, 5, 10, 15, 30, 60);
        }
        this.glowTimes = this.config.getIntegerList("glow.times");
        if (this.glowTimes.isEmpty()) {
            this.glowTimes = Arrays.asList(0, 5, 10, 15, 30, 60);
        }
        this.glowPauses = this.config.getIntegerList("glow.pauses");
        if (this.glowPauses.isEmpty()) {
            this.glowPauses = Arrays.asList(30, 60, 180, 300, 600);
        }
    }

    public void saveConfig() {
        ManhuntX.getInstance().saveConfig();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<Integer> getPreparationTimes() {
        return this.preparationTimes;
    }

    public void setPreparationTime(int time) {
        this.config.set("preparation-time", (Object)time);
        this.saveConfig();
    }

    public int getPreparationTime() {
        return this.config.getInt("preparation-time", 0);
    }

    public void setChallengeType(ChallengeType type) {
        this.config.set("challenge-type", (Object)type.toString());
        this.saveConfig();
    }

    public ChallengeType getChallengeType() {
        String type = this.config.getString("challenge-type", "KILL_ENDER_DRAGON");
        return ChallengeType.valueOf(type);
    }

    public void setSurvivalTime(int minutes) {
        this.config.set("survival-time", (Object)(minutes * 60));
        this.saveConfig();
    }

    public void setGlowEnabled(boolean enabled) {
        this.config.set("glow.enabled", (Object)enabled);
        this.saveConfig();
    }

    public boolean isGlowEnabled() {
        return this.config.getBoolean("glow.enabled", false);
    }

    public void setRunnerGlow(boolean enabled) {
        this.config.set("glow.runner", (Object)enabled);
        this.saveConfig();
    }

    public boolean isRunnerGlowEnabled() {
        return this.config.getBoolean("glow.runner", false);
    }

    public void setHunterGlow(boolean enabled) {
        this.config.set("glow.hunter", (Object)enabled);
        this.saveConfig();
    }

    public boolean isHunterGlowEnabled() {
        return this.config.getBoolean("glow.hunter", false);
    }

    public void setGlowTime(int seconds) {
        this.config.set("glow.time", (Object)seconds);
        this.saveConfig();
    }

    public int getGlowTime() {
        return this.config.getInt("glow.time", 30);
    }

    public void setGlowPause(int seconds) {
        this.config.set("glow.pause", (Object)seconds);
        this.saveConfig();
    }

    public int getGlowPause() {
        return this.config.getInt("glow.pause", 300);
    }

    public int getSurvivalTime() {
        return this.config.getInt("survival-time", 3600);
    }

    public void setRandomRoles(boolean enabled) {
        this.config.set("random-roles", (Object)enabled);
        this.saveConfig();
    }

    public boolean isRandomRolesEnabled() {
        return this.config.getBoolean("random-roles", false);
    }

    public void setRandomRunners(int amount) {
        this.config.set("random-runners", (Object)amount);
        this.saveConfig();
    }

    public int getRandomRunners() {
        return this.config.getInt("random-runners", 1);
    }

    public List<Integer> getGlowTimes() {
        return this.glowTimes;
    }

    public List<Integer> getGlowPauses() {
        return this.glowPauses;
    }
}

