/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Reflex {
    @Deprecated
    @Nullable
    public static Class<?> getClass(@NotNull String path, @NotNull String name) {
        return Reflex.getClass(path + "." + name);
    }

    @Deprecated
    @Nullable
    public static Class<?> getInnerClass(@NotNull String path, @NotNull String name) {
        return Reflex.getClass(path + "$" + name);
    }

    @Deprecated
    @Nullable
    public static Class<?> getNMSClass(@NotNull String path, @NotNull String realName) {
        return Reflex.getNMSClass(path, realName, null);
    }

    @Deprecated
    @Nullable
    public static Class<?> getNMSClass(@NotNull String path, @NotNull String realName, @Nullable String obfName) {
        Class<?> byRealName = Reflex.getClass(path + "." + realName, false);
        if (byRealName != null) {
            return byRealName;
        }
        if (obfName != null) {
            return Reflex.getClass(path + "." + obfName, false);
        }
        return null;
    }

    @Deprecated
    private static Class<?> getClass(@NotNull String path) {
        return Reflex.getClass(path, true);
    }

    @Deprecated
    private static Class<?> getClass(@NotNull String path, boolean printError) {
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException exception) {
            if (printError) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    @NotNull
    public static Class<?> safeClass(@NotNull String path, @NotNull String name, @NotNull String altName) {
        return Reflex.findClass(path, name, altName).orElseThrow(() -> new IllegalStateException("Could not load classes: '" + name + "' and '" + altName + "' in '" + path + "'"));
    }

    @NotNull
    public static Class<?> safeClass(@NotNull String path, @NotNull String name) {
        return Reflex.findClass(path, name).orElseThrow(() -> new IllegalStateException("Could not load class: '" + name + "' in '" + path + "'"));
    }

    @NotNull
    public static Class<?> safeInnerClass(@NotNull String path, @NotNull String name) {
        return Reflex.findInnerClass(path, name).orElseThrow(() -> new IllegalStateException("Could not load inner class: '" + name + "' in '" + path + "'"));
    }

    @NotNull
    public static Class<?> safeClass(@NotNull String path) {
        return Reflex.findClass(path).orElseThrow(() -> new IllegalStateException("Could not load class: '" + path + "'"));
    }

    @NotNull
    public static Optional<Class<?>> findClass(@NotNull String path, @NotNull String name, @NotNull String altName) {
        return Reflex.findClass(path, name).or(() -> Reflex.findClass(path, altName));
    }

    @NotNull
    public static Optional<Class<?>> findClass(@NotNull String path, @NotNull String name) {
        return Reflex.findClass(path + "." + name);
    }

    @NotNull
    public static Optional<Class<?>> findInnerClass(@NotNull String path, @NotNull String name) {
        return Reflex.findClass(path + "$" + name);
    }

    @NotNull
    public static Optional<Class<?>> findClass(@NotNull String path) {
        try {
            return Optional.of(Class.forName(path));
        }
        catch (ClassNotFoundException exception) {
            return Optional.empty();
        }
    }

    public static Constructor<?> getConstructor(@NotNull Class<?> source, Class<?> ... types) {
        try {
            Constructor<?> constructor = source.getDeclaredConstructor(types);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object invokeConstructor(@NotNull Constructor<?> constructor, Object ... obj) {
        try {
            return constructor.newInstance(obj);
        }
        catch (ReflectiveOperationException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static <T> List<T> getStaticFields(@NotNull Class<?> source, @NotNull Class<T> type, boolean includeParent) {
        ArrayList<T> list = new ArrayList<T>();
        for (Field field : Reflex.getFields(source, includeParent)) {
            if (!Modifier.isStatic(field.getModifiers()) || !type.isAssignableFrom(field.getType()) || !field.trySetAccessible()) continue;
            try {
                list.add(type.cast(field.get(null)));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                exception.printStackTrace();
            }
        }
        return list;
    }

    @NotNull
    public static List<Field> getFields(@NotNull Class<?> source) {
        return Reflex.getFields(source, true);
    }

    @NotNull
    public static List<Field> getFields(@NotNull Class<?> source, boolean includeParent) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> lookupClass = source; lookupClass != null && lookupClass != Object.class; lookupClass = lookupClass.getSuperclass()) {
            if (!result.isEmpty()) {
                result.addAll(0, Arrays.asList(lookupClass.getDeclaredFields()));
            } else {
                Collections.addAll(result, lookupClass.getDeclaredFields());
            }
            if (!includeParent) break;
        }
        return result;
    }

    public static Field getField(@NotNull Class<?> source, @NotNull String name) {
        try {
            return source.getDeclaredField(name);
        }
        catch (NoSuchFieldException exception) {
            Class<?> superClass = source.getSuperclass();
            return superClass == null ? null : Reflex.getField(superClass, name);
        }
    }

    public static Object getFieldValue(@NotNull Object source, @NotNull String realName, @NotNull String obfName) {
        Object byName = Reflex.getFieldValue(source, realName);
        return byName == null ? Reflex.getFieldValue(source, obfName) : byName;
    }

    public static Object getFieldValue(@NotNull Object source, @NotNull String name) {
        try {
            Class<?> clazz = source instanceof Class ? (Class<?>)source : source.getClass();
            Field field = Reflex.getField(clazz, name);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            return field.get(source);
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean setFieldValue(@NotNull Object source, @NotNull String name, @Nullable Object value) {
        try {
            boolean isStatic = source instanceof Class;
            Class<?> clazz = isStatic ? (Class<?>)source : source.getClass();
            Field field = Reflex.getField(clazz, name);
            if (field == null) {
                return false;
            }
            field.setAccessible(true);
            field.set(isStatic ? null : source, value);
            return true;
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public static Method getMethod(@NotNull Class<?> source, @NotNull String realName, @NotNull String obfName, Class<?> ... params) {
        Method byName = Reflex.getMethod(source, realName, params);
        return byName == null ? Reflex.getMethod(source, obfName, params) : byName;
    }

    @Deprecated
    public static Method getMethod(@NotNull Class<?> source, @NotNull String name, Class<?> ... params) {
        try {
            return source.getDeclaredMethod(name, params);
        }
        catch (NoSuchMethodException exception) {
            Class<?> superClass = source.getSuperclass();
            return superClass == null ? null : Reflex.getMethod(superClass, name, new Class[0]);
        }
    }

    @NotNull
    public static Method safeMethod(@NotNull Class<?> source, @NotNull String name, @NotNull String altName, Class<?> ... params) {
        return Reflex.findMethod(source, name, altName, params).orElseThrow(() -> new IllegalStateException("Could not find methods: '" + name + "' and '" + altName + "' in '" + source.getName() + "'"));
    }

    @NotNull
    public static Method safeMethod(@NotNull Class<?> source, @NotNull String name, Class<?> ... params) {
        return Reflex.findMethod(source, name, params).orElseThrow(() -> new IllegalStateException("Could not find method: '" + name + "' in '" + source.getName() + "'"));
    }

    @NotNull
    public static Optional<Method> findMethod(@NotNull Class<?> source, @NotNull String name, @NotNull String altName, Class<?> ... params) {
        return Reflex.findMethod(source, name, params).or(() -> Reflex.findMethod(source, altName, params));
    }

    @NotNull
    public static Optional<Method> findMethod(@NotNull Class<?> source, @NotNull String name, Class<?> ... params) {
        try {
            return Optional.of(source.getDeclaredMethod(name, params));
        }
        catch (NoSuchMethodException exception) {
            Class<?> superClass = source.getSuperclass();
            return superClass == null ? Optional.empty() : Reflex.findMethod(superClass, name, new Class[0]);
        }
    }

    @Nullable
    public static Object invokeMethod(@NotNull Method method, @Nullable Object by, Object ... param) {
        try {
            method.setAccessible(true);
            return method.invoke(by, param);
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

