/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.Engine;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class EntityUtil {
    public static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HAND, EquipmentSlot.OFF_HAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public static int nextEntityId() {
        return Engine.software().nextEntityId();
    }

    public static void setCustomName(@NotNull Entity entity, @NotNull String name) {
        Engine.software().setCustomName(entity, NightMessage.parse(name));
    }

    @NotNull
    public static String getNameSerialized(@NotNull Entity entity) {
        String customName = Engine.software().getEntityName(entity);
        if (customName != null) {
            return customName;
        }
        return LangUtil.getSerializedName(entity.getType());
    }

    @Deprecated
    public static double getAttribute(@NotNull LivingEntity entity, @NotNull Attribute attribute) {
        return EntityUtil.getAttributeValue(entity, attribute);
    }

    @Deprecated
    public static double getAttributeBase(@NotNull LivingEntity entity, @NotNull Attribute attribute) {
        return EntityUtil.getAttributeBaseValue(entity, attribute);
    }

    public static double getAttributeValue(@NotNull LivingEntity entity, @NotNull Attribute attribute) {
        AttributeInstance instance = entity.getAttribute(attribute);
        return instance == null ? 0.0 : instance.getValue();
    }

    public static double getAttributeBaseValue(@NotNull LivingEntity entity, @NotNull Attribute attribute) {
        AttributeInstance instance = entity.getAttribute(attribute);
        return instance == null ? 0.0 : instance.getBaseValue();
    }

    public static void modifyAttribute(@NotNull LivingEntity entity, @NotNull Attribute attribute, @NotNull Consumer<AttributeInstance> consumer) {
        AttributeInstance instance = entity.getAttribute(attribute);
        if (instance == null) {
            return;
        }
        consumer.accept(instance);
    }

    public static double getMaxHealth(@NotNull LivingEntity entity) {
        return EntityUtil.getAttributeValue(entity, Attribute.MAX_HEALTH);
    }

    public static void addHealth(@NotNull LivingEntity entity, double amount) {
        EntityUtil.setHealth(entity, entity.getHealth() + Math.abs(amount));
    }

    public static void removeHealth(@NotNull LivingEntity entity, double amount) {
        EntityUtil.setHealth(entity, entity.getHealth() - Math.abs(amount));
    }

    public static void setHealth(@NotNull LivingEntity entity, double value) {
        double maxHealth = EntityUtil.getMaxHealth(entity);
        double health = Math.clamp(value, 0.0, maxHealth);
        entity.setHealth(health);
    }

    @Nullable
    public static ItemStack getItemInSlot(@NotNull LivingEntity entity, @NotNull EquipmentSlot slot) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getInventory().getItem(slot);
        }
        EntityEquipment equipment = entity.getEquipment();
        return equipment == null ? null : equipment.getItem(slot);
    }

    @NotNull
    public static Map<EquipmentSlot, ItemStack> getEquippedItems(@NotNull LivingEntity entity) {
        return EntityUtil.getEquippedItems(entity, EQUIPMENT_SLOTS);
    }

    @NotNull
    public static Map<EquipmentSlot, ItemStack> getEquippedItems(@NotNull LivingEntity entity, EquipmentSlot ... slots) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment == null) {
            return Collections.emptyMap();
        }
        HashMap<EquipmentSlot, ItemStack> map = new HashMap<EquipmentSlot, ItemStack>();
        for (EquipmentSlot slot : slots) {
            if (slot.name().equalsIgnoreCase("BODY")) continue;
            map.put(slot, equipment.getItem(slot));
        }
        return map;
    }

    @NotNull
    public static Map<EquipmentSlot, ItemStack> getEquippedHands(@NotNull LivingEntity entity) {
        return EntityUtil.getEquippedItems(entity, EquipmentSlot.HAND, EquipmentSlot.OFF_HAND);
    }

    @NotNull
    public static Map<EquipmentSlot, ItemStack> getEquippedArmor(@NotNull LivingEntity entity) {
        return EntityUtil.getEquippedItems(entity, EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD);
    }

    @Nullable
    public static BlockFace getDirection(@NotNull Entity entity) {
        float yaw = Math.round(entity.getLocation().getYaw() / 90.0f);
        if (yaw == -4.0f || yaw == 0.0f || yaw == 4.0f) {
            return BlockFace.SOUTH;
        }
        if (yaw == -1.0f || yaw == 3.0f) {
            return BlockFace.EAST;
        }
        if (yaw == -2.0f || yaw == 2.0f) {
            return BlockFace.NORTH;
        }
        if (yaw == -3.0f || yaw == 1.0f) {
            return BlockFace.WEST;
        }
        return null;
    }
}

