/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.core.CoreConfig;
import su.nightexpress.nightcore.util.ArrayUtil;
import su.nightexpress.nightcore.util.Numbers;
import su.nightexpress.nightcore.util.number.CompactNumber;
import su.nightexpress.nightcore.util.number.NumberShortcut;
import su.nightexpress.nightcore.util.wrapper.UniFormatter;

public class NumberUtil {
    private static final TreeMap<Integer, String> ROMAN_MAP = new TreeMap();

    @NotNull
    public static UniFormatter getNumberFormat() {
        return CoreConfig.NUMBER_FORMAT.get();
    }

    @NotNull
    public static List<NumberShortcut> getNumberShortcuts() {
        return CoreConfig.NUMBER_SHORTCUT_LIST.get().values().stream().sorted(Comparator.comparing(NumberShortcut::getMagnitude)).toList();
    }

    public static double round(double value) {
        return NumberUtil.round(value, 2);
    }

    public static double round(double value, int scale) {
        return new BigDecimal(value).setScale(scale, NumberUtil.getNumberFormat().getRounding()).doubleValue();
    }

    @NotNull
    public static String format(double value) {
        return NumberUtil.getNumberFormat().format(value);
    }

    @Deprecated
    @NotNull
    public static String compact(double value) {
        return NumberUtil.formatCompact(value);
    }

    @NotNull
    public static String formatCompact(double value) {
        return NumberUtil.asCompact(value).format();
    }

    @NotNull
    public static CompactNumber asCompact(double value) {
        int index;
        boolean negative = value < 0.0;
        value = Math.abs(value);
        List<NumberShortcut> shortcuts = NumberUtil.getNumberShortcuts();
        int step = CoreConfig.NUMBER_SHORTCUT_STEP.get();
        int maxIndex = shortcuts.size() - 1;
        for (index = -1; value / (double)step >= 1.0 && index < maxIndex; ++index) {
            value /= (double)step;
        }
        double result = negative ? -value : value;
        NumberShortcut shortcut = index < 0 ? null : shortcuts.get(index);
        return new CompactNumber(result, shortcut);
    }

    public static double getDoubleCompact(@NotNull String input) {
        return NumberUtil.parseCompact(input).orElse(0.0);
    }

    public static double getDoubleCompactAbs(@NotNull String input) {
        return Math.abs(NumberUtil.getDoubleCompact(input));
    }

    @NotNull
    public static Optional<Double> parseDecimalCompact(@NotNull String input) {
        return NumberUtil.parseCompact(input);
    }

    public static double getIntCompact(@NotNull String input) {
        return NumberUtil.parseIntCompact(input).orElse(0).intValue();
    }

    public static double getIntCompactAbs(@NotNull String input) {
        return Math.abs(NumberUtil.getIntCompact(input));
    }

    @NotNull
    public static Optional<Integer> parseIntCompact(@NotNull String input) {
        return NumberUtil.parseCompact(input).map(Double::intValue);
    }

    @NotNull
    public static Optional<Double> parseCompact(@NotNull String input) {
        Optional<Double> optional;
        input = input.toLowerCase();
        double multiplier = 1.0;
        List<NumberShortcut> shortcuts = NumberUtil.getNumberShortcuts();
        for (NumberShortcut shortcut : shortcuts) {
            int index = input.indexOf(shortcut.getSymbol());
            if (index < 0) continue;
            input = input.substring(0, index);
            multiplier = shortcut.getMultiplier();
            break;
        }
        if ((optional = NumberUtil.parseDouble(input)).isEmpty()) {
            return Optional.empty();
        }
        double value = optional.get() * multiplier;
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    @NotNull
    public static String toRoman(int number) {
        if (number <= 0) {
            return String.valueOf(number);
        }
        int key = ROMAN_MAP.floorKey(number);
        if (number == key) {
            return ROMAN_MAP.get(number);
        }
        return ROMAN_MAP.get(key) + NumberUtil.toRoman(number - key);
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int[] splitIntoParts(int whole, int parts) {
        int[] arr = new int[parts];
        int remain = whole;
        int partsLeft = parts;
        int i = 0;
        while (partsLeft > 0) {
            int size;
            arr[i] = size = (remain + partsLeft - 1) / partsLeft;
            remain -= size;
            --partsLeft;
            ++i;
        }
        return arr;
    }

    @Deprecated
    public static double getDouble(@NotNull String input) {
        return NumberUtil.getDoubleAbs(input);
    }

    @Deprecated
    public static double getDouble(@NotNull String input, double defaultValue) {
        return NumberUtil.getDoubleAbs(input, defaultValue);
    }

    @Deprecated
    public static double getDoubleAbs(@NotNull String input) {
        return NumberUtil.getDoubleAbs(input, 0.0);
    }

    @Deprecated
    public static double getDoubleAbs(@NotNull String input, double defaultValue) {
        return Math.abs(NumberUtil.getAnyDouble(input, defaultValue));
    }

    @Deprecated
    public static double getAnyDouble(@NotNull String input, double defaultValue) {
        return NumberUtil.parseDouble(input).orElse(defaultValue);
    }

    @Deprecated
    public static float getFloatAbs(@NotNull String input) {
        return NumberUtil.getFloatAbs(input, 0.0f);
    }

    @Deprecated
    public static float getFloatAbs(@NotNull String input, float defaultValue) {
        return Math.abs(NumberUtil.getFloat(input, defaultValue));
    }

    @Deprecated
    public static float getFloat(@NotNull String input, float defaultValue) {
        return NumberUtil.parseFloat(input).orElse(Float.valueOf(defaultValue)).floatValue();
    }

    @Deprecated
    public static int getInteger(@NotNull String input) {
        return NumberUtil.getIntegerAbs(input);
    }

    @Deprecated
    public static int getInteger(@NotNull String input, int defaultValue) {
        return NumberUtil.getIntegerAbs(input, defaultValue);
    }

    @Deprecated
    public static int getIntegerAbs(@NotNull String input) {
        return NumberUtil.getIntegerAbs(input, 0);
    }

    @Deprecated
    public static int getIntegerAbs(@NotNull String input, int defaultValue) {
        return Math.abs(NumberUtil.getAnyInteger(input, defaultValue));
    }

    @Deprecated
    public static int getAnyInteger(@NotNull String input, int defaultValue) {
        return NumberUtil.parseInteger(input).orElse(defaultValue);
    }

    @Deprecated
    @NotNull
    public static Optional<Integer> parseInteger(@NotNull String input) {
        return Numbers.parseInteger(input);
    }

    @Deprecated
    @NotNull
    public static Optional<Double> parseDouble(@NotNull String input) {
        return Numbers.parseDouble(input);
    }

    @Deprecated
    @NotNull
    public static Optional<Float> parseFloat(@NotNull String input) {
        return Numbers.parseFloat(input);
    }

    @Deprecated
    public static int[] getIntArray(@NotNull String string) {
        return ArrayUtil.parseIntArray(string);
    }

    static {
        ROMAN_MAP.put(1000, "M");
        ROMAN_MAP.put(900, "CM");
        ROMAN_MAP.put(500, "D");
        ROMAN_MAP.put(400, "CD");
        ROMAN_MAP.put(100, "C");
        ROMAN_MAP.put(90, "XC");
        ROMAN_MAP.put(50, "L");
        ROMAN_MAP.put(40, "XL");
        ROMAN_MAP.put(10, "X");
        ROMAN_MAP.put(9, "IX");
        ROMAN_MAP.put(5, "V");
        ROMAN_MAP.put(4, "IV");
        ROMAN_MAP.put(1, "I");
    }
}

