/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.geysermc.floodgate.api.FloodgateApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.wrap.NightProfile;
import su.nightexpress.nightcore.integration.permission.PermissionBridge;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Placeholders;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.bridge.Software;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.profile.CachedProfile;
import su.nightexpress.nightcore.util.profile.PlayerProfiles;
import su.nightexpress.nightcore.util.text.TextRoot;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class Players {
    @Deprecated
    public static final String TEXTURES_HOST = "http://textures.minecraft.net/texture/";
    public static final String PLAYER_COMMAND_PREFIX = "player:";

    @NotNull
    public static Set<Player> getOnline() {
        return new HashSet<Player>(Bukkit.getServer().getOnlinePlayers());
    }

    @NotNull
    public static List<String> playerNames() {
        return Players.playerNames(null);
    }

    @NotNull
    public static List<String> playerNames(@Nullable Player viewer) {
        return Players.getOnline().stream().filter(player -> viewer == null || viewer.canSee(player)).map(Player::getName).sorted(String::compareTo).toList();
    }

    @Deprecated
    @NotNull
    public static List<String> realPlayerNames() {
        return Players.realPlayerNames(null);
    }

    @Deprecated
    @NotNull
    public static List<String> realPlayerNames(@Nullable Player viewer) {
        return Players.playerNames(viewer, false);
    }

    @Deprecated
    @NotNull
    public static List<String> playerNames(@Nullable Player viewer, boolean includeCustom) {
        return Players.playerNames(viewer);
    }

    @NotNull
    public static Optional<Player> find(@NotNull String nameOrNick) {
        return Optional.ofNullable(Players.getPlayer(nameOrNick));
    }

    @Nullable
    public static Player getPlayer(@NotNull String name) {
        return Bukkit.getServer().getPlayer(name);
    }

    @Nullable
    public static Player getPlayer(@NotNull UUID uuid) {
        return Bukkit.getServer().getPlayer(uuid);
    }

    public static boolean isBedrock(@NotNull Player player) {
        return Plugins.hasFloodgate() && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId());
    }

    public static boolean isReal(@NotNull Player player) {
        return Players.getPlayer(player.getUniqueId()) != null;
    }

    public static void closeDialog(@NotNull Player player) {
        Software.get().closeDialog(player);
    }

    @Deprecated
    @NotNull
    public static NightProfile getProfile(@NotNull OfflinePlayer player) {
        return PlayerProfiles.getProfile(player).query();
    }

    @Deprecated
    @NotNull
    public static NightProfile createProfile(@NotNull UUID uuid) {
        return PlayerProfiles.createProfile(uuid).query();
    }

    @Deprecated
    @NotNull
    public static NightProfile createProfile(@NotNull String name) {
        return PlayerProfiles.createProfile(name);
    }

    @Deprecated
    @NotNull
    public static NightProfile createProfile(@NotNull UUID uuid, @Nullable String name) {
        return PlayerProfiles.createProfile(uuid, name).query();
    }

    @Deprecated
    @Nullable
    public static NightProfile createProfileBySkinURL(@NotNull String urlData) {
        CachedProfile profile = PlayerProfiles.createProfileBySkinURL(urlData);
        return profile == null ? null : profile.query();
    }

    @Deprecated
    @Nullable
    public static String getProfileSkinURL(@NotNull NightProfile profile) {
        return PlayerProfiles.getProfileSkinURL(profile);
    }

    @Deprecated
    @NotNull
    public static String getPermissionGroup(@NotNull Player player) {
        return Players.getPrimaryGroupOrDefault(player);
    }

    @Nullable
    public static String getPrimaryGroup(@NotNull Player player) {
        return PermissionBridge.provider().map(provider -> provider.getPrimaryGroup(player)).orElse(null);
    }

    @NotNull
    public static String getPrimaryGroup(@NotNull Player player, @NotNull String fallback) {
        String group = Players.getPrimaryGroup(player);
        return group == null ? fallback : group;
    }

    @NotNull
    public static String getPrimaryGroupOrDefault(@NotNull Player player) {
        return Players.getPrimaryGroup(player, "default");
    }

    @Deprecated
    @NotNull
    public static Set<String> getPermissionGroups(@NotNull Player player) {
        return Players.getInheritanceGroupsOrDefault(player);
    }

    @NotNull
    public static Set<String> getInheritanceGroups(@NotNull Player player) {
        return PermissionBridge.provider().map(provider -> provider.getPermissionGroups(player)).orElse(Collections.emptySet());
    }

    @NotNull
    public static Set<String> getInheritanceGroups(@NotNull Player player, @NotNull Set<String> fallback) {
        Set<String> groups = Players.getInheritanceGroups(player);
        return groups.isEmpty() ? fallback : groups;
    }

    @NotNull
    public static Set<String> getInheritanceGroupsOrDefault(@NotNull Player player) {
        return Players.getInheritanceGroups(player, Lists.newSet("default"));
    }

    @Deprecated
    @NotNull
    public static String getPrefix(@NotNull Player player) {
        return Players.getPrefixOrEmpty(player);
    }

    @NotNull
    public static String getPrefixOrEmpty(@NotNull Player player) {
        return Players.getPrefix(player, "");
    }

    @Nullable
    public static String getRawPrefix(@NotNull Player player) {
        return PermissionBridge.provider().map(provider -> provider.getPrefix(player)).orElse(null);
    }

    @NotNull
    public static String getPrefix(@NotNull Player player, @NotNull String fallback) {
        String prefix = Players.getRawPrefix(player);
        return prefix == null ? fallback : prefix;
    }

    @Deprecated
    @NotNull
    public static String getSuffix(@NotNull Player player) {
        return Players.getSuffixOrEmpty(player);
    }

    @NotNull
    public static String getSuffixOrEmpty(@NotNull Player player) {
        return Players.getSuffix(player, "");
    }

    @Nullable
    public static String getRawSuffix(@NotNull Player player) {
        return PermissionBridge.provider().map(provider -> provider.getSuffix(player)).orElse(null);
    }

    @NotNull
    public static String getSuffix(@NotNull Player player, @NotNull String fallback) {
        String suffix = Players.getRawSuffix(player);
        return suffix == null ? fallback : suffix;
    }

    @Deprecated
    public static void sendModernMessage(@NotNull CommandSender sender, @NotNull String message) {
        Players.sendMessage(sender, message);
    }

    public static void sendMessage(@NotNull CommandSender sender, @NotNull String message) {
        Players.sendMessage(sender, NightMessage.parse(message));
    }

    public static void sendMessage(@NotNull CommandSender sender, @NotNull NightComponent component) {
        Software.get().getTextComponentAdapter().send(sender, component);
    }

    @Deprecated
    public static void sendActionBarText(@NotNull Player player, @NotNull String message) {
        Players.sendActionBar(player, message);
    }

    @Deprecated
    public static void sendActionBar(@NotNull Player player, @NotNull TextRoot message) {
        Players.sendActionBar(player, message.getString());
    }

    public static void sendActionBar(@NotNull Player player, @NotNull String message) {
        Players.sendActionBar(player, NightMessage.parse(message));
    }

    public static void sendActionBar(@NotNull Player player, @NotNull NightComponent component) {
        Software.get().getTextComponentAdapter().sendActionBar(player, component);
    }

    @Deprecated
    public static void sendTitle(@NotNull Player player, @NotNull String title, @NotNull String subtitle, int fadeIn, int stay, int fadeOut) {
        Players.sendTitles(player, title, subtitle, fadeIn, stay, fadeOut);
    }

    public static void sendTitles(@NotNull Player player, @NotNull String title, @NotNull String subtitle, int fadeIn, int stay, int fadeOut) {
        Players.sendTitles(player, NightMessage.parse(title), NightMessage.parse(subtitle), fadeIn, stay, fadeOut);
    }

    public static void sendTitles(@NotNull Player player, @NotNull NightComponent title, @NotNull NightComponent subtitle, int fadeIn, int stay, int fadeOut) {
        Software.get().sendTitles(player, title, subtitle, fadeIn, stay, fadeOut);
    }

    public static void dispatchCommands(@NotNull Player player, String ... commands) {
        for (String command : commands) {
            Players.dispatchCommand(player, command);
        }
    }

    public static void dispatchCommands(@NotNull Player player, @NotNull List<String> commands) {
        for (String command : commands) {
            Players.dispatchCommand(player, command);
        }
    }

    public static void dispatchCommand(@NotNull Player player, @NotNull String command) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        if (command.startsWith(PLAYER_COMMAND_PREFIX)) {
            command = command.substring(PLAYER_COMMAND_PREFIX.length());
            sender = player;
        }
        command = ((String)Placeholders.forPlayerWithPAPI(player).apply(command)).trim();
        Bukkit.dispatchCommand((CommandSender)sender, (String)command);
    }

    public static boolean hasEmptyInventory(@NotNull Player player) {
        return Stream.of(player.getInventory().getContents()).allMatch(item -> item == null || item.getType().isAir());
    }

    public static boolean hasEmptyContents(@NotNull Player player) {
        return Stream.of(player.getInventory().getContents()).allMatch(item -> item == null || item.getType().isAir());
    }

    public static int countItemSpace(@NotNull Player player, @NotNull ItemStack item) {
        int stackSize = item.getType().getMaxStackSize();
        return Stream.of(player.getInventory().getStorageContents()).mapToInt(itemHas -> {
            if (itemHas == null || itemHas.getType().isAir()) {
                return stackSize;
            }
            if (itemHas.isSimilar(item)) {
                return stackSize - itemHas.getAmount();
            }
            return 0;
        }).sum();
    }

    public static int countItem(@NotNull Player player, @NotNull Predicate<ItemStack> predicate) {
        return Stream.of(player.getInventory().getContents()).filter(item -> item != null && predicate.test((ItemStack)item)).mapToInt(ItemStack::getAmount).sum();
    }

    public static int countItem(@NotNull Player player, @NotNull ItemStack item) {
        return Players.countItem(player, arg_0 -> ((ItemStack)item).isSimilar(arg_0));
    }

    public static int countItem(@NotNull Player player, @NotNull Material material) {
        return Players.countItem(player, (ItemStack itemHas) -> itemHas.getType() == material);
    }

    public static void takeItem(@NotNull Player player, @NotNull ItemStack item) {
        Players.takeItem(player, item, -1);
    }

    public static void takeItem(@NotNull Player player, @NotNull ItemStack item, int amount) {
        Players.takeItem(player, (ItemStack itemHas) -> itemHas.isSimilar(item), amount);
    }

    public static void takeItem(@NotNull Player player, @NotNull Material material) {
        Players.takeItem(player, material, -1);
    }

    public static void takeItem(@NotNull Player player, @NotNull Material material, int amount) {
        Players.takeItem(player, (ItemStack itemHas) -> itemHas.getType() == material, amount);
    }

    public static void takeItem(@NotNull Player player, @NotNull Predicate<ItemStack> predicate) {
        Players.takeItem(player, predicate, -1);
    }

    public static void takeItem(@NotNull Player player, @NotNull Predicate<ItemStack> predicate, int amount) {
        int takenAmount = 0;
        PlayerInventory inventory = player.getInventory();
        for (ItemStack itemHas : inventory.getContents()) {
            if (itemHas == null || !predicate.test(itemHas)) continue;
            if (amount < 0) {
                itemHas.setAmount(0);
                continue;
            }
            int hasAmount = itemHas.getAmount();
            if (takenAmount + hasAmount > amount) {
                int diff = takenAmount + hasAmount - amount;
                itemHas.setAmount(diff);
                break;
            }
            itemHas.setAmount(0);
            if ((takenAmount += hasAmount) == amount) break;
        }
    }

    public static void addItem(@NotNull Player player, ItemStack ... items) {
        for (ItemStack item : items) {
            Players.addItem(player, item, item.getAmount());
        }
    }

    public static void addItem(@NotNull Player player, @NotNull ItemStack itemStack, int amount) {
        if (amount <= 0 || itemStack.getType().isAir()) {
            return;
        }
        World world = player.getWorld();
        ItemStack split = new ItemStack(itemStack);
        int realAmount = Math.min(split.getMaxStackSize(), amount);
        split.setAmount(realAmount);
        player.getInventory().addItem(new ItemStack[]{split}).values().forEach(left -> world.dropItem(player.getLocation(), left));
        if ((amount -= realAmount) > 0) {
            Players.addItem(player, itemStack, amount);
        }
    }
}

