/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.blocktracker;

import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;

public class TrackUtil {
    public static long getChunkKey(@NotNull Chunk chunk) {
        return TrackUtil.getChunkKey(chunk.getX(), chunk.getZ());
    }

    public static long getChunkKey(int chunkX, int chunkZ) {
        return (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
    }

    public static long getChunkKeyOfBlock(@NotNull Block block) {
        return TrackUtil.getChunkKey(block.getX() >> 4, block.getZ() >> 4);
    }

    public static int getRelativeChunkPosition(@NotNull Block block) {
        int relX = (block.getX() % 16 + 16) % 16;
        int relZ = (block.getZ() % 16 + 16) % 16;
        int relY = block.getY();
        return relY & 0xFFFF | (relX & 0xFF) << 16 | (relZ & 0xFF) << 24;
    }
}

