/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.bridge;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.function.Function;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Version;

public interface RegistryType<T extends Keyed> {
    public static final RegistryType<Material> MATERIAL = RegistryType.type(isSpigot -> Registry.MATERIAL);
    public static final RegistryType<Enchantment> ENCHANTMENT = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Enchantment.class) : RegistryType.forPaper(RegistryKey.ENCHANTMENT));
    public static final RegistryType<GameEvent> GAME_EVENT = RegistryType.type(isSpigot -> isSpigot != false ? Registry.GAME_EVENT : RegistryType.forPaper(RegistryKey.GAME_EVENT));
    public static final RegistryType<StructureType> STRUCTURE_TYPE = RegistryType.type(isSpigot -> isSpigot != false ? Registry.STRUCTURE_TYPE : RegistryType.forPaper(RegistryKey.STRUCTURE_TYPE));
    public static final RegistryType<PotionEffectType> MOB_EFFECT = RegistryType.type(isSpigot -> isSpigot != false ? Registry.EFFECT : RegistryType.forPaper(RegistryKey.MOB_EFFECT));
    public static final RegistryType<Villager.Profession> VILLAGER_PROFESSION = RegistryType.type(isSpigot -> isSpigot != false ? Registry.VILLAGER_PROFESSION : RegistryType.forPaper(RegistryKey.VILLAGER_PROFESSION));
    public static final RegistryType<Villager.Type> VILLAGER_TYPE = RegistryType.type(isSpigot -> isSpigot != false ? Registry.VILLAGER_TYPE : RegistryType.forPaper(RegistryKey.VILLAGER_TYPE));
    public static final RegistryType<Attribute> ATTRIBUTE = RegistryType.type(isSpigot -> isSpigot != false ? Registry.ATTRIBUTE : RegistryType.forPaper(RegistryKey.ATTRIBUTE));
    public static final RegistryType<Fluid> FLUID = RegistryType.type(isSpigot -> isSpigot != false ? Registry.FLUID : RegistryType.forPaper(RegistryKey.FLUID));
    public static final RegistryType<Sound> SOUND = RegistryType.type(isSpigot -> isSpigot != false ? Registry.SOUNDS : RegistryType.forPaper(RegistryKey.SOUND_EVENT));
    public static final RegistryType<Biome> BIOME = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Biome.class) : RegistryType.forPaper(RegistryKey.BIOME));
    public static final RegistryType<Structure> STRUCTURE = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Structure.class) : RegistryType.forPaper(RegistryKey.STRUCTURE));
    public static final RegistryType<TrimMaterial> TRIM_MATERIAL = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(TrimMaterial.class) : RegistryType.forPaper(RegistryKey.TRIM_MATERIAL));
    public static final RegistryType<TrimPattern> TRIM_PATTERN = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(TrimPattern.class) : RegistryType.forPaper(RegistryKey.TRIM_PATTERN));
    public static final RegistryType<DamageType> DAMAGE_TYPE = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(DamageType.class) : RegistryType.forPaper(RegistryKey.DAMAGE_TYPE));
    public static final RegistryType<PatternType> BANNER_PATTERN = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(PatternType.class) : RegistryType.forPaper(RegistryKey.BANNER_PATTERN));
    public static final RegistryType<Art> PAINTING_VARIANT = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Art.class) : RegistryType.forPaper(RegistryKey.PAINTING_VARIANT));
    public static final RegistryType<MusicInstrument> INSTRUMENT = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(MusicInstrument.class) : RegistryType.forPaper(RegistryKey.INSTRUMENT));
    public static final RegistryType<Cat.Type> CAT_VARIANT = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Cat.Type.class) : RegistryType.forPaper(RegistryKey.CAT_VARIANT));
    public static final RegistryType<Frog.Variant> FROG_VARIANT = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Frog.Variant.class) : RegistryType.forPaper(RegistryKey.FROG_VARIANT));
    public static final RegistryType<EntityType> ENTITY_TYPE = RegistryType.type(isSpigot -> isSpigot != false ? Registry.ENTITY_TYPE : RegistryType.forPaper(RegistryKey.ENTITY_TYPE));
    public static final RegistryType<Particle> PARTICLE_TYPE = RegistryType.type(isSpigot -> isSpigot != false ? Registry.PARTICLE_TYPE : RegistryType.forPaper(RegistryKey.PARTICLE_TYPE));
    public static final RegistryType<PotionType> POTION = RegistryType.type(isSpigot -> isSpigot != false ? Registry.POTION : RegistryType.forPaper(RegistryKey.POTION));

    @NotNull
    public @NotNull Registry<@NotNull T> getRegistry();

    private static <T extends Keyed> RegistryType<T> type(@NotNull @NotNull Function<Boolean, Registry<@NotNull T>> function) {
        Registry registry = function.apply(Version.isSpigot() || Version.isBehind(Version.MC_1_21));
        return () -> registry;
    }

    private static <T extends Keyed> Registry<@NotNull T> forSpigot(@NotNull Class<T> clazz) {
        return Bukkit.getRegistry(clazz);
    }

    private static <T extends Keyed> Registry<@NotNull T> forPaper(@NotNull RegistryKey<T> key) {
        return RegistryAccess.registryAccess().getRegistry(key);
    }

    public static class Paper {
        public static final RegistryType<DataComponentType> DATA_COMPONENT_TYPE = RegistryType.type(isSpigot -> RegistryType.forPaper(RegistryKey.DATA_COMPONENT_TYPE));
        public static final RegistryType<MemoryKey<?>> MEMORY_MODULE_TYPE = RegistryType.type(isSpigot -> RegistryType.forPaper(RegistryKey.MEMORY_MODULE_TYPE));
        public static final RegistryType<Wolf.SoundVariant> WOLF_SOUND_VARIANT = RegistryType.type(isSpigot -> RegistryType.forPaper(RegistryKey.WOLF_SOUND_VARIANT));
    }

    public static class MC_1_21_5 {
        public static final RegistryType<Chicken.Variant> CHICKEN_VARIANT = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Chicken.Variant.class) : RegistryType.forPaper(RegistryKey.CHICKEN_VARIANT));
        public static final RegistryType<Cow.Variant> COW_VARIANT = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Cow.Variant.class) : RegistryType.forPaper(RegistryKey.COW_VARIANT));
        public static final RegistryType<Pig.Variant> PIG_VARIANT = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Pig.Variant.class) : RegistryType.forPaper(RegistryKey.PIG_VARIANT));
    }

    public static class MC_1_21 {
        public static final RegistryType<BlockType> BLOCK = RegistryType.type(isSpigot -> isSpigot != false ? Registry.BLOCK : RegistryType.forPaper(RegistryKey.BLOCK));
        public static final RegistryType<ItemType> ITEM = RegistryType.type(isSpigot -> isSpigot != false ? Registry.ITEM : RegistryType.forPaper(RegistryKey.ITEM));
        public static final RegistryType<JukeboxSong> JUKEBOX_SONG = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(JukeboxSong.class) : RegistryType.forPaper(RegistryKey.JUKEBOX_SONG));
        public static final RegistryType<MapCursor.Type> MAP_DECORATION_TYPE = RegistryType.type(isSpigot -> isSpigot != false ? Registry.MAP_DECORATION_TYPE : RegistryType.forPaper(RegistryKey.MAP_DECORATION_TYPE));
        public static final RegistryType<Wolf.Variant> WOLF_VARIANT = RegistryType.type(isSpigot -> isSpigot != false ? RegistryType.forSpigot(Wolf.Variant.class) : RegistryType.forPaper(RegistryKey.WOLF_VARIANT));
        public static final RegistryType<MenuType> MENU = RegistryType.type(isSpigot -> isSpigot != false ? Registry.MENU : RegistryType.forPaper(RegistryKey.MENU));
    }
}

