/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text.night.wrapper;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;

public class SimpleTagWrapper
implements TagWrapper {
    private final String tag;
    private final String[] arguments;

    public SimpleTagWrapper(@NotNull String tag, String[] arguments) {
        this.tag = tag;
        this.arguments = arguments;
    }

    @NotNull
    public String opening() {
        return "<" + this.openingNoBrackets() + ">";
    }

    @NotNull
    public String openingNoBrackets() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.tag);
        if (this.arguments.length > 0) {
            builder.append(':');
            builder.append(String.join((CharSequence)String.valueOf(':'), this.arguments));
        }
        return builder.toString();
    }

    @NotNull
    public String closing() {
        return String.valueOf('<') + "/" + this.tag + ">";
    }

    @Override
    @NotNull
    public String wrap(@NotNull String string) {
        return this.opening() + string + this.closing();
    }
}

