/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.spigot.dialog;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.dialog.ConfirmationDialog;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.api.dialog.DialogBase;
import net.md_5.bungee.api.dialog.DialogListDialog;
import net.md_5.bungee.api.dialog.MultiActionDialog;
import net.md_5.bungee.api.dialog.NoticeDialog;
import net.md_5.bungee.api.dialog.ServerLinksDialog;
import net.md_5.bungee.api.dialog.action.Action;
import net.md_5.bungee.api.dialog.action.ActionButton;
import net.md_5.bungee.api.dialog.action.CustomClickAction;
import net.md_5.bungee.api.dialog.action.RunCommandAction;
import net.md_5.bungee.api.dialog.action.StaticAction;
import net.md_5.bungee.api.dialog.body.DialogBody;
import net.md_5.bungee.api.dialog.body.PlainMessageBody;
import net.md_5.bungee.api.dialog.input.BooleanInput;
import net.md_5.bungee.api.dialog.input.DialogInput;
import net.md_5.bungee.api.dialog.input.InputOption;
import net.md_5.bungee.api.dialog.input.NumberRangeInput;
import net.md_5.bungee.api.dialog.input.SingleOptionInput;
import net.md_5.bungee.api.dialog.input.TextInput;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.common.NightNbtHolder;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogActionAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogBaseAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogBodyAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogButtonAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogInputAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogTypeAdapter;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogCommandTemplateAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogCustomAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogStaticAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.base.WrappedDialogAfterAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.base.WrappedDialogBase;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedItemDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedPlainMessageDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedBooleanDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedNumberRangeDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.text.WrappedMultilineOptions;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.text.WrappedTextDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedConfirmationType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogListType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedMultiActionType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedNoticeType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedServerLinksType;
import su.nightexpress.nightcore.bridge.spigot.SpigotBridge;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class SpigotDialogAdapter
implements DialogAdapter<Dialog>,
DialogActionAdapter<Action>,
DialogBaseAdapter<DialogBase>,
DialogBodyAdapter<DialogBody>,
DialogButtonAdapter<ActionButton>,
DialogInputAdapter<DialogInput>,
DialogTypeAdapter<Dialog> {
    private final SpigotBridge bridge;
    private DialogBase tempBase;

    public SpigotDialogAdapter(@NotNull SpigotBridge bridge) {
        this.bridge = bridge;
    }

    @NotNull
    private BaseComponent adaptComponent(@NotNull String component) {
        return this.adaptComponent(NightMessage.parse(component));
    }

    @NotNull
    private BaseComponent adaptComponent(@NotNull NightComponent component) {
        return this.bridge.getTextComponentAdapter().adaptComponent(component);
    }

    @Override
    @NotNull
    public Dialog adaptDialog(@NotNull WrappedDialog wrappedDialog) {
        WrappedDialogBase wrappedBase = wrappedDialog.base();
        WrappedDialogType wrappedType = wrappedDialog.type();
        this.tempBase = this.adaptBase(wrappedBase);
        Dialog type = this.adaptType(wrappedType);
        this.tempBase = null;
        return type;
    }

    @Override
    @NotNull
    public Action adaptAction(@NotNull WrappedDialogAction action) {
        return action.adapt(this);
    }

    @Override
    @NotNull
    public StaticAction adaptAction(@NotNull WrappedDialogStaticAction action) {
        ClickEvent clickEvent = this.bridge.getTextComponentAdapter().adaptClickEvent(action.clickEvent());
        return new StaticAction(clickEvent);
    }

    @Override
    @NotNull
    public CustomClickAction adaptAction(@NotNull WrappedDialogCustomAction action) {
        CustomClickAction handle = new CustomClickAction(action.id());
        handle.additions(action.nbt() == null ? null : action.nbt().payload());
        return handle;
    }

    @Override
    @NotNull
    public RunCommandAction adaptAction(@NotNull WrappedDialogCommandTemplateAction action) {
        return new RunCommandAction(action.template());
    }

    @NotNull
    private DialogBase.AfterAction adaptAfterAction(@NotNull WrappedDialogAfterAction action) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case WrappedDialogAfterAction.NONE -> DialogBase.AfterAction.NONE;
            case WrappedDialogAfterAction.CLOSE -> DialogBase.AfterAction.CLOSE;
            case WrappedDialogAfterAction.WAIT_FOR_RESPONSE -> DialogBase.AfterAction.WAIT_FOR_RESPONSE;
        };
    }

    @Override
    @NotNull
    public DialogBase adaptBase(@NotNull WrappedDialogBase base) {
        BaseComponent title = this.adaptComponent(base.title());
        BaseComponent externalTitle = base.externalTitle() == null ? null : this.adaptComponent(base.externalTitle());
        boolean canCloseWithEscape = base.canCloseWithEscape();
        boolean pause = base.pause();
        DialogBase.AfterAction afterAction = this.adaptAfterAction(base.afterAction());
        List<DialogBody> body = Lists.modify(base.body(), this::adaptBody);
        List<DialogInput> inputs = Lists.modify(base.inputs(), this::adaptInput);
        return new DialogBase(title, externalTitle, inputs, body, Boolean.valueOf(canCloseWithEscape), Boolean.valueOf(pause), afterAction);
    }

    @Override
    @NotNull
    public DialogBody adaptBody(@NotNull WrappedDialogBody body) {
        return body.adapt(this);
    }

    @Override
    @NotNull
    public DialogBody adaptBody(@NotNull WrappedItemDialogBody body) {
        return new PlainMessageBody(this.adaptComponent(body.description() == null ? "" : body.description().contents()), Integer.valueOf(body.width()));
    }

    @Override
    @NotNull
    public PlainMessageBody adaptBody(@NotNull WrappedPlainMessageDialogBody body) {
        BaseComponent contents = this.adaptComponent(body.contents());
        int width = body.width();
        return new PlainMessageBody(contents, Integer.valueOf(width));
    }

    @Override
    @NotNull
    public ActionButton adaptButton(@NotNull WrappedActionButton wrappedButton) {
        WrappedDialogAction wrappedAction = wrappedButton.action();
        if (wrappedAction == null) {
            wrappedAction = new WrappedDialogCustomAction("empty", NightNbtHolder.fromJson((JsonElement)new JsonObject()));
        }
        BaseComponent label = this.adaptComponent(wrappedButton.label());
        BaseComponent tooltip = wrappedButton.tooltip() == null ? null : this.adaptComponent(wrappedButton.tooltip());
        Action action = this.adaptAction(wrappedAction);
        int width = wrappedButton.width();
        return new ActionButton(label, tooltip, Integer.valueOf(width), action);
    }

    @Override
    @NotNull
    public DialogInput adaptInput(@NotNull WrappedDialogInput input) {
        return input.adapt(this);
    }

    @Override
    @NotNull
    public TextInput adaptInput(@NotNull WrappedTextDialogInput input) {
        String key = input.key();
        int width = input.width();
        BaseComponent label = this.adaptComponent(input.label());
        boolean labelVisible = input.labelVisible();
        String initial = input.initial();
        int maxLength = input.maxLength();
        WrappedMultilineOptions wrappedMultiline = input.multiline();
        TextInput.Multiline multilineOptions = wrappedMultiline == null ? null : new TextInput.Multiline(wrappedMultiline.maxLines(), wrappedMultiline.height());
        return new TextInput(key, Integer.valueOf(width), label, Boolean.valueOf(labelVisible), initial, Integer.valueOf(maxLength), multilineOptions);
    }

    @NotNull
    private InputOption adaptEntry(@NotNull WrappedSingleOptionEntry wrappedEntry) {
        String id = wrappedEntry.id();
        BaseComponent display = this.adaptComponent(wrappedEntry.display());
        boolean initial = wrappedEntry.initial();
        return new InputOption(id, display, Boolean.valueOf(initial));
    }

    @Override
    @NotNull
    public SingleOptionInput adaptInput(@NotNull WrappedSingleOptionDialogInput input) {
        String key = input.key();
        int width = input.width();
        List<InputOption> entries = Lists.modify(input.entries(), this::adaptEntry);
        BaseComponent label = this.adaptComponent(input.label());
        boolean labelVisible = input.labelVisible();
        return new SingleOptionInput(key, Integer.valueOf(width), label, Boolean.valueOf(labelVisible), entries);
    }

    @Override
    @NotNull
    public BooleanInput adaptInput(@NotNull WrappedBooleanDialogInput input) {
        String key = input.key();
        BaseComponent label = this.adaptComponent(input.label());
        boolean initial = input.initial();
        String onTrue = input.onTrue();
        String onFalse = input.onFalse();
        return new BooleanInput(key, label, Boolean.valueOf(initial), onTrue, onFalse);
    }

    @Override
    @NotNull
    public NumberRangeInput adaptInput(@NotNull WrappedNumberRangeDialogInput input) {
        String key = input.key();
        int width = input.width();
        BaseComponent label = this.adaptComponent(input.label());
        String labelFormat = input.labelFormat();
        float start = input.start();
        float end = input.end();
        Float initial = input.initial();
        Float step = input.step();
        return new NumberRangeInput(key, Integer.valueOf(width), label, labelFormat, start, end, initial, step);
    }

    @Override
    @NotNull
    public Dialog adaptType(@NotNull WrappedDialogType type) {
        return type.adapt(this);
    }

    @Override
    @NotNull
    public ConfirmationDialog adaptType(@NotNull WrappedConfirmationType type) {
        WrappedActionButton wrappedYes = type.yesButton();
        WrappedActionButton wrappedNo = type.noButton();
        return new ConfirmationDialog(this.tempBase, this.adaptButton(wrappedYes), this.adaptButton(wrappedNo));
    }

    @Override
    @NotNull
    public DialogListDialog adaptType(@NotNull WrappedDialogListType type) {
        List<WrappedDialog> wrappedDialogs = type.dialogs();
        WrappedActionButton exitAction = type.exitAction();
        int buttonWidth = type.buttonWidth();
        int columns = type.columns();
        List<Dialog> dialogs = Lists.modify(wrappedDialogs, this::adaptDialog);
        ActionButton exit = exitAction == null ? null : this.adaptButton(exitAction);
        return new DialogListDialog(this.tempBase, dialogs, exit, Integer.valueOf(columns), Integer.valueOf(buttonWidth));
    }

    @Override
    @NotNull
    public MultiActionDialog adaptType(@NotNull WrappedMultiActionType type) {
        List<WrappedActionButton> wrappedActions = type.actions();
        WrappedActionButton wrappedExit = type.exitAction();
        List<ActionButton> actions = Lists.modify(wrappedActions, this::adaptButton);
        ActionButton exitAction = wrappedExit == null ? null : this.adaptButton(wrappedExit);
        int columns = type.columns();
        return new MultiActionDialog(this.tempBase, actions, Integer.valueOf(columns), exitAction);
    }

    @Override
    @NotNull
    public NoticeDialog adaptType(@NotNull WrappedNoticeType type) {
        WrappedActionButton wrappedAction = type.action();
        ActionButton action = this.adaptButton(wrappedAction);
        return new NoticeDialog(this.tempBase, action);
    }

    @Override
    @NotNull
    public ServerLinksDialog adaptType(@NotNull WrappedServerLinksType type) {
        WrappedActionButton wrappedExit = type.exitAction();
        ActionButton exitAction = wrappedExit == null ? null : this.adaptButton(wrappedExit);
        int columns = type.columns();
        int buttonWidth = type.buttonWidth();
        return new ServerLinksDialog(this.tempBase, exitAction, Integer.valueOf(columns), Integer.valueOf(buttonWidth));
    }
}

