/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    public static void copy(@NotNull InputStream inputStream, @NotNull File file) {
        try {
            int read;
            FileOutputStream outputStream = new FileOutputStream(file);
            byte[] array = new byte[1024];
            while ((read = inputStream.read(array)) > 0) {
                outputStream.write(array, 0, read);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static boolean createFileIfNotExists(@NotNull Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            return true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean create(@NotNull File file) {
        if (file.exists()) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        parent.mkdirs();
        try {
            return file.createNewFile();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @NotNull
    public static List<File> getConfigFiles(@NotNull String path) {
        return FileUtil.getConfigFiles(path, false);
    }

    @NotNull
    public static List<File> getConfigFiles(@NotNull String path, boolean deep) {
        return FileUtil.getFiles(path, ".yml", deep);
    }

    @NotNull
    public static List<File> getFiles(@NotNull String path) {
        return FileUtil.getFiles(path, false);
    }

    @NotNull
    public static List<File> getFiles(@NotNull String path, boolean deep) {
        return FileUtil.getFiles(path, null, deep);
    }

    @NotNull
    public static List<File> getFiles(@NotNull String path, @Nullable String extension, boolean deep) {
        ArrayList<File> files = new ArrayList<File>();
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return files;
        }
        for (File file : listOfFiles) {
            if (file.isFile()) {
                if (extension != null && !file.getName().endsWith(extension)) continue;
                files.add(file);
                continue;
            }
            if (!file.isDirectory() || !deep) continue;
            files.addAll(FileUtil.getFiles(file.getPath(), true));
        }
        return files;
    }

    @NotNull
    public static List<File> getFolders(@NotNull String path) {
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return Collections.emptyList();
        }
        return Stream.of(listOfFiles).filter(File::isDirectory).toList();
    }

    public static boolean deleteRecursive(@NotNull String path) {
        return FileUtil.deleteRecursive(new File(path));
    }

    public static boolean deleteRecursive(@NotNull File dir) {
        if (!dir.exists()) {
            return false;
        }
        File[] inside = dir.listFiles();
        if (inside != null) {
            for (File file : inside) {
                FileUtil.deleteRecursive(file);
            }
        }
        return dir.delete();
    }

    public static void extractResources(@NotNull File pluginFile, @NotNull String fromPath, @NotNull File destination) {
        if (!destination.exists() && !destination.mkdirs()) {
            return;
        }
        try {
            JarFile jar = new JarFile(pluginFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                File file;
                JarEntry entry = entries.nextElement();
                String path = entry.getName();
                if (entry.isDirectory() || !path.startsWith(fromPath) || (file = new File(destination, path.replaceFirst(fromPath, ""))).exists()) continue;
                FileUtil.create(file);
                InputStream inputStream = jar.getInputStream(entry);
                FileOutputStream outputStream = new FileOutputStream(file);
                while (inputStream.available() > 0) {
                    outputStream.write(inputStream.read());
                }
                outputStream.close();
                inputStream.close();
            }
            jar.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

