/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text.night.tag.handler;

import java.util.UUID;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.common.NightKey;
import su.nightexpress.nightcore.bridge.text.contents.NightObjectContents;
import su.nightexpress.nightcore.bridge.text.contents.NightPlayerHeadObjectContents;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.entry.EntryGroup;
import su.nightexpress.nightcore.util.text.night.entry.PlayerHeadEntry;
import su.nightexpress.nightcore.util.text.night.tag.TagContent;
import su.nightexpress.nightcore.util.text.night.tag.handler.ClassicTagHandler;

public class HeadTagHandler
extends ClassicTagHandler {
    private static final Pattern UUIDv4_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ABCD][0-9a-f]{3}-[0-9a-f]{12}", 2);

    @Override
    protected void onHandleOpen(@NotNull EntryGroup group, @Nullable String tagContent) {
        boolean hat;
        if (tagContent == null) {
            return;
        }
        if (!Version.withCopperAge()) {
            return;
        }
        TagContent content = ParserUtils.parseInnerContent(tagContent);
        String data = content.first();
        boolean bl = hat = !content.hasBoth() || Boolean.parseBoolean(content.second());
        NightPlayerHeadObjectContents contents = UUIDv4_PATTERN.matcher(data).matches() ? NightObjectContents.playerHead(UUID.fromString(data), hat) : (data.contains("/") && NightKey.parseable(data) ? NightObjectContents.playerHead(NightKey.key(data), hat) : NightObjectContents.playerHead(data, hat));
        group.appendEntry(new PlayerHeadEntry(group, contents));
    }

    @Override
    protected void onHandleClose(@NotNull EntryGroup group) {
    }

    @Override
    public boolean canBeClosed() {
        return false;
    }
}

