/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure;

import com.unifiedsecure.alt.AltDetector;
import com.unifiedsecure.chat.ChatFilter;
import com.unifiedsecure.cluster.ClusterDetector;
import com.unifiedsecure.commands.CommandSpyCmd;
import com.unifiedsecure.commands.FreezeCmd;
import com.unifiedsecure.commands.GeoIPCmd;
import com.unifiedsecure.commands.HelpCmd;
import com.unifiedsecure.commands.IPDynamicCmd;
import com.unifiedsecure.commands.LoggerCmd;
import com.unifiedsecure.commands.ModerationCmd;
import com.unifiedsecure.commands.PlayerInfoCmd;
import com.unifiedsecure.commands.PlaytimeCmd;
import com.unifiedsecure.commands.SnapshotCmd;
import com.unifiedsecure.commands.SocialSpyCmd;
import com.unifiedsecure.commands.StaffCmd;
import com.unifiedsecure.commands.TPSCmd;
import com.unifiedsecure.commands.UnifiedCmd;
import com.unifiedsecure.commands.VanishCmd;
import com.unifiedsecure.config.ConfigManager;
import com.unifiedsecure.config.WebhookConfigManager;
import com.unifiedsecure.coreprotect.BlockLogger;
import com.unifiedsecure.correlation.InfractionsCorrelator;
import com.unifiedsecure.debug.DebugProfiler;
import com.unifiedsecure.discord.DiscordWebhookClient;
import com.unifiedsecure.geoip.GeoIPService;
import com.unifiedsecure.ip.BanManager;
import com.unifiedsecure.ip.IPTracker;
import com.unifiedsecure.listeners.ComprehensiveListener;
import com.unifiedsecure.listeners.IPBanListener;
import com.unifiedsecure.listeners.LoggingListener;
import com.unifiedsecure.listeners.ModerationListener;
import com.unifiedsecure.listeners.PlayerConnectionListener;
import com.unifiedsecure.listeners.PlaytimeListener;
import com.unifiedsecure.logging.LogRotationTask;
import com.unifiedsecure.logging.LoggerService;
import com.unifiedsecure.moderation.PunishmentManager;
import com.unifiedsecure.performance.PerformanceMonitor;
import com.unifiedsecure.player.PlaytimeTracker;
import com.unifiedsecure.risk.RiskAlertSystem;
import com.unifiedsecure.snapshot.SnapshotSystem;
import com.unifiedsecure.spy.CommandSpy;
import com.unifiedsecure.spy.SocialSpy;
import com.unifiedsecure.staff.FreezeManager;
import com.unifiedsecure.staff.StaffModeListener;
import com.unifiedsecure.staff.StaffModeManager;
import com.unifiedsecure.storage.LocalJsonStorage;
import com.unifiedsecure.storage.MySQLStorage;
import com.unifiedsecure.storage.SQLiteStorage;
import com.unifiedsecure.storage.StorageProvider;
import com.unifiedsecure.stress.StressDetector;
import com.unifiedsecure.trust.TrustSystem;
import com.unifiedsecure.util.AsyncUtil;
import com.unifiedsecure.vanish.VanishManager;
import com.unifiedsecure.vpn.VPNDetector;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class UnifiedSecureMgr
extends JavaPlugin {
    private static UnifiedSecureMgr instance;
    private ConfigManager configManager;
    private WebhookConfigManager webhookConfigManager;
    private StorageProvider storageProvider;
    private AsyncUtil asyncUtil;
    private IPTracker ipTracker;
    private BanManager banManager;
    private AltDetector altDetector;
    private LoggerService loggerService;
    private GeoIPService geoIPService;
    private PlaytimeTracker playtimeTracker;
    private DiscordWebhookClient webhookClient;
    private PunishmentManager punishmentManager;
    private VPNDetector vpnDetector;
    private StressDetector stressDetector;
    private ClusterDetector clusterDetector;
    private ChatFilter chatFilter;
    private CommandSpy commandSpy;
    private SocialSpy socialSpy;
    private SnapshotSystem snapshotSystem;
    private TrustSystem trustSystem;
    private RiskAlertSystem riskAlertSystem;
    private InfractionsCorrelator infractionsCorrelator;
    private DebugProfiler debugProfiler;
    private VanishManager vanishManager;
    private StaffModeManager staffModeManager;
    private FreezeManager freezeManager;
    private BlockLogger blockLogger;
    private PerformanceMonitor performanceMonitor;
    private long startTime;

    public void onEnable() {
        instance = this;
        this.startTime = System.currentTimeMillis();
        this.printBanner();
        this.createDataFolders();
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.webhookConfigManager = new WebhookConfigManager(this);
        this.webhookConfigManager.loadConfig();
        this.asyncUtil = new AsyncUtil(this);
        if (!this.initializeStorage()) {
            this.getLogger().severe("Failed to initialize storage backend. Plugin disabled.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.initializeModules();
        this.registerCommands();
        this.registerListeners();
        this.startScheduledTasks();
        this.getLogger().info("Server Guardian v" + this.getDescription().getVersion() + " enabled successfully.");
        this.getLogger().info("Storage Backend: " + this.configManager.getStorageType());
        this.getLogger().info("Enabled Features: " + this.getEnabledFeatures());
    }

    public void onDisable() {
        if (this.asyncUtil != null) {
            this.asyncUtil.shutdown();
        }
        if (this.configManager != null && this.configManager.isAutoSaveEnabled()) {
            this.getLogger().info("Saving all data before shutdown...");
            this.saveAllData();
        }
        if (this.storageProvider != null) {
            this.storageProvider.close();
        }
        this.getLogger().info("Server Guardian disabled.");
    }

    private void printBanner() {
        this.getLogger().info("==========================================");
        this.getLogger().info("  Server Guardian v" + this.getDescription().getVersion());
        this.getLogger().info("  IP Guardian (IPG) | Server Guardian (SERVG)");
        this.getLogger().info("  Comprehensive Security & Moderation");
        this.getLogger().info("==========================================");
    }

    private void createDataFolders() {
        new File(this.getDataFolder(), "data/ip/playerdata").mkdirs();
        new File(this.getDataFolder(), "data/logs").mkdirs();
        new File(this.getDataFolder(), "data/playtime").mkdirs();
        new File(this.getDataFolder(), "data/alt").mkdirs();
        new File(this.getDataFolder(), "data/bans").mkdirs();
        new File(this.getDataFolder(), "data/webhooks").mkdirs();
        new File(this.getDataFolder(), "data/backups").mkdirs();
        new File(this.getDataFolder(), "data/blocks").mkdirs();
        new File(this.getDataFolder(), "data/snapshots").mkdirs();
    }

    private boolean initializeStorage() {
        String storageType = this.configManager.getStorageType();
        try {
            switch (storageType.toUpperCase()) {
                case "MYSQL": {
                    this.storageProvider = new MySQLStorage(this);
                    break;
                }
                case "SQLITE": {
                    this.storageProvider = new SQLiteStorage(this);
                    break;
                }
                default: {
                    this.storageProvider = new LocalJsonStorage(this);
                }
            }
            this.storageProvider.initialize();
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize storage: " + storageType, e);
            if (this.configManager.shouldFailOnDbError()) {
                return false;
            }
            this.getLogger().warning("Falling back to local JSON storage...");
            try {
                this.storageProvider = new LocalJsonStorage(this);
                this.storageProvider.initialize();
                return true;
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, "Failed to initialize fallback storage", ex);
                return false;
            }
        }
    }

    private void initializeModules() {
        this.webhookClient = new DiscordWebhookClient(this);
        if (this.configManager.isFeatureEnabled("ipTracking")) {
            this.ipTracker = new IPTracker(this);
            this.banManager = new BanManager(this);
            this.getLogger().info("IP Guardian (IPG) module enabled.");
        }
        if (this.configManager.isFeatureEnabled("altDetection")) {
            this.altDetector = new AltDetector(this);
            this.getLogger().info("Alt Detection module enabled.");
        }
        if (this.configManager.isFeatureEnabled("logging")) {
            this.loggerService = new LoggerService(this);
            this.getLogger().info("Logger module enabled.");
        }
        if (this.configManager.isFeatureEnabled("geoip")) {
            this.geoIPService = new GeoIPService(this);
            this.getLogger().info("GeoIP module enabled.");
        }
        if (this.configManager.isFeatureEnabled("playtime")) {
            this.playtimeTracker = new PlaytimeTracker(this);
            this.getLogger().info("Playtime Tracker module enabled.");
        }
        if (this.configManager.isFeatureEnabled("moderation")) {
            this.punishmentManager = new PunishmentManager(this);
            this.getLogger().info("Punishment Manager enabled.");
        }
        if (this.configManager.getConfig().getBoolean("vpn.enabled", true)) {
            this.vpnDetector = new VPNDetector(this);
            this.getLogger().info("VPN Detector enabled.");
        }
        if (this.configManager.getConfig().getBoolean("stress.enabled", true)) {
            this.stressDetector = new StressDetector(this);
            this.getLogger().info("Stress Detector enabled.");
        }
        if (this.configManager.getConfig().getBoolean("cluster.enabled", true)) {
            this.clusterDetector = new ClusterDetector(this);
            this.getLogger().info("Cluster Detector enabled.");
        }
        if (this.configManager.getConfig().getBoolean("chatFilter.enabled", true)) {
            this.chatFilter = new ChatFilter(this);
            this.getLogger().info("Chat Filter enabled.");
        }
        if (this.configManager.getConfig().getBoolean("spy.enabled", true)) {
            this.commandSpy = new CommandSpy(this);
            this.socialSpy = new SocialSpy(this);
            this.getLogger().info("Spy systems enabled.");
        }
        if (this.configManager.getConfig().getBoolean("snapshot.enabled", true)) {
            this.snapshotSystem = new SnapshotSystem(this);
            this.getLogger().info("Snapshot System enabled.");
        }
        if (this.configManager.getConfig().getBoolean("trust.enabled", true)) {
            this.trustSystem = new TrustSystem(this);
            this.getLogger().info("Trust System enabled.");
        }
        if (this.configManager.getConfig().getBoolean("risk.enabled", true)) {
            this.riskAlertSystem = new RiskAlertSystem(this);
            this.getLogger().info("Risk Alert System enabled.");
        }
        if (this.configManager.getConfig().getBoolean("correlation.enabled", true)) {
            this.infractionsCorrelator = new InfractionsCorrelator(this);
            this.getLogger().info("Infractions Correlator enabled.");
        }
        if (this.configManager.getConfig().getBoolean("debug.enabled", false)) {
            this.debugProfiler = new DebugProfiler(this);
            this.getLogger().info("Debug Profiler enabled.");
        }
        if (this.configManager.getConfig().getBoolean("vanish.enabled", true)) {
            this.vanishManager = new VanishManager(this);
            this.getLogger().info("Vanish Manager enabled.");
        }
        if (this.configManager.getConfig().getBoolean("staff.enabled", true)) {
            this.staffModeManager = new StaffModeManager(this);
            this.freezeManager = new FreezeManager(this);
            this.getLogger().info("Staff systems enabled.");
        }
        if (this.configManager.getConfig().getBoolean("blockLogging.enabled", true)) {
            this.blockLogger = new BlockLogger(this);
            this.getLogger().info("Block Logger enabled.");
        }
        if (this.configManager.getConfig().getBoolean("performance.enabled", true)) {
            this.performanceMonitor = new PerformanceMonitor(this);
            this.getLogger().info("Performance Monitor enabled.");
        }
    }

    private void registerCommands() {
        UnifiedCmd existingUnifiedCmd;
        if (this.ipTracker != null) {
            IPDynamicCmd ipdCmd = new IPDynamicCmd(this);
            this.safeRegisterCommand("ipg", ipdCmd, ipdCmd);
        }
        if (this.geoIPService != null) {
            GeoIPCmd geoCmd = new GeoIPCmd(this);
            this.safeRegisterCommand("geoip", geoCmd, geoCmd);
        }
        PlayerInfoCmd infoCmd = new PlayerInfoCmd(this);
        this.safeRegisterCommand("getinfo", infoCmd, infoCmd);
        if (this.playtimeTracker != null) {
            PlaytimeCmd ptimeCmd = new PlaytimeCmd(this);
            this.safeRegisterCommand("ptime", ptimeCmd, ptimeCmd);
        }
        if (this.loggerService != null) {
            LoggerCmd loggerCmd = new LoggerCmd(this);
            this.safeRegisterCommand("logger", loggerCmd, loggerCmd);
        }
        UnifiedCmd unifiedCmd = new UnifiedCmd(this);
        this.safeRegisterCommand("servg", unifiedCmd, unifiedCmd);
        HelpCmd helpCmd = new HelpCmd(this);
        PluginCommand unifiedPluginCmd = this.getCommand("servg");
        if (unifiedPluginCmd != null && (existingUnifiedCmd = (UnifiedCmd)unifiedPluginCmd.getExecutor()) != null) {
            existingUnifiedCmd.setHelpCmd(helpCmd);
        }
        if (this.punishmentManager != null) {
            ModerationCmd moderationCmd = new ModerationCmd(this);
            this.safeRegisterCommand("ban", moderationCmd, moderationCmd);
            this.safeRegisterCommand("tempban", moderationCmd, moderationCmd);
            this.safeRegisterCommand("unban", moderationCmd, moderationCmd);
            this.safeRegisterCommand("mute", moderationCmd, moderationCmd);
            this.safeRegisterCommand("unmute", moderationCmd, moderationCmd);
            this.safeRegisterCommand("warn", moderationCmd, moderationCmd);
            this.safeRegisterCommand("kick", moderationCmd, moderationCmd);
            this.safeRegisterCommand("banlist", moderationCmd, moderationCmd);
            this.safeRegisterCommand("history", moderationCmd, moderationCmd);
        }
        if (this.staffModeManager != null) {
            StaffCmd staffCmd = new StaffCmd(this);
            this.safeRegisterCommand("staff", staffCmd, staffCmd);
        }
        if (this.vanishManager != null) {
            VanishCmd vanishCmd = new VanishCmd(this);
            this.safeRegisterCommand("vanish", vanishCmd, vanishCmd);
        }
        if (this.freezeManager != null) {
            FreezeCmd freezeCmd = new FreezeCmd(this);
            this.safeRegisterCommand("freeze", freezeCmd, freezeCmd);
        }
        if (this.snapshotSystem != null) {
            SnapshotCmd snapshotCmd = new SnapshotCmd(this);
            this.safeRegisterCommand("snapshot", snapshotCmd, snapshotCmd);
        }
        if (this.commandSpy != null) {
            CommandSpyCmd cmdSpyCmd = new CommandSpyCmd(this);
            this.safeRegisterCommand("commandspy", cmdSpyCmd, cmdSpyCmd);
        }
        if (this.socialSpy != null) {
            SocialSpyCmd socialSpyCmd = new SocialSpyCmd(this);
            this.safeRegisterCommand("socialspy", socialSpyCmd, socialSpyCmd);
        }
        if (this.performanceMonitor != null) {
            TPSCmd tpsCmd = new TPSCmd(this);
            this.safeRegisterCommand("tps", tpsCmd, null);
        }
    }

    private void safeRegisterCommand(String name, CommandExecutor executor, TabCompleter tabCompleter) {
        PluginCommand command = this.getCommand(name);
        if (command != null) {
            command.setExecutor(executor);
            if (tabCompleter != null) {
                command.setTabCompleter(tabCompleter);
            }
            this.getLogger().info("Registered command: /" + name);
        } else {
            this.getLogger().warning("Failed to register command: /" + name + " (command not found in plugin.yml)");
        }
    }

    private void registerListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        if (this.ipTracker != null || this.altDetector != null) {
            pm.registerEvents((Listener)new PlayerConnectionListener(this), (Plugin)this);
        }
        if (this.banManager != null) {
            pm.registerEvents((Listener)new IPBanListener(this), (Plugin)this);
        }
        if (this.loggerService != null) {
            pm.registerEvents((Listener)new LoggingListener(this), (Plugin)this);
        }
        if (this.playtimeTracker != null) {
            pm.registerEvents((Listener)new PlaytimeListener(this), (Plugin)this);
        }
        if (this.punishmentManager != null) {
            pm.registerEvents((Listener)new ModerationListener(this), (Plugin)this);
        }
        if (this.staffModeManager != null) {
            pm.registerEvents((Listener)new StaffModeListener(this), (Plugin)this);
        }
        pm.registerEvents((Listener)new ComprehensiveListener(this), (Plugin)this);
    }

    private void startScheduledTasks() {
        int saveInterval = this.configManager.getSaveIntervalSeconds() * 20;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::saveAllData, (long)saveInterval, (long)saveInterval);
        if (this.loggerService != null) {
            int retentionDays = this.configManager.getFileRetentionDays();
            LogRotationTask rotationTask = new LogRotationTask(this, retentionDays);
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)rotationTask, 72000L, 72000L);
        }
        if (this.configManager.isMetricsEnabled()) {
            int metricsInterval = this.configManager.getMetricsSamplingInterval() * 20;
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::logMetrics, (long)metricsInterval, (long)metricsInterval);
        }
    }

    private void saveAllData() {
        if (this.ipTracker != null) {
            this.ipTracker.saveAll();
        }
        if (this.banManager != null) {
            this.banManager.saveAll();
        }
        if (this.playtimeTracker != null) {
            this.playtimeTracker.saveAll();
        }
        if (this.altDetector != null) {
            this.altDetector.saveDetections();
        }
    }

    private void logMetrics() {
        if (this.loggerService != null) {
            double tps = this.getTPS();
            long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
            long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
            long usedMemory = totalMemory - freeMemory;
            this.loggerService.logMetric("TPS", tps);
            this.loggerService.logMetric("Memory Used (MB)", usedMemory);
            this.loggerService.logMetric("Memory Total (MB)", totalMemory);
        }
    }

    private double getTPS() {
        try {
            Server server = Bukkit.getServer();
            Object minecraftServer = server.getClass().getMethod("getServer", new Class[0]).invoke((Object)server, new Object[0]);
            double[] recentTps = (double[])minecraftServer.getClass().getField("recentTps").get(minecraftServer);
            return recentTps[0];
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    private String getEnabledFeatures() {
        StringBuilder sb = new StringBuilder();
        if (this.configManager.isFeatureEnabled("ipTracking")) {
            sb.append("IPG, ");
        }
        if (this.configManager.isFeatureEnabled("altDetection")) {
            sb.append("Alt, ");
        }
        if (this.configManager.isFeatureEnabled("logging")) {
            sb.append("Logging, ");
        }
        if (this.configManager.isFeatureEnabled("geoip")) {
            sb.append("GeoIP, ");
        }
        if (this.configManager.isFeatureEnabled("playtime")) {
            sb.append("Playtime, ");
        }
        if (this.configManager.isFeatureEnabled("moderation")) {
            sb.append("Moderation, ");
        }
        if (this.vpnDetector != null) {
            sb.append("VPN, ");
        }
        if (this.stressDetector != null) {
            sb.append("Stress, ");
        }
        if (this.chatFilter != null) {
            sb.append("ChatFilter, ");
        }
        if (this.trustSystem != null) {
            sb.append("Trust, ");
        }
        if (this.vanishManager != null) {
            sb.append("Vanish, ");
        }
        if (this.staffModeManager != null) {
            sb.append("Staff, ");
        }
        if (this.blockLogger != null) {
            sb.append("BlockLog, ");
        }
        if (this.performanceMonitor != null) {
            sb.append("Performance");
        }
        return sb.toString().replaceAll(", $", "");
    }

    public void reload() {
        this.configManager.loadConfig();
        this.webhookConfigManager.loadConfig();
        if (this.loggerService != null) {
            this.loggerService.reload();
        }
        if (this.chatFilter != null) {
            this.chatFilter.loadRules();
        }
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public static UnifiedSecureMgr getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public WebhookConfigManager getWebhookConfigManager() {
        return this.webhookConfigManager;
    }

    public StorageProvider getStorageProvider() {
        return this.storageProvider;
    }

    public AsyncUtil getAsyncUtil() {
        return this.asyncUtil;
    }

    public IPTracker getIPTracker() {
        return this.ipTracker;
    }

    public BanManager getBanManager() {
        return this.banManager;
    }

    public AltDetector getAltDetector() {
        return this.altDetector;
    }

    public LoggerService getLoggerService() {
        return this.loggerService;
    }

    public GeoIPService getGeoIPService() {
        return this.geoIPService;
    }

    public PlaytimeTracker getPlaytimeTracker() {
        return this.playtimeTracker;
    }

    public DiscordWebhookClient getWebhookClient() {
        return this.webhookClient;
    }

    public PunishmentManager getPunishmentManager() {
        return this.punishmentManager;
    }

    public VPNDetector getVPNDetector() {
        return this.vpnDetector;
    }

    public StressDetector getStressDetector() {
        return this.stressDetector;
    }

    public ClusterDetector getClusterDetector() {
        return this.clusterDetector;
    }

    public ChatFilter getChatFilter() {
        return this.chatFilter;
    }

    public CommandSpy getCommandSpy() {
        return this.commandSpy;
    }

    public SocialSpy getSocialSpy() {
        return this.socialSpy;
    }

    public SnapshotSystem getSnapshotSystem() {
        return this.snapshotSystem;
    }

    public TrustSystem getTrustSystem() {
        return this.trustSystem;
    }

    public RiskAlertSystem getRiskAlertSystem() {
        return this.riskAlertSystem;
    }

    public InfractionsCorrelator getInfractionsCorrelator() {
        return this.infractionsCorrelator;
    }

    public DebugProfiler getDebugProfiler() {
        return this.debugProfiler;
    }

    public VanishManager getVanishManager() {
        return this.vanishManager;
    }

    public StaffModeManager getStaffModeManager() {
        return this.staffModeManager;
    }

    public FreezeManager getFreezeManager() {
        return this.freezeManager;
    }

    public BlockLogger getBlockLogger() {
        return this.blockLogger;
    }

    public PerformanceMonitor getPerformanceMonitor() {
        return this.performanceMonitor;
    }
}

