/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.alt;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.AltDetection;
import com.unifiedsecure.model.PlayerIPData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class AltDetector {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, List<AltDetection>> detectionCache;

    public AltDetector(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.detectionCache = new ConcurrentHashMap<UUID, List<AltDetection>>();
        this.loadAllDetections();
    }

    private void loadAllDetections() {
        this.plugin.getAsyncUtil().runAsync(() -> {
            List<AltDetection> allDetections = this.plugin.getStorageProvider().loadAllAltDetections();
            allDetections.forEach(detection -> this.detectionCache.computeIfAbsent(detection.getPlayerUuid(), k -> new ArrayList()).add(detection));
            this.plugin.getLogger().info("Loaded " + allDetections.size() + " alt detections.");
        });
    }

    public void checkForAlts(Player player) {
        UUID playerUuid = player.getUniqueId();
        if (this.plugin.getConfigManager().shouldIgnoreWhitelist() && this.plugin.getConfigManager().getWhitelistedPlayers().contains(player.getName())) {
            return;
        }
        this.plugin.getAsyncUtil().runAsync(() -> {
            PlayerIPData playerData = this.plugin.getIPTracker().getPlayerData(playerUuid);
            if (playerData == null) {
                return;
            }
            List<String> playerIPs = playerData.getIpHistory();
            for (PlayerIPData otherData : this.plugin.getIPTracker().getAllData().values()) {
                if (otherData.getUuid().equals(playerUuid)) continue;
                ArrayList<String> sharedIPs = new ArrayList<String>(playerIPs);
                sharedIPs.retainAll(otherData.getIpHistory());
                if (sharedIPs.size() < this.plugin.getConfigManager().getSharedIPThreshold()) continue;
                for (String sharedIP : sharedIPs) {
                    double confidence = this.calculateConfidence(playerData, otherData, sharedIP);
                    AltDetection detection = new AltDetection(playerUuid, otherData.getUuid(), sharedIP, System.currentTimeMillis(), confidence);
                    this.detectionCache.computeIfAbsent(playerUuid, k -> new ArrayList()).add(detection);
                    this.plugin.getStorageProvider().saveAltDetection(detection);
                    this.notifyStaff(player, otherData.getUsername(), sharedIP, confidence);
                    if (!this.plugin.getConfigManager().shouldAutoTempban() || !(confidence > 0.75)) continue;
                    int duration = this.plugin.getConfigManager().getTempbanDurationSeconds();
                    this.plugin.getBanManager().banIP(sharedIP, "Suspected alt account", "System", (long)duration * 1000L);
                }
            }
        });
    }

    public int getAltCount(UUID uuid) {
        List<AltDetection> detections = this.detectionCache.get(uuid);
        if (detections == null) {
            return 0;
        }
        HashSet<UUID> uniqueAlts = new HashSet<UUID>();
        for (AltDetection detection : detections) {
            uniqueAlts.add(detection.getAltUuid());
        }
        return uniqueAlts.size();
    }

    private double calculateConfidence(PlayerIPData player1, PlayerIPData player2, String sharedIP) {
        long timeDiff;
        long daysDiff;
        double confidence = 0.5;
        if (player1.getCurrentIP().equals(sharedIP) && player2.getCurrentIP().equals(sharedIP)) {
            confidence += 0.3;
        }
        if ((daysDiff = (timeDiff = Math.abs(player1.getLastJoin() - player2.getLastJoin())) / 86400000L) < (long)this.plugin.getConfigManager().getAltTimeWindowDays()) {
            confidence += 0.2;
        }
        return Math.min(confidence, 1.0);
    }

    private void notifyStaff(Player player, String altName, String sharedIP, double confidence) {
        String message = this.plugin.getConfigManager().getMessage("alt.detected").replace("%player%", player.getName()).replace("%alt%", altName).replace("%ip%", sharedIP).replace("%confidence%", String.format("%.0f%%", confidence * 100.0));
        this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("unified.alt.notify")).forEach(p -> p.sendMessage(message));
    }

    public List<AltDetection> getDetections(UUID uuid) {
        return this.detectionCache.getOrDefault(uuid, Collections.emptyList());
    }

    public void saveDetections() {
        this.plugin.getAsyncUtil().runAsync(() -> this.detectionCache.values().forEach(detections -> detections.forEach(detection -> this.plugin.getStorageProvider().saveAltDetection((AltDetection)detection))));
    }
}

