/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.chat;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.chat.FilterAction;
import com.unifiedsecure.chat.FilterResult;
import com.unifiedsecure.chat.FilterRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatFilter {
    private final UnifiedSecureMgr plugin;
    private final List<FilterRule> rules;
    private final Map<UUID, Integer> violations;

    public ChatFilter(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.rules = new ArrayList<FilterRule>();
        this.violations = new HashMap<UUID, Integer>();
        this.loadRules();
    }

    public void loadRules() {
        this.rules.clear();
        ConfigurationSection section = this.plugin.getConfigManager().getConfig().getConfigurationSection("chatFilter.rules");
        if (section == null) {
            this.loadDefaultRules();
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection ruleSection = section.getConfigurationSection(key);
            String pattern = ruleSection.getString("pattern");
            String action = ruleSection.getString("action", "WARN");
            String message = ruleSection.getString("message", "\u00a7cPlease watch your language!");
            boolean enabled = ruleSection.getBoolean("enabled", true);
            if (!enabled || pattern == null) continue;
            this.rules.add(new FilterRule(key, Pattern.compile(pattern, 2), FilterAction.valueOf(action.toUpperCase()), message));
        }
    }

    private void loadDefaultRules() {
        this.rules.add(new FilterRule("swears", Pattern.compile("(fuck|shit|bitch|ass|damn|cunt|whore|slut|nigger|faggot)", 2), FilterAction.WARN, "\u00a7cPlease watch your language!"));
        this.rules.add(new FilterRule("ip_addresses", Pattern.compile("\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b"), FilterAction.BLOCK, "\u00a7cDo not share IP addresses!"));
        this.rules.add(new FilterRule("discord_invites", Pattern.compile("(discord\\.gg|discordapp\\.com/invite)/[a-zA-Z0-9]+", 2), FilterAction.BLOCK, "\u00a7cDo not advertise Discord servers!"));
        this.rules.add(new FilterRule("website_ads", Pattern.compile("(https?://)?(www\\.)?[a-zA-Z0-9-]+\\.(com|net|org|gg|xyz)", 2), FilterAction.WARN, "\u00a7cDo not advertise websites!"));
        this.rules.add(new FilterRule("spam", Pattern.compile("(.)\\1{5,}"), FilterAction.BLOCK, "\u00a7cDo not spam!"));
    }

    public FilterResult filter(Player player, String message) {
        if (player.hasPermission("unified.chatfilter.bypass")) {
            return new FilterResult(false, message, null);
        }
        for (FilterRule rule : this.rules) {
            if (!rule.getPattern().matcher(message).find()) continue;
            this.handleViolation(player, rule);
            switch (rule.getAction()) {
                case BLOCK: {
                    player.sendMessage(rule.getMessage());
                    return new FilterResult(true, null, rule);
                }
                case WARN: {
                    player.sendMessage(rule.getMessage());
                    return new FilterResult(false, message, rule);
                }
                case REPLACE: {
                    String filtered = rule.getPattern().matcher(message).replaceAll("***");
                    return new FilterResult(false, filtered, rule);
                }
                case LOG: {
                    if (this.plugin.getLoggerService() != null) {
                        this.plugin.getLoggerService().logChat(player.getUniqueId(), message, "FILTERED:" + rule.getName());
                    }
                    return new FilterResult(false, message, rule);
                }
                case MUTE: {
                    player.sendMessage(rule.getMessage());
                    int muteDuration = this.plugin.getConfigManager().getConfig().getInt("chatFilter.muteDuration", 300);
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "mute " + player.getName() + " " + muteDuration + "s Chat filter violation");
                    return new FilterResult(true, null, rule);
                }
            }
        }
        return new FilterResult(false, message, null);
    }

    private void handleViolation(Player player, FilterRule rule) {
        int threshold;
        int count = this.violations.merge(player.getUniqueId(), 1, Integer::sum);
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logSecurity("CHAT_FILTER", player.getName() + " violated rule: " + rule.getName() + " (count: " + count + ")");
        }
        if (count >= (threshold = this.plugin.getConfigManager().getConfig().getInt("chatFilter.violationThreshold", 5))) {
            String action = this.plugin.getConfigManager().getConfig().getString("chatFilter.thresholdAction", "MUTE");
            if (action.equalsIgnoreCase("KICK")) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer("\u00a7cToo many chat violations"));
            } else if (action.equalsIgnoreCase("TEMPBAN")) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "tempban " + player.getName() + " 1h Chat violations");
            } else if (action.equalsIgnoreCase("MUTE")) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "mute " + player.getName() + " 1h Repeated chat violations");
            }
            this.violations.remove(player.getUniqueId());
        }
    }

    public void resetViolations(UUID uuid) {
        this.violations.remove(uuid);
    }

    public int getViolations(UUID uuid) {
        return this.violations.getOrDefault(uuid, 0);
    }

    public List<FilterRule> getRules() {
        return new ArrayList<FilterRule>(this.rules);
    }
}

