/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.cluster;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.cluster.AccountCluster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ClusterDetector {
    private final UnifiedSecureMgr plugin;
    private final Map<String, Set<UUID>> ipClusters;
    private final Map<String, Set<UUID>> hardwareIdClusters;
    private final Map<UUID, String> playerHardwareIds;

    public ClusterDetector(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.ipClusters = new ConcurrentHashMap<String, Set<UUID>>();
        this.hardwareIdClusters = new ConcurrentHashMap<String, Set<UUID>>();
        this.playerHardwareIds = new ConcurrentHashMap<UUID, String>();
    }

    public void addToCluster(UUID uuid, String ip, String hardwareId) {
        this.ipClusters.computeIfAbsent(ip, k -> ConcurrentHashMap.newKeySet()).add(uuid);
        if (hardwareId != null && !hardwareId.isEmpty()) {
            this.hardwareIdClusters.computeIfAbsent(hardwareId, k -> ConcurrentHashMap.newKeySet()).add(uuid);
            this.playerHardwareIds.put(uuid, hardwareId);
        }
    }

    public AccountCluster getIPCluster(String ip) {
        Set<UUID> accounts = this.ipClusters.getOrDefault(ip, Collections.emptySet());
        return new AccountCluster(ip, "IP", accounts);
    }

    public AccountCluster getHardwareCluster(String hardwareId) {
        Set<UUID> accounts = this.hardwareIdClusters.getOrDefault(hardwareId, Collections.emptySet());
        return new AccountCluster(hardwareId, "HARDWARE", accounts);
    }

    public List<AccountCluster> getPlayerClusters(UUID uuid) {
        Set<UUID> hwCluster;
        ArrayList<AccountCluster> clusters = new ArrayList<AccountCluster>();
        for (Map.Entry<String, Set<UUID>> entry : this.ipClusters.entrySet()) {
            if (!entry.getValue().contains(uuid) || entry.getValue().size() <= 1) continue;
            clusters.add(new AccountCluster(entry.getKey(), "IP", entry.getValue()));
        }
        String hardwareId = this.playerHardwareIds.get(uuid);
        if (hardwareId != null && (hwCluster = this.hardwareIdClusters.get(hardwareId)) != null && hwCluster.size() > 1) {
            clusters.add(new AccountCluster(hardwareId, "HARDWARE", hwCluster));
        }
        return clusters;
    }

    public List<AccountCluster> getAllSuspiciousClusters() {
        int threshold = this.plugin.getConfigManager().getConfig().getInt("cluster.suspiciousThreshold", 3);
        ArrayList<AccountCluster> suspicious = new ArrayList<AccountCluster>();
        for (Map.Entry<String, Set<UUID>> entry : this.ipClusters.entrySet()) {
            if (entry.getValue().size() < threshold) continue;
            suspicious.add(new AccountCluster(entry.getKey(), "IP", entry.getValue()));
        }
        for (Map.Entry<String, Set<UUID>> entry : this.hardwareIdClusters.entrySet()) {
            if (entry.getValue().size() < threshold) continue;
            suspicious.add(new AccountCluster(entry.getKey(), "HARDWARE", entry.getValue()));
        }
        return suspicious;
    }

    public Map<UUID, Integer> getClusterRiskScores() {
        HashMap<UUID, Integer> scores = new HashMap<UUID, Integer>();
        for (Set<UUID> cluster : this.ipClusters.values()) {
            if (cluster.size() <= 1) continue;
            for (UUID uuid : cluster) {
                scores.merge(uuid, cluster.size(), Integer::sum);
            }
        }
        for (Set<UUID> cluster : this.hardwareIdClusters.values()) {
            if (cluster.size() <= 1) continue;
            for (UUID uuid : cluster) {
                scores.merge(uuid, cluster.size() * 2, Integer::sum);
            }
        }
        return scores;
    }

    public void removePlayer(UUID uuid) {
        for (Set<UUID> cluster : this.ipClusters.values()) {
            cluster.remove(uuid);
        }
        for (Set<UUID> cluster : this.hardwareIdClusters.values()) {
            cluster.remove(uuid);
        }
        this.playerHardwareIds.remove(uuid);
    }

    public int getClusterCount() {
        return (int)this.ipClusters.values().stream().filter(set -> set.size() > 1).count();
    }
}

