/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class GeoIPCmd
implements CommandExecutor,
TabCompleter {
    private final UnifiedSecureMgr plugin;

    public GeoIPCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("unified.geoip")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /geoip <player|ip>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[0]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found or invalid IP address.");
            return true;
        }
        String ip = this.plugin.getIPTracker().getPlayerIP(target);
        sender.sendMessage("\u00a76\u00a7l=== GeoIP Information ===");
        sender.sendMessage("\u00a7ePlayer: \u00a7f" + target.getName());
        sender.sendMessage("\u00a7eIP Address: \u00a7f" + ip);
        sender.sendMessage("\u00a7eCountry: \u00a7fUnknown (GeoIP database not configured)");
        sender.sendMessage("\u00a7eCity: \u00a7fUnknown");
        sender.sendMessage("\u00a7eISP: \u00a7fUnknown");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return null;
        }
        return new ArrayList<String>();
    }
}

