/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class HelpCmd
implements CommandExecutor,
TabCompleter {
    private final UnifiedSecureMgr plugin;

    public HelpCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int page = 1;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                page = 1;
            }
        }
        ArrayList<String[]> commands = new ArrayList<String[]>();
        if (sender.hasPermission("unified.admin")) {
            commands.add(new String[]{"/unified status", "View plugin status"});
            commands.add(new String[]{"/unified reload", "Reload configuration"});
            commands.add(new String[]{"/unified forget <player>", "Delete all player data"});
        }
        if (sender.hasPermission("unified.ipd.view")) {
            commands.add(new String[]{"/ipd info <player>", "View IP information"});
            commands.add(new String[]{"/ipd lookupip <ip>", "Find players by IP"});
        }
        if (sender.hasPermission("unified.ipd.ban")) {
            commands.add(new String[]{"/ipd banip <ip> [duration] [reason]", "Ban an IP address"});
            commands.add(new String[]{"/ipd unbanip <ip>", "Unban an IP address"});
            commands.add(new String[]{"/ipd listbans [page]", "List all IP bans"});
        }
        if (sender.hasPermission("unified.ipd.whitelist")) {
            commands.add(new String[]{"/ipd whitelist <add|remove|list> [player]", "Manage IP whitelist"});
        }
        if (sender.hasPermission("unified.geoip")) {
            commands.add(new String[]{"/geoip <player|ip>", "Lookup GeoIP information"});
        }
        if (sender.hasPermission("unified.playerinfo")) {
            commands.add(new String[]{"/getinfo <player>", "Get detailed player info"});
        }
        if (sender.hasPermission("unified.playtime")) {
            commands.add(new String[]{"/ptime <player> [type]", "View player playtime"});
        }
        if (sender.hasPermission("unified.moderation.ban")) {
            commands.add(new String[]{"/ban <player> [reason]", "Permanently ban a player"});
            commands.add(new String[]{"/tempban <player> <duration> [reason]", "Temporarily ban a player"});
        }
        if (sender.hasPermission("unified.moderation.unban")) {
            commands.add(new String[]{"/unban <player>", "Unban a player"});
        }
        if (sender.hasPermission("unified.moderation.mute")) {
            commands.add(new String[]{"/mute <player> [duration] [reason]", "Mute a player"});
            commands.add(new String[]{"/unmute <player>", "Unmute a player"});
        }
        if (sender.hasPermission("unified.moderation.warn")) {
            commands.add(new String[]{"/warn <player> <reason>", "Warn a player"});
        }
        if (sender.hasPermission("unified.moderation.kick")) {
            commands.add(new String[]{"/kick <player> [reason]", "Kick a player"});
        }
        if (sender.hasPermission("unified.moderation.view")) {
            commands.add(new String[]{"/banlist [page]", "List all active bans"});
            commands.add(new String[]{"/history <player>", "View punishment history"});
        }
        if (sender.hasPermission("unified.staff")) {
            commands.add(new String[]{"/staff", "Toggle staff mode"});
        }
        if (sender.hasPermission("unified.vanish")) {
            commands.add(new String[]{"/vanish", "Toggle vanish mode"});
        }
        if (sender.hasPermission("unified.freeze")) {
            commands.add(new String[]{"/freeze <player>", "Freeze/unfreeze a player"});
        }
        if (sender.hasPermission("unified.snapshot")) {
            commands.add(new String[]{"/snapshot <player>", "Create player snapshot"});
        }
        if (sender.hasPermission("unified.commandspy")) {
            commands.add(new String[]{"/commandspy", "Toggle command spy"});
        }
        if (sender.hasPermission("unified.socialspy")) {
            commands.add(new String[]{"/socialspy", "Toggle social spy"});
        }
        if (sender.hasPermission("unified.tps")) {
            commands.add(new String[]{"/tps", "View server performance"});
        }
        if (sender.hasPermission("unified.logger.view")) {
            commands.add(new String[]{"/logger status", "View logger status"});
            commands.add(new String[]{"/logger dump", "Create log dump"});
        }
        if (sender.hasPermission("unified.logger.reload")) {
            commands.add(new String[]{"/logger reload", "Reload logger config"});
        }
        if (commands.isEmpty()) {
            sender.sendMessage("\u00a7cYou don't have permission to use any commands!");
            return true;
        }
        int perPage = 10;
        int maxPage = (int)Math.ceil((double)commands.size() / (double)perPage);
        page = Math.max(1, Math.min(page, maxPage));
        sender.sendMessage("\u00a76\u00a7l=== UnifiedSecureMgr Help (Page " + page + "/" + maxPage + ") ===");
        int start = (page - 1) * perPage;
        int end = Math.min(start + perPage, commands.size());
        for (int i = start; i < end; ++i) {
            String[] cmd = (String[])commands.get(i);
            sender.sendMessage("\u00a7e" + cmd[0] + " \u00a77- " + cmd[1]);
        }
        if (page < maxPage) {
            sender.sendMessage("\u00a77Use \u00a7f/unified help " + (page + 1) + " \u00a77for next page");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return new ArrayList<String>();
    }
}

