/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.IPBan;
import com.unifiedsecure.model.PlayerIPData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class IPDynamicCmd
implements CommandExecutor,
TabCompleter {
    private final UnifiedSecureMgr plugin;
    private final Set<String> whitelist;

    public IPDynamicCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.whitelist = new HashSet<String>();
        this.loadWhitelist();
    }

    private void loadWhitelist() {
        List list = this.plugin.getConfig().getStringList("ip-whitelist");
        this.whitelist.addAll(list);
    }

    private void saveWhitelist() {
        this.plugin.getConfig().set("ip-whitelist", new ArrayList<String>(this.whitelist));
        this.plugin.saveConfig();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCmd;
        if (!sender.hasPermission("unified.ipd.view")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a76\u00a7l=== IP Dynamic Management ===");
            sender.sendMessage("\u00a77/ipd info <player> \u00a7f- View IP info");
            sender.sendMessage("\u00a77/ipd lookupip <ip> \u00a7f- Lookup IP address");
            sender.sendMessage("\u00a77/ipd banip <ip> [reason] \u00a7f- Ban an IP");
            sender.sendMessage("\u00a77/ipd unbanip <ip> \u00a7f- Unban an IP");
            sender.sendMessage("\u00a77/ipd listbans \u00a7f- List all IP bans");
            sender.sendMessage("\u00a77/ipd whitelist <add|remove|list> \u00a7f- Manage whitelist");
            return true;
        }
        switch (subCmd = args[0].toLowerCase()) {
            case "info": {
                return this.handleInfo(sender, args);
            }
            case "lookupip": {
                return this.handleLookupIP(sender, args);
            }
            case "banip": {
                return this.handleBanIP(sender, args);
            }
            case "unbanip": {
                return this.handleUnbanIP(sender, args);
            }
            case "listbans": {
                return this.handleListBans(sender);
            }
            case "whitelist": {
                return this.handleWhitelist(sender, args);
            }
        }
        sender.sendMessage("\u00a7cUnknown subcommand. Use /ipd for help.");
        return true;
    }

    private boolean handleInfo(CommandSender sender, String[] args) {
        Map<UUID, List<String>> sharedIPs;
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /ipd info <player>");
            return true;
        }
        if (this.plugin.getIPTracker() == null) {
            sender.sendMessage("\u00a7cIP tracking is not enabled!");
            return true;
        }
        OfflinePlayer target = this.plugin.getServer().getOfflinePlayer(args[1]);
        PlayerIPData data = this.plugin.getIPTracker().getPlayerData(target.getUniqueId());
        if (data == null) {
            sender.sendMessage("\u00a7cNo IP data found for " + args[1]);
            return true;
        }
        sender.sendMessage("\u00a76\u00a7l=== IP Info for " + data.getUsername() + " ===");
        sender.sendMessage("\u00a7eUUID: \u00a7f" + String.valueOf(data.getUuid()));
        sender.sendMessage("\u00a7eCurrent IP: \u00a7f" + data.getCurrentIP());
        sender.sendMessage("\u00a7eTotal IPs: \u00a7f" + data.getIpHistory().size());
        sender.sendMessage("\u00a7eFirst Join: \u00a7f" + String.valueOf(new Date(data.getFirstJoin())));
        sender.sendMessage("\u00a7eLast Join: \u00a7f" + String.valueOf(new Date(data.getLastJoin())));
        if (data.getIpHistory().size() > 0) {
            sender.sendMessage("\u00a7eIP History:");
            int count = 0;
            for (String ip : data.getIpHistory()) {
                sender.sendMessage("  \u00a77- \u00a7f" + ip);
                if (++count < 10) continue;
                sender.sendMessage("  \u00a77... and " + (data.getIpHistory().size() - 10) + " more");
                break;
            }
        }
        if (!(sharedIPs = this.plugin.getIPTracker().findAllSharedIPs(target.getUniqueId())).isEmpty()) {
            sender.sendMessage("\u00a7ePotential Alts: \u00a7c" + sharedIPs.size() + " accounts");
            int altCount = 0;
            for (Map.Entry<UUID, List<String>> entry : sharedIPs.entrySet()) {
                PlayerIPData altData = this.plugin.getIPTracker().getPlayerData(entry.getKey());
                if (altData == null) continue;
                sender.sendMessage("  \u00a77- \u00a7f" + altData.getUsername() + " \u00a77(\u00a7f" + entry.getValue().size() + " shared IPs\u00a77)");
                if (++altCount < 5) continue;
                sender.sendMessage("  \u00a77... and " + (sharedIPs.size() - 5) + " more");
                break;
            }
        }
        return true;
    }

    private boolean handleLookupIP(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /ipd lookupip <ip>");
            return true;
        }
        if (this.plugin.getIPTracker() == null) {
            sender.sendMessage("\u00a7cIP tracking is not enabled!");
            return true;
        }
        String ip = args[1];
        List<PlayerIPData> players = this.plugin.getIPTracker().getPlayersWithIP(ip);
        if (players.isEmpty()) {
            sender.sendMessage("\u00a7cNo players found with IP: " + ip);
            return true;
        }
        sender.sendMessage("\u00a76\u00a7l=== Players with IP " + ip + " ===");
        sender.sendMessage("\u00a7eTotal: \u00a7f" + players.size() + " players");
        for (PlayerIPData data : players) {
            String status = this.plugin.getServer().getOfflinePlayer(data.getUuid()).isOnline() ? "\u00a7aOnline" : "\u00a77Offline";
            sender.sendMessage("\u00a77- \u00a7f" + data.getUsername() + " " + status);
            sender.sendMessage("   \u00a77Last seen: \u00a7f" + String.valueOf(new Date(data.getLastJoin())));
        }
        IPBan ban = this.plugin.getStorageProvider().loadIPBan(ip);
        if (ban != null) {
            sender.sendMessage("\u00a7c\u00a7lThis IP is currently banned!");
            sender.sendMessage("\u00a7cReason: \u00a7f" + ban.getReason());
            sender.sendMessage("\u00a7cBanned by: \u00a7f" + ban.getBannedBy());
        }
        return true;
    }

    private boolean handleBanIP(CommandSender sender, String[] args) {
        if (!sender.hasPermission("unified.ipd.ban")) {
            sender.sendMessage("\u00a7cYou don't have permission to ban IPs!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /ipd banip <ip> [reason]");
            return true;
        }
        String ip = args[1];
        if (this.whitelist.contains(ip)) {
            sender.sendMessage("\u00a7cThis IP is whitelisted and cannot be banned!");
            return true;
        }
        String reason = "No reason provided";
        if (args.length > 2) {
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        }
        IPBan ban = new IPBan(ip, reason, sender.getName(), -1L);
        this.plugin.getStorageProvider().saveIPBan(ban);
        List<PlayerIPData> affectedPlayers = this.plugin.getIPTracker().getPlayersWithIP(ip);
        for (PlayerIPData data : affectedPlayers) {
            OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(data.getUuid());
            if (!player.isOnline()) continue;
            player.getPlayer().kickPlayer("\u00a7cYour IP has been banned!\n\u00a77Reason: " + reason);
        }
        sender.sendMessage("\u00a7aIP banned: \u00a7f" + ip);
        sender.sendMessage("\u00a7aReason: \u00a7f" + reason);
        sender.sendMessage("\u00a7aAffected players: \u00a7f" + affectedPlayers.size());
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logSecurity("IP_BAN", sender.getName() + " banned IP " + ip + " - Reason: " + reason);
        }
        return true;
    }

    private boolean handleUnbanIP(CommandSender sender, String[] args) {
        if (!sender.hasPermission("unified.ipd.ban")) {
            sender.sendMessage("\u00a7cYou don't have permission to unban IPs!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /ipd unbanip <ip>");
            return true;
        }
        String ip = args[1];
        IPBan ban = this.plugin.getStorageProvider().loadIPBan(ip);
        if (ban == null || !ban.isActive()) {
            sender.sendMessage("\u00a7cThis IP is not banned!");
            return true;
        }
        this.plugin.getStorageProvider().removeIPBan(ip);
        sender.sendMessage("\u00a7aIP unbanned: \u00a7f" + ip);
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logSecurity("IP_UNBAN", sender.getName() + " unbanned IP " + ip);
        }
        return true;
    }

    private boolean handleListBans(CommandSender sender) {
        List<IPBan> bans = this.plugin.getStorageProvider().loadAllIPBans();
        List activeBans = bans.stream().filter(IPBan::isActive).collect(Collectors.toList());
        if (activeBans.isEmpty()) {
            sender.sendMessage("\u00a7aThere are no active IP bans.");
            return true;
        }
        sender.sendMessage("\u00a76\u00a7l=== Active IP Bans (" + activeBans.size() + ") ===");
        for (IPBan ban : activeBans) {
            sender.sendMessage("\u00a7eIP: \u00a7f" + ban.getIp());
            sender.sendMessage("  \u00a77Reason: \u00a7f" + ban.getReason());
            sender.sendMessage("  \u00a77Banned by: \u00a7f" + ban.getBannedBy());
            sender.sendMessage("  \u00a77Date: \u00a7f" + String.valueOf(new Date(ban.getBannedAt())));
        }
        return true;
    }

    private boolean handleWhitelist(CommandSender sender, String[] args) {
        String action;
        if (!sender.hasPermission("unified.ipd.whitelist")) {
            sender.sendMessage("\u00a7cYou don't have permission to manage the whitelist!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /ipd whitelist <add|remove|list> [ip]");
            return true;
        }
        switch (action = args[1].toLowerCase()) {
            case "add": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /ipd whitelist add <ip>");
                    return true;
                }
                String addIp = args[2];
                if (this.whitelist.contains(addIp)) {
                    sender.sendMessage("\u00a7cThis IP is already whitelisted!");
                    return true;
                }
                this.whitelist.add(addIp);
                this.saveWhitelist();
                sender.sendMessage("\u00a7aAdded \u00a7f" + addIp + " \u00a7ato the whitelist.");
                break;
            }
            case "remove": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /ipd whitelist remove <ip>");
                    return true;
                }
                String removeIp = args[2];
                if (!this.whitelist.contains(removeIp)) {
                    sender.sendMessage("\u00a7cThis IP is not whitelisted!");
                    return true;
                }
                this.whitelist.remove(removeIp);
                this.saveWhitelist();
                sender.sendMessage("\u00a7aRemoved \u00a7f" + removeIp + " \u00a7afrom the whitelist.");
                break;
            }
            case "list": {
                if (this.whitelist.isEmpty()) {
                    sender.sendMessage("\u00a7eThe IP whitelist is empty.");
                    return true;
                }
                sender.sendMessage("\u00a76\u00a7l=== IP Whitelist (" + this.whitelist.size() + ") ===");
                for (String ip : this.whitelist) {
                    sender.sendMessage("\u00a77- \u00a7f" + ip);
                }
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUsage: /ipd whitelist <add|remove|list> [ip]");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("info", "lookupip", "banip", "unbanip", "listbans", "whitelist");
            String input = args[0].toLowerCase();
            for (String sub : subcommands) {
                if (!sub.startsWith(input)) continue;
                completions.add(sub);
            }
            return completions;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("info")) {
                return null;
            }
            if (args[0].equalsIgnoreCase("whitelist")) {
                return Arrays.asList("add", "remove", "list");
            }
        }
        return completions;
    }
}

