/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class LoggerCmd
implements CommandExecutor,
TabCompleter {
    private final UnifiedSecureMgr plugin;

    public LoggerCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("unified.logger.view")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a76\u00a7l=== Logger Management ===");
            sender.sendMessage("\u00a77/logger reload \u00a7f- Reload logger config");
            sender.sendMessage("\u00a77/logger dump \u00a7f- Dump current logs");
            sender.sendMessage("\u00a77/logger status \u00a7f- Check logger status");
            return true;
        }
        if (args[0].equalsIgnoreCase("status")) {
            sender.sendMessage("\u00a76\u00a7l=== Logger Status ===");
            sender.sendMessage("\u00a7eLogger: \u00a7aEnabled");
            sender.sendMessage("\u00a7eLog Files: \u00a7fdata/logs/");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (this.plugin.getLoggerService() != null) {
                this.plugin.getLoggerService().reload();
                sender.sendMessage("\u00a7aLogger configuration reloaded!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("dump")) {
            sender.sendMessage("\u00a7eLog dump feature is under development.");
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("reload", "dump", "status");
            String input = args[0].toLowerCase();
            for (String sub : subcommands) {
                if (!sub.startsWith(input)) continue;
                completions.add(sub);
            }
            return completions;
        }
        return completions;
    }
}

