/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.Punishment;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ModerationCmd
implements CommandExecutor,
TabCompleter {
    private final UnifiedSecureMgr plugin;

    public ModerationCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd = command.getName().toLowerCase();
        if (cmd.equals("ban")) {
            return this.handleBan(sender, args, false);
        }
        if (cmd.equals("tempban")) {
            return this.handleBan(sender, args, true);
        }
        if (cmd.equals("unban")) {
            return this.handleUnban(sender, args);
        }
        if (cmd.equals("mute")) {
            return this.handleMute(sender, args);
        }
        if (cmd.equals("unmute")) {
            return this.handleUnmute(sender, args);
        }
        if (cmd.equals("warn")) {
            return this.handleWarn(sender, args);
        }
        if (cmd.equals("kick")) {
            return this.handleKick(sender, args);
        }
        if (cmd.equals("banlist")) {
            return this.handleBanlist(sender, args);
        }
        if (cmd.equals("history")) {
            return this.handleHistory(sender, args);
        }
        return true;
    }

    private boolean handleBan(CommandSender sender, String[] args, boolean temp) {
        if (!sender.hasPermission("unified.moderation.ban")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /" + (temp ? "tempban" : "ban") + " <player> " + (temp ? "<duration> " : "") + "[reason]");
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage("\u00a7cPlayer not found: \u00a7f" + targetName);
            return true;
        }
        if (this.plugin.getPunishmentManager().isBanned(target.getUniqueId())) {
            sender.sendMessage("\u00a7c" + targetName + " is already banned!");
            return true;
        }
        long duration = -1L;
        String reason = "No reason specified";
        int reasonStart = 1;
        if (temp) {
            if (args.length < 2) {
                sender.sendMessage("\u00a7cUsage: /tempban <player> <duration> [reason]");
                return true;
            }
            duration = this.plugin.getPunishmentManager().parseDuration(args[1]);
            if (duration <= 0L) {
                sender.sendMessage("\u00a7cInvalid duration format. Examples: 1d, 12h, 30m");
                return true;
            }
            reasonStart = 2;
        }
        if (args.length > reasonStart) {
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, reasonStart, args.length));
        }
        UUID issuerUuid = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
        String issuerName = sender.getName();
        this.plugin.getPunishmentManager().ban(target.getUniqueId(), target.getName(), issuerUuid, issuerName, reason, duration);
        String durationStr = duration > 0L ? this.plugin.getPunishmentManager().formatDuration(duration) : "Permanent";
        sender.sendMessage("\u00a7aBanned \u00a7f" + target.getName() + " \u00a7afor \u00a7f" + durationStr + "\u00a7a. Reason: \u00a7f" + reason);
        for (Player staff : Bukkit.getOnlinePlayers()) {
            if (!staff.hasPermission("unified.moderation.notify")) continue;
            staff.sendMessage("\u00a7c" + issuerName + " \u00a7abanned \u00a7f" + target.getName() + " \u00a7afor \u00a7f" + durationStr + "\u00a7a. Reason: \u00a7f" + reason);
        }
        return true;
    }

    private boolean handleUnban(CommandSender sender, String[] args) {
        if (!sender.hasPermission("unified.moderation.unban")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /unban <player>");
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!this.plugin.getPunishmentManager().isBanned(target.getUniqueId())) {
            sender.sendMessage("\u00a7c" + targetName + " is not banned!");
            return true;
        }
        this.plugin.getPunishmentManager().unban(target.getUniqueId(), target.getName(), sender.getName());
        sender.sendMessage("\u00a7aUnbanned \u00a7f" + target.getName());
        for (Player staff : Bukkit.getOnlinePlayers()) {
            if (!staff.hasPermission("unified.moderation.notify")) continue;
            staff.sendMessage("\u00a7c" + sender.getName() + " \u00a7aunbanned \u00a7f" + target.getName());
        }
        return true;
    }

    private boolean handleMute(CommandSender sender, String[] args) {
        long parsedDuration;
        if (!sender.hasPermission("unified.moderation.mute")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /mute <player> [duration] [reason]");
            return true;
        }
        String targetName = args[0];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found: \u00a7f" + targetName);
            return true;
        }
        if (this.plugin.getPunishmentManager().isMuted(target.getUniqueId())) {
            sender.sendMessage("\u00a7c" + targetName + " is already muted!");
            return true;
        }
        long duration = -1L;
        String reason = "No reason specified";
        int reasonStart = 1;
        if (args.length > 1 && ((parsedDuration = this.plugin.getPunishmentManager().parseDuration(args[1])) != -1L || args[1].equalsIgnoreCase("permanent") || args[1].equalsIgnoreCase("perm"))) {
            duration = parsedDuration;
            reasonStart = 2;
        }
        if (args.length > reasonStart) {
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, reasonStart, args.length));
        }
        UUID issuerUuid = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
        String issuerName = sender.getName();
        this.plugin.getPunishmentManager().mute(target.getUniqueId(), target.getName(), issuerUuid, issuerName, reason, duration);
        String durationStr = duration > 0L ? this.plugin.getPunishmentManager().formatDuration(duration) : "Permanent";
        sender.sendMessage("\u00a7aMuted \u00a7f" + target.getName() + " \u00a7afor \u00a7f" + durationStr + "\u00a7a. Reason: \u00a7f" + reason);
        return true;
    }

    private boolean handleUnmute(CommandSender sender, String[] args) {
        if (!sender.hasPermission("unified.moderation.mute")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /unmute <player>");
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!this.plugin.getPunishmentManager().isMuted(target.getUniqueId())) {
            sender.sendMessage("\u00a7c" + targetName + " is not muted!");
            return true;
        }
        this.plugin.getPunishmentManager().unmute(target.getUniqueId(), sender.getName());
        sender.sendMessage("\u00a7aUnmuted \u00a7f" + target.getName());
        return true;
    }

    private boolean handleWarn(CommandSender sender, String[] args) {
        if (!sender.hasPermission("unified.moderation.warn")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /warn <player> <reason>");
            return true;
        }
        String targetName = args[0];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found: \u00a7f" + targetName);
            return true;
        }
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        UUID issuerUuid = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
        String issuerName = sender.getName();
        this.plugin.getPunishmentManager().warn(target.getUniqueId(), target.getName(), issuerUuid, issuerName, reason);
        sender.sendMessage("\u00a7aWarned \u00a7f" + target.getName() + "\u00a7a. Reason: \u00a7f" + reason);
        return true;
    }

    private boolean handleKick(CommandSender sender, String[] args) {
        if (!sender.hasPermission("unified.moderation.kick")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /kick <player> [reason]");
            return true;
        }
        String targetName = args[0];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found: \u00a7f" + targetName);
            return true;
        }
        String reason = args.length > 1 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)) : "No reason specified";
        UUID issuerUuid = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
        String issuerName = sender.getName();
        this.plugin.getPunishmentManager().kick(target.getUniqueId(), target.getName(), issuerUuid, issuerName, reason);
        sender.sendMessage("\u00a7aKicked \u00a7f" + target.getName() + "\u00a7a. Reason: \u00a7f" + reason);
        return true;
    }

    private boolean handleBanlist(CommandSender sender, String[] args) {
        if (!sender.hasPermission("unified.moderation.view")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        List<Punishment> bans = this.plugin.getPunishmentManager().getAllActiveBans();
        if (bans.isEmpty()) {
            sender.sendMessage("\u00a77No active bans.");
            return true;
        }
        int page = 1;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                page = 1;
            }
        }
        int perPage = 10;
        int maxPage = (int)Math.ceil((double)bans.size() / (double)perPage);
        page = Math.max(1, Math.min(page, maxPage));
        sender.sendMessage("\u00a76\u00a7l=== Ban List (Page " + page + "/" + maxPage + ") ===");
        int start = (page - 1) * perPage;
        int end = Math.min(start + perPage, bans.size());
        for (int i = start; i < end; ++i) {
            Punishment ban = bans.get(i);
            String duration = ban.isPermanent() ? "Permanent" : this.plugin.getPunishmentManager().formatDuration(ban.getExpiresAt() - System.currentTimeMillis());
            sender.sendMessage("\u00a78  - \u00a7f" + ban.getTargetName() + " \u00a77by " + ban.getIssuerName() + " - " + ban.getReason() + " \u00a78[" + duration + "]");
        }
        return true;
    }

    private boolean handleHistory(CommandSender sender, String[] args) {
        if (!sender.hasPermission("unified.moderation.view")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /history <player>");
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage("\u00a7cPlayer not found: \u00a7f" + targetName);
            return true;
        }
        this.plugin.getAsyncUtil().runAsync(() -> {
            List<Punishment> history = this.plugin.getPunishmentManager().getPunishmentHistory(target.getUniqueId());
            this.plugin.getAsyncUtil().runSync(() -> {
                if (history.isEmpty()) {
                    sender.sendMessage("\u00a77No punishment history for \u00a7f" + target.getName());
                    return;
                }
                sender.sendMessage("\u00a76\u00a7l=== Punishment History: " + target.getName() + " ===");
                sender.sendMessage("\u00a77Total punishments: \u00a7f" + history.size());
                int shown = Math.min(10, history.size());
                for (int i = 0; i < shown; ++i) {
                    Punishment p = (Punishment)history.get(i);
                    String status = p.isActive() ? "\u00a7a[ACTIVE]" : (p.isRemoved() ? "\u00a7c[REMOVED]" : "\u00a77[EXPIRED]");
                    String date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(p.getIssuedAt()));
                    sender.sendMessage(status + " \u00a7f" + String.valueOf((Object)p.getType()) + " \u00a77by " + p.getIssuerName() + " - " + p.getReason() + " \u00a78(" + date + ")");
                }
                if (history.size() > 10) {
                    sender.sendMessage("\u00a77... and " + (history.size() - 10) + " more");
                }
            });
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String cmd;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            return null;
        }
        if (args.length == 2 && ((cmd = command.getName().toLowerCase()).equals("ban") || cmd.equals("tempban") || cmd.equals("mute"))) {
            List<String> durations = Arrays.asList("1h", "6h", "12h", "1d", "3d", "7d", "30d", "permanent");
            String input = args[1].toLowerCase();
            for (String duration : durations) {
                if (!duration.startsWith(input)) continue;
                completions.add(duration);
            }
            return completions;
        }
        return completions;
    }
}

